;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.3/Llib/reader.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 22 15:23:18 1992                          */
;*    Last change :  Mon Jun  7 09:53:35 1993  (serrano)               */
;*                                                                     */
;*    Le reader de `Bigloo'                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __reader
   (export read))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define read-of-strings
   (let ((grammar (regular-grammar ()
		     ((+ (in #\space #\tab #\newline))
		      (ignore))
		     ((+ (out #\space #\tab #\newline))
		      (the-string)))))
      (lambda input-port
	 (if (null? input-port)
	     (read/rp grammar (current-input-port))
	     (read/rp grammar (car input-port))))))

;*---------------------------------------------------------------------*/
;*    read ...                                                         */
;*---------------------------------------------------------------------*/
(define read
   (let* ((par-open      0)
	  (grammar
	   (regular-grammar ((chiffre (>-< #\0 #\9))
			     (float   (! ((* chiffre) #\. (+ chiffre))
					 ((+ chiffre) #\. (* chiffre))))
			     (lettre  (>-< #\a #\z #\A #\Z))
			     (special (in #\! #\@ #\# #\$ #\%
					  #\^ #\& #\* #\> #\<
					  #\/ #\. #\- #\_ #\+   
					  #\\ #\| #\{ #\= #\?
					  #\} #\: #\~))
			     (quote   (in #\" #\, #\' #\`))
			     (paren   (in #\( #\) #\[ #\]))
			     (blank   (in #\space #\tab #\newline))  
			     (id      (+  (! lettre chiffre special))))
	      ((+ blank)                 ;; on oublie les separateurs
	       (ignore))  
	      ((#\# #\\ (! lettre        ;; Les caracteres normaux
			   chiffre
			   special
			   quote
			   paren
			   ";"))
	       (string-ref (the-string) 2))
	      ((";" (* (all)))           ;; de meme pour les commentaires
	       (ignore))
	      ((uncase "#\newline")      ;; retour charriot
	       #\newline)
	      ((uncase "#\tab")          ;; tabulation
	       #\tab)
	      ((! (uncase "#\space")     ;; espace
		  "#\ ")
	       #\space)
	      ((#\" (* (! (out #\\ #\")  ;; Les chaines de caracteres
			  (#\\ (all)))) #\")
	       (the-small-string))
	      ((#\" (* (! (out #\\ #\")  ;; Les bouts de chaines non termines
			  (#\\ (all)))))
	       (error "read" "Unexpected end-of-file" (the-string)))
	      ((! (+ chiffre)            ;; Les entiers
		  (#\- (+ chiffre))
		  (#\+ (+ chiffre)))
	       (string->integer (the-string) 10))
	      (("#o" (! (+ (>-< #\0 #\7)) ;; Les entiers en base 8
			((in #\+ #\-)
			 (>-< #\0 #\7))))
	       (string->integer (substring (the-string) 2 (the-length)) 8))
	      (("#d" (! (+ chiffre)       ;; Les entiers en base 10
			((in #\+ #\-)
			 chiffre)))
	       (string->integer (substring (the-string) 2 (the-length)) 10))
	      (("#x" (! (+ (! chiffre     ;; Les entiers en base 10
			      (>-< #\a #\f)
			      (>-< #\A #\F)))
		 	((in #\+ #\-)
			 (+ (! chiffre
		 	       (>-< #\a #\f)
			       (>-< #\A #\F))))))
	       (string->integer (substring (the-string) 2 (the-length)) 16))
	      ((! float                  ;; Les reels
		  ((in #\+ #\-) float)
		  ((! float (+ chiffre))
		   (in #\e #\E) (+ chiffre)) 
		  ((in #\+ #\-) (! float (+ chiffre)) (in #\e #\E) (+ chiffre))
		  ((! float (+ chiffre)) (in #\e #\E) (in #\+ #\-) (+ chiffre))
		  ((in #\+ #\-) (! float (+ chiffre))
				(in #\e #\E) (in #\+ #\-) (+ chiffre)))
	       (string->real (the-string)))
	      (pair (#\. (* blank) #\))
		    (error "read" "Illegal pair" (the-string)))
	      (pair (#\.)                ;; Le point des pairs pointees
	       '__dot__)
	      ((#\.)
	       (error "read" "Illegal token" #\.))
	      ((uncase "#t")             ;; true
	       #t)
	      ((uncase "#f")             ;; false
	       #f)
	      ((! id (#\. (+ #\.)))      ;; Les identificateurs
	       (the-symbol))
	      ((#\')                     ;; Les simples quotations
	       (cons 'quote (cons (ignore) '())))
	      ((#\`)                     ;; Les quasiquotes
	       (cons 'quasiquote (cons (ignore) '())))
	      ((#\,)                     ;; Les unquotations
	       (cons 'unquote (cons (ignore) '())))
	      ((#\, #\@)                 ;; Les unquote-splicing
	       (cons 'unquote-splicing (cons (ignore) '())))
	      ((in #\( #\[)              ;; Les parentheses ouvrantes
	       (let ((open-key par-open))
		  (set! par-open (+fx 1 par-open))
		  (context 'pair)
		  (let loop-pair ((walk (ignore))) 
		     (cond
			((eq? walk '__dot__) ;; une pair pointee
			 (context)
			 (let ((cdr (ignore)))
			    (ignore)
			    (if (=fx open-key par-open)
				(begin
				   (context 'pair)
				   cdr)
				(error "read" "Illegal pair" cdr))))
			((=fx open-key par-open)
			 (if (=fx open-key 0)
			     (context))
			 '())
			(else
			 (cons walk (loop-pair (ignore))))))))
	      ((in #\) #\])               ;; Les parentheses fermantes
	       (set! par-open (-fx par-open 1))
	       (if (<fx par-open 0)
		   (begin
		      (set! par-open 0)
		      (ignore))
		   #f))
	      ((#\# #\()                 ;; Les debuts de vecteur
	       (let ((open-key par-open))
		  (set! par-open (+fx 1 par-open))
		  (list->vector (let loop-vector ((walk (ignore)))
				   (cond
				      ((=fx open-key par-open)
				       '())
				      (else
				       (cons walk (loop-vector (ignore)))))))))
	      (else
	       (let ((char (the-failing-char)))
		  (if (eof-object? char)
		      (if (>fx par-open 0)
			  (error "read" "Unexpected end-of-file" char)
			  char)
		      (error "read"
			     "Illegal char"
			     (illegal-char-rep char))))))))
      (lambda input-port
	 (if (null? input-port)
	     (read/rp grammar (current-input-port))
	     (read/rp grammar (car input-port))))))

		      
		 

