;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../pair-list.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 24 15:45:29 1992                          */
;*    Last change :  Fri Jun 25 15:02:56 1993  (serrano)               */
;*                                                                     */
;*    6.3. Pairs ans Lists (page 15, r4)                               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_pairs_and_lists_6_3
   (foreign (define obj     __nil__                "BNIL")
            (define bool    c-pair?    (obj)       "PAIRP")
	    (define bpair   c-cons     (obj obj)   "MAKE_PAIR")
	    (define obj     c-car      (bpair)     "CAR")
	    (define obj     c-cdr      (bpair)     "CDR")
	    (define obj     c-set-car! (bpair obj) "SET_CAR")
	    (define obj     c-set-cdr! (bpair obj) "SET_CDR")
	    (define bool    c-null?    (obj)       "NULLP"))
   (export  (inline pair?    obj)
	    (inline cons     obj1 obj2)
            (inline car      pair)
	    (inline cdr      pair)
	    (inline caar     pair)
	    (inline cadr     pair)
	    (inline cdar     pair)
	    (inline cddr     pair)
	    (inline caaar    pair)
	    (inline caadr    pair)
	    (inline cadar    pair)
	    (inline caddr    pair)
	    (inline cdaar    pair)
	    (inline cddar    pair)
	    (inline cdadr    pair)
	    (inline cdddr    pair)
	    (inline caaaar   pair)
	    (inline caaadr   pair)
	    (inline caadar   pair)
	    (inline cadaar   pair)
	    (inline cdaaar   pair)
	    (inline caaddr   pair)
	    (inline caddar   pair)
	    (inline cadadr   pair)
	    (inline cadddr   pair)
	    (inline cdaadr   pair)
	    (inline cdaddr   pair)
	    (inline cddaar   pair)
	    (inline cdadar   pair)
	    (inline cddadr   pair)
	    (inline cdddar   pair)
	    (inline cddddr   pair)
	    (inline set-car! pair obj)
	    (inline set-cdr! pair obj)
	    (inline null?    obj)
	    (list?           obj)
	    (inline list   . objs)
	    (length          list)
	    (append-2        list1 list2)
	    (append        . lists)
	    (append!         x y)
	    (reverse         list)
	    (list-tail       list k)
	    (list-ref        list k)
	    (last-pair       list)
	    (memq            obj list)
	    (memv            obj list)
	    (member          obj list)
	    (assq            obj alist)
	    (assv            obj alist)
	    (assoc           obj alist)
	    (remq            obj list)
	    (remove          obj list)
	    (remq!           obj list)
	    (remove!         obj list)
	    (reverse!        list)
	    (cons*           x . y))
   (pragma  (c-pair? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-null? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-car   _no_side_effect_ _no_mutation_ _imbricable_)
	    (c-cdr   _no_side_effect_ _no_mutation_ _imbricable_)))

;*---------------------------------------------------------------------*/
;*    pair? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (pair? obj)
   (c-pair? obj))

;*---------------------------------------------------------------------*/
;*    cons ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cons obj1 obj2)
   (c-cons obj1 obj2))

;*---------------------------------------------------------------------*/
;*    car ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (car pair)
   (c-car pair))

;*---------------------------------------------------------------------*/
;*    cdr ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (cdr pair)
   (c-cdr pair))

;*---------------------------------------------------------------------*/
;*    caar ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (caar pair)
   (car (car pair)))

;*---------------------------------------------------------------------*/
;*    cadr ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cadr pair)
   (car (cdr pair)))

;*---------------------------------------------------------------------*/
;*    cdar ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cdar pair)
   (cdr (car pair)))

;*---------------------------------------------------------------------*/
;*    cddr ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (cddr pair)
   (cdr (cdr pair)))

;*---------------------------------------------------------------------*/
;*    caaar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (caaar pair)
   (car (car (car pair))))

;*---------------------------------------------------------------------*/
;*    caadr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (caadr pair)
   (car (car (cdr pair))))

;*---------------------------------------------------------------------*/
;*    cadar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cadar pair)
   (car (cdr (car pair))))

;*---------------------------------------------------------------------*/
;*    caddr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (caddr pair)
   (car (cdr (cdr pair))))

;*---------------------------------------------------------------------*/
;*    cdaar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cdaar pair)
   (cdr (car (car pair))))

;*---------------------------------------------------------------------*/
;*    cddar ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cddar pair)
   (cdr (cdr (car pair))))

;*---------------------------------------------------------------------*/
;*    cdadr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cdadr pair)
   (cdr (car (cdr pair))))

;*---------------------------------------------------------------------*/
;*    cdddr ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cdddr pair)
   (cdr (cdr (cdr pair))))

;*---------------------------------------------------------------------*/
;*    caaaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caaaar pair)
   (car (car (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    caaadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caaadr pair)
   (car (car (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    caadar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caadar pair)
   (car (car (cdr (car pair)))))

;*---------------------------------------------------------------------*/
;*    cadaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cadaar pair)
   (car (cdr (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    cdaaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdaaar pair)
   (cdr (car (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    caaddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caaddr pair)
   (car (car (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    caddar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (caddar pair)
   (car (cdr (cdr (car pair)))))

;*---------------------------------------------------------------------*/
;*    cadadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cadadr pair)
   (car (cdr (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cadddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cadddr pair)
   (car (cdr (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cdaadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdaadr pair)
   (cdr (car (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cdaddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdaddr pair)
   (cdr (car (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cddaar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cddaar pair)
   (cdr (cdr (car (car pair)))))

;*---------------------------------------------------------------------*/
;*    cddadr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cddadr pair)
   (cdr (cdr (car (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    cdadar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdadar pair)
   (cdr (car (cdr (car pair)))))

;*---------------------------------------------------------------------*/
;*    cdddar ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cdddar pair)
   (cdr (cdr (cdr (car pair)))))


;*---------------------------------------------------------------------*/
;*    cddddr ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (cddddr pair)
   (cdr (cdr (cdr (cdr pair)))))

;*---------------------------------------------------------------------*/
;*    set-car! ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (set-car! pair obj)
   (c-set-car! pair obj))

;*---------------------------------------------------------------------*/
;*    set-cdr! ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (set-cdr! pair obj)
   (c-set-cdr! pair obj))

;*---------------------------------------------------------------------*/
;*    null? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (null? obj)
   (c-null? obj))

;*---------------------------------------------------------------------*/
;*    list ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (list . l)
   l)

;*---------------------------------------------------------------------*/
;*    lists? ...                                                       */
;*---------------------------------------------------------------------*/
(define (list? x)
   (labels ((l1 (x prev)
		(cond ((null? x)
		       #t)
		      ((pair? x)
		       (if (eq? x prev)
			   #f
			   (l2 (cdr x) prev)))
		      (else #f)))
	    (l2 (x prev)
		(cond ((null? x)
		       #t)
		      ((pair? x)
		       (if (eq? x prev)
			   #f
			   (l1 (cdr x) (cdr prev))))
		      (else #f))))
      (cond ((null? x)
	     #t)
	    ((pair? x)
	     (l1 (cdr x) x))
	    (else
	     #f))))

;*---------------------------------------------------------------------*/
;*    append-2                                                         */
;*---------------------------------------------------------------------*/
(define (append-2 l1 l2)
   (let ((head (cons '() l2)))
      (labels ((loop (prev tail)
		     (if (null? tail)
			 '()
			 (let ((new-prev (cons (car tail) l2)))
			    (set-cdr! prev new-prev)
			    (loop new-prev (cdr tail))))))
	 (loop head l1)
	 (cdr head))))

;*---------------------------------------------------------------------*/
;*    append ...                                                       */
;*---------------------------------------------------------------------*/
(define (append . l)
   (labels ((append-list (l)
	       (let ((len (length l)))
		  (if (=fx len 0)
		      '()
		      (if (=fx len 1)
			  (car l)
			  (if (=fx len 2)
			      (append-2 (car l)
					(car (cdr l)))
			      (append-2 (car l)
					(append-list (cdr l)))))))))
      (append-list l)))

;*---------------------------------------------------------------------*/
;*    append! ...                                                      */
;*---------------------------------------------------------------------*/
(define (append! x y)
  (if (null? x)
      y
      (do ((a x b)
           (b (cdr x) (cdr b)))
          ((null? b)
           (set-cdr! a y)
           x))))

;*---------------------------------------------------------------------*/
;*    length ...                                                       */
;*---------------------------------------------------------------------*/
(define (length list)
   (let loop ((l    list)
	      (res  0))
      (cond
	 ((null? l)
	  res)
	 (else
	  (loop (cdr l) (+fx 1 res))))))
 
;*---------------------------------------------------------------------*/
;*    reverse ...                                                      */
;*---------------------------------------------------------------------*/
(define (reverse l)
   (let loop ((l   l)
	      (acc '()))
      (if (null? l)
	  acc
	  (loop (cdr l) (cons (car l) acc)))))

;*---------------------------------------------------------------------*/
;*    list-tail ...                                                    */
;*---------------------------------------------------------------------*/
(define (list-tail list k)
   (if (zerofx? k)
       list
       (list-tail (cdr list) (-fx k 1))))

;*---------------------------------------------------------------------*/
;*    list-ref ...                                                     */
;*---------------------------------------------------------------------*/
(define (list-ref list k)
   (if (zerofx? k)
       (car list)
       (list-ref (cdr list) (-fx k 1))))

;*---------------------------------------------------------------------*/
;*    last-pair ...                                                    */
;*---------------------------------------------------------------------*/
(define (last-pair x)
   (if (pair? (cdr x))
       (last-pair (cdr x))
       x))

;*---------------------------------------------------------------------*/
;*    memq ...                                                         */
;*---------------------------------------------------------------------*/
(define (memq obj list)
   (let loop ((list list))
      (if (null? list)
	  #f
	  (if (eq? (car list) obj)
	      list
	      (loop (cdr list))))))

;*---------------------------------------------------------------------*/
;*    memv ...                                                         */
;*---------------------------------------------------------------------*/
(define (memv obj list)
   (let loop ((list list))
      (if (null? list)
	  #f
	  (if (eqv? (car list) obj)
	      list
	      (loop (cdr list))))))

;*---------------------------------------------------------------------*/
;*    member ...                                                       */
;*---------------------------------------------------------------------*/
(define (member obj list)
   (let loop ((list list))
      (cond
	 ((null? list) #f)
	 ((equal? obj (car list)) list)
	 (else (loop (cdr list))))))

;*---------------------------------------------------------------------*/
;*    assq ...                                                         */
;*---------------------------------------------------------------------*/
(define (assq obj alist)
   (let loop ((alist alist))
      (if (null? alist)
          #f
          (if (eq? (car (car alist)) obj)
              (car alist)
              (loop (cdr alist))))))

;*---------------------------------------------------------------------*/
;*    assv ...                                                         */
;*---------------------------------------------------------------------*/
(define (assv obj alist)
   (let loop ((alist alist))
      (if (null? alist)
          #f
          (if (eqv? (car (car alist)) obj)
              (car alist)
              (loop (cdr alist))))))

;*---------------------------------------------------------------------*/
;*    assoc ...                                                        */
;*---------------------------------------------------------------------*/
(define (assoc obj alist)
    (if (not (null? alist))
        (let ((cary (car alist)))
           (if (equal? obj (car cary))
	       cary
	       (assoc obj (cdr alist))))
        #f))

;*---------------------------------------------------------------------*/
;*    Toutes les fonctions qui suivent ne sont pas dans le r4          */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    remq ...                                                         */
;*---------------------------------------------------------------------*/
(define (remq x y)
   (cond
      ((null? y) y)
      ((eq? x (car y)) (remq x (cdr y)))
      (else (cons (car y) (remq x (cdr y))))))

;*---------------------------------------------------------------------*/
;*    remove ...                                                       */
;*---------------------------------------------------------------------*/
(define (remove x y)
   (cond
      ((null? y) y)
      ((equal? x (car y)) (remove x (cdr y)))
      (else (cons (car y) (remove x (cdr y))))))

;*---------------------------------------------------------------------*/
;*    remq! ...                                                        */
;*---------------------------------------------------------------------*/
(define (remq! x y)
   (cond
      ((null? y) y)
      ((eq? x (car y)) (remq! x (cdr y)))
      (else (let loop ((prev y))
               (cond ((null? (cdr prev))
                      y)
                     ((eq? (cadr prev) x)
                      (set-cdr! prev (cddr prev))
                      (loop prev))
                     (else (loop (cdr prev))))))))

;*---------------------------------------------------------------------*/
;*    remove! ...                                                      */
;*---------------------------------------------------------------------*/
(define (remove! x y)
   (cond
      ((null? y) y)
      ((equal? x (car y)) (remove! x (cdr y)))
      (else (let loop ((prev y))
               (cond ((null? (cdr prev))
                      y)
                     ((equal? (cadr prev) x)
                      (set-cdr! prev (cddr prev))
                      (loop prev))
                     (else (loop (cdr prev))))))))

;*---------------------------------------------------------------------*/
;*    cons* ...                                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction n'est pas r4 mais elle est bien pratique          */
;*---------------------------------------------------------------------*/
(define (cons* x . y)
   (labels ((cons*1 (x) (cond ((null? (cdr x))
			       (car x))
			      (else
			       (cons (car x) (cons*1 (cdr x)))))))
      (if (null? y)
	  x
          (cons x (cons*1 y)))))

;*---------------------------------------------------------------------*/
;*    reverse! ...                                                     */
;*---------------------------------------------------------------------*/
(define (reverse! l)
  (if (pair? l)
       (let nr ((l l)
		(r '()))
          (if (null? (cdr l))
              (begin
                 (set-cdr! l r)
                 l)
	      (let ((cdrl (cdr l)))
		 (nr cdrl
		     (begin (set-cdr! l r) l)))))
       l))

   
