;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.3/Llib/output.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:13:01 1992                          */
;*    Last change :  Mon Jun  7 10:04:33 1993  (serrano)               */
;*                                                                     */
;*    6.10.3 Output (page 31, r4)                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_output_6_10_3
   (foreign (define obj c-write-char   (bchar boutput-port)   "WRITE_CHAR")
	    (obj        c-write_char   (bchar boutput-port)   "write_char")
	    (obj        c-ill-char-rep  (bchar)               "ill_char_rep")
	    (obj        c-write-object (obj boutput-port)     "write_object")
	    (obj        c-write-string (bstring boutput-port) "write_string"))
   (export  (newline          . port)
	    (write            obj . port)
	    (display          obj . port)
	    (write-char       obj . port)
	    (illegal-char-rep char)
	    (display*         . obj)
	    (write*           . obj)
	    (print            . obj)
	    (fprint     port . obj)))

;*---------------------------------------------------------------------*/
;*    newline ...                                                      */
;*---------------------------------------------------------------------*/
(define (newline . port)
   (c-write-char #\Newline
		 (if (or (null? port)
			  (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    display ...                                                      */
;*---------------------------------------------------------------------*/
(define (display obj . port)
   (write/display obj
		  (if (or (null? port)
			  (not (output-port? (car port))))
		      (current-output-port)
		      (car port))
		  'display))
 
;*---------------------------------------------------------------------*/
;*    write ...                                                        */
;*---------------------------------------------------------------------*/
(define (write obj . port)
   (write/display obj
		  (if (or (null? port)
			  (not (output-port? (car port))))
		      (current-output-port)
		      (car port))
		  'write))

;*---------------------------------------------------------------------*/
;*    write-char ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-char char . port)
   (c-write-char char
		 (if (or (null? port)
			 (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    illegal-char-rep ...                                             */
;*---------------------------------------------------------------------*/
(define (illegal-char-rep char)
   (c-ill-char-rep char))

;*---------------------------------------------------------------------*/
;*    write/display ...                                                */
;*---------------------------------------------------------------------*/
(define (write/display obj port flag)
   (cond
      ((struct? obj)
       (write/display-structure obj port flag))
      ((vector? obj)
       (write/display-vector obj port flag))
      ((pair? obj)
       (write/display-pair obj port flag))
      ((and (eq? flag 'write) (string? obj))
       (c-write-string obj port))
      ((and (eq? flag 'write) (char? obj))
       (c-write_char obj port))
      (else
       (c-write-object obj port))))

;*---------------------------------------------------------------------*/
;*    write/display-structure ...                                      */
;*---------------------------------------------------------------------*/
(define (write/display-structure obj port flag)
   (c-write-char #\# port)
   (c-write-char #\{ port)
   (c-write-object (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       (c-write-char #\} port)
       (let ((len (-fx (struct-length obj) 1)))
	  (c-write-char #\space port)
	  (let loop ((i 0))
	     (if (=fx i len)
		 (begin
		    (write/display (struct-ref obj i) port flag)
		    (c-write-char #\} port))
		 (begin
		    (write/display (struct-ref obj i) port flag)
		    (c-write-char #\space port)
		    (loop (+fx 1 i))))))))
   
;*---------------------------------------------------------------------*/
;*    write/display-vector ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-vector obj port flag)
   (c-write-char #\# port)
   (c-write-char #\( port)
   (if (=fx 0 (vector-length obj))
       (c-write-char #\) port)
       (let ((len (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (if (=fx i len)
		 (begin
		    (write/display (vector-ref obj i) port flag)
		    (c-write-char #\) port))
		 (begin
		    (write/display (vector-ref obj i) port flag)
		    (c-write-char #\space port)
		    (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-pair ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-pair obj port flag)
   (c-write-char #\( port)
   (let loop ((l obj))
      (cond
	 ((null? (cdr l))
	  (write/display (car l) port flag)
	  (c-write-char #\) port))
	 ((not (pair? (cdr l)))
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (c-write-char #\. port)
	  (c-write-char #\space port)
	  (write/display (cdr l) port flag)
	  (c-write-char #\) port))
	 (else
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    Les fonctions qui suivent ne sont pas r4                         */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    print ...                                                        */
;*---------------------------------------------------------------------*/
(define (print . obj)
   (let ((port (current-output-port)))
      (let loop ((l    obj)
		 (res '()))
	 (if (null? l)
	     (begin
		(c-write-char #\Newline port)
		res)
	     (let ((v (car l)))
		(write/display (car l) port 'display)
		(loop (cdr l) v))))))

;*---------------------------------------------------------------------*/
;*    display* ...                                                     */
;*---------------------------------------------------------------------*/
(define (display* . obj)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     'done
	     (let ((v (car l)))
		(write/display (car l) port 'display)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    write* ...                                                       */
;*---------------------------------------------------------------------*/
(define (write* . obj)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     'done
	     (let ((v (car l)))
		(write/display (car l) port 'write)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    fprint ...                                                       */
;*---------------------------------------------------------------------*/
(define (fprint port . obj)
   (let loop ((l    obj)
	      (res '()))
      (if (null? l)
	  (begin
	     (c-write-char #\Newline port)
	     res)
	  (let ((v (car l)))
	     (write/display (car l) port 'display)
	     (loop (cdr l) v)))))



