;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expd-struct.scm ...                                          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 11:48:02 1992                          */
;*    Last change :  Thu May  6 15:03:03 1993  (serrano)               */
;*                                                                     */
;*    L'expansion des des define-struct                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_struct
   (import (__expander "Llib/expander.scm"))
   (export (expand-eval-define-struct x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-define-struct ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-struct x e)
   (match-case x
      ((?- ?name . ?slots)
       (let ((len (length slots)))
	  (cons
	   'begin
	   (cons
	    ;; on genere l'inline MAKE-???
	    (e `(define-inline (,(symbol-append 'make- name) . init)
		   (make-struct ',name ,len (if (null? init)
						'()
						(car init))))
	       e)
	    (cons
	     ;; on genere le predicat STRUCT?
	     (e `(define-inline (,(symbol-append name '?) o)
		    (if (and (struct? o)
			     (eq? (struct-key o) ',name))
			#t #f))
		e)
	     ;; on genere les fonctions d'access aux slot
	     (let loop ((i     0)
			(slots slots)
			(res   '()))
		(if (=fx i len)
		    res
		    (let ((pr (car slots)))
		       (loop (+fx i 1)
			     (cdr slots)
			     (cons
			      ;; la lecture
			      (e `(define-inline
				     (,(symbol-append name '- pr) s)
				     (if (,(symbol-append name '?) s)
					 (struct-ref s ,i)
					 (error "struct-ref"
						"not an instance of"
						,(symbol->string
						  name))))
				 e)
			      (cons
			       ;; l'ecriture
			       (e `(define-inline
				      (,(symbol-append name '- pr '-set!) s v)
				      (if (,(symbol-append name '?) s)
					  (struct-set! s ,i v)
					  (error "struct-set!"
						 "not an instance of"
						 ,(symbol->string
						   name))))
				  
				  e)
			       res)))))))))))
      (else
       (error "define-struct" "Illegal form" x))))
 
       
