;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expd-bool.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  4 17:12:21 1993                          */
;*    Last change :  Wed Apr 28 11:28:26 1993  (serrano)               */
;*                                                                     */
;*    Les expanseurs des formes booleenes.                             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_bool
   (import (__expander "Llib/expander.scm"))
   (export (expand-eval-or   x)  
	   (expand-eval-and  x)
	   (expand-eval-cond x)))

;*---------------------------------------------------------------------*/
;*    get-new-test-name ...                                            */
;*---------------------------------------------------------------------*/
(define get-new-test-name
   (let ((counter -1))
      (lambda (string)
	 (set! counter (+fx 1 counter))
	 (string->symbol (string-append "_" string "test_"
					(integer->string counter))))))

;*---------------------------------------------------------------------*/
;*    expand-eval-or ...                                               */
;*---------------------------------------------------------------------*/
(define (expand-eval-or exp)
   (let loop ((sor (cdr exp)))
      (cond
	 ((null? sor)
	  #f)
	 ((null? (cdr sor))
	  (car sor))
	 (else
	  (let ((test (get-new-test-name "or")))
	     `(let ((,test ,(car sor)))
		 (if ,test ,test ,(loop (cdr sor)))))))))

;*---------------------------------------------------------------------*/
;*    expand-eval-and ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-eval-and exp)
   (let loop ((sand (cdr exp)))
      (cond
	 ((null? sand)
	  #t)
	 ((null? (cdr sand))
	  (car sand))
	 (else
	  (let ((test (get-new-test-name "and")))
	     `(let ((,test ,(car sand)))
		 (if ,test ,(loop (cdr sand)) #f)))))))

;*---------------------------------------------------------------------*/
;*    expand-eval-cond ...                                             */
;*---------------------------------------------------------------------*/
(define (expand-eval-cond exp)
   (let* ((clauses  (cdr exp))
	  (clause1  (if (pair? clauses)
			(car clauses)
			'()))
	  (clause2+ (if (pair? clause1)
			(cdr clauses)
			#f)))
      (cond
	 ((null? clause1)
	  '#f)
	 ((or (not (pair? clause1)) (equal? clause1 '(else)))
	  (error "cond-clause" "Illegal form" exp))
	 ((null? (cdr clause1))
	  `(or ,(car clause1) (cond ,@clause2+)))
	 ((and (eq? (cadr clause1) '=>) (=fx (length clause1) 3))
	  `(let ((test-result ,(car clause1))
		 (thunk2 (lambda () ,(caddr clause1)))
		 (thunk3 (lambda () (cond ,@clause2+))))
	      (if test-result ((thunk2) test-result) (thunk3))))
	 ((eq? (car clause1) 'else)
	  (normalize-progn (cdr clause1)))
	 (else `(if ,(car clause1)
		    ,(normalize-progn (cdr clause1))
		    (cond ,@clause2+))))))
