;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.2/Llib/expander.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Sep  3 10:47:46 1992                          */
;*    Last change :  Wed Apr 28 11:13:00 1993  (serrano)               */
;*                                                                     */
;*    Les expanders                                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander
   (export (normalize-progn   x)
	   (expand-eval-quote x e)
	   (quasiquotation    d x)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    Cette fonction doit etre utilisee pour normalise du code         */
;*    utilisateur tel qu'il est lu par le lecteur.                     */
;*---------------------------------------------------------------------*/
(define (normalize-progn body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      (else
       `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
				      (cdr body)
				      body)))
		    (if (null? body)
			'()
			(let ((expr (car body)))
			   (if (and (pair? expr) (eq? (car expr) 'begin))
			       (append (cdr expr) (loop (cdr body)))
			       (cons expr (loop (cdr body)))))))))))

;*---------------------------------------------------------------------*/
;*    expand-eval-quote ...                                            */
;*---------------------------------------------------------------------*/
(define (expand-eval-quote x e)
   (if (null? (cdr x))
       (error "quote" "Illegal form" x)
       `(quote ,(cadr x))))

;*---------------------------------------------------------------------*/
;*    quasiquotation ...                                               */
;*---------------------------------------------------------------------*/
(define (quasiquotation d exp)
    (if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	(template d (cadr exp))
	(error "quasiquotation" "illegal form" exp)))

;*---------------------------------------------------------------------*/
;*    template ...                                                     */
;*---------------------------------------------------------------------*/
(define (template d exp)
    (cond ((=fx d 0)
	   exp)
	  ((and (pair? exp) (eq? (car exp) 'unquote))
	   (if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	       (if (eq? d 1)
		   (template (-fx d 1) (cadr exp))
		   (list 'list ''unquote (template (-fx d 1) (cadr exp))))
	       (error "unquote" "Illegal form" (cadr exp))))
	  ((vector? exp)
	   (vector-template d exp))
	  ((pair? exp)
	   (list-template d exp))
	  ((or (char? exp) (integer? exp) (string? exp))
	   exp)
	  (else
	   (list 'quote exp))))

;*---------------------------------------------------------------------*/
;*    list-template ...                                                */
;*---------------------------------------------------------------------*/
(define (list-template d exp)
    (cond ((and (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
		(eq? (car exp) 'quote) (pair? (cadr exp))
		(eq? (car (cadr exp)) 'quasiquote))
	   (quasiquotation d (cadr exp)))
	  ((eq? (car exp) 'quasiquote)
	   (if (eq? d 0)
	       (quasiquotation (+ d 1) exp)
	       (list 'list ''quasiquote (quasiquotation (+ d 1) exp))))
	  (else (cons 'cons* (template-or-splice-list d exp)))))

;*---------------------------------------------------------------------*/
;*    vector-template ...                                              */
;*---------------------------------------------------------------------*/
(define (vector-template d exp)
    (list 'list->vector
	  (cons 'cons* (template-or-splice-list d (vector->list exp)))))

;*---------------------------------------------------------------------*/
;*    template-or-splice-list ...                                      */
;*---------------------------------------------------------------------*/
(define (template-or-splice-list d exp)
    (cond ((null? exp) '('()))
	  ((pair? exp)
	   (cond ((eq? (car exp) 'unquote)
		  (list (template d exp)))
		 ((and (pair? (car exp)) (eq? (car (car exp))
					      'unquote-splicing))
		  (list (list 'append
			      (template-or-splice d (car exp))
			      (cons 'cons*
				    (template-or-splice-list d (cdr exp))))))
		 (else (cons (template-or-splice d (car exp))
			     (template-or-splice-list d (cdr exp))))))
	  (else (list (template-or-splice d exp)))))

;*---------------------------------------------------------------------*/
;*    template-or-splice ...                                           */
;*---------------------------------------------------------------------*/
(define (template-or-splice d exp)
    (if (and (pair? exp) (eq? (car exp) 'unquote-splicing))
	(if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	    (if (eq? d 1)
		(template (-fx d 1) (cadr exp))
		(list 'list (list 'list ''unquote-splicing
				  (template (-fx d 1) (cadr exp)))))
	    (error "unquote-splicing" "Illegal form" exp))
	(template d exp)))

