;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../evmeaning.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  8 15:18:57 1993                          */
;*    Last change :  Fri Jul  2 12:02:07 1993  (serrano)               */
;*                                                                     */
;*    L'interprete de byte-code                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __evmeaning
  (import (__evcomp "Llib/evcomp.scm"))
  (export (evmeaning           exp)
	  (_evmeaning-internal byte-code run-stack)
	  the-global-environment
	  (init-the-global-environment!)
	  (extend-env          extend old-env)
	  (define-primop!      var val)
	  (define-primop-ref!  var addr)
	  (update-global!      variable val run-stack)
	  (evlookup            var env)))
	   
;*---------------------------------------------------------------------*/
;*    the-global-environment                                           */
;*---------------------------------------------------------------------*/
(define the-global-environment the-global-environment)

;*---------------------------------------------------------------------*/
;*    define-primop! ...                                               */
;*    -------------------------------------------------------------    */
;*    Cette fonction est juste une forme abregee de la precedente, qui */
;*    construit le `(lambda () ...)' absent                            */
;*---------------------------------------------------------------------*/
(define (define-primop! var val)
   (set-cdr! the-global-environment
	     (cons (car the-global-environment)
		   (cdr the-global-environment)))
   (set-car! the-global-environment (vector 0 var val)))

;*---------------------------------------------------------------------*/
;*    define-primop-ref! ...                                           */
;*    -------------------------------------------------------------    */
;*    Cette fonction est juste une forme abregee de la precedente, qui */
;*    construit le `(lambda () ...)' absent                            */
;*---------------------------------------------------------------------*/
(define (define-primop-ref! var addr)
   (set-cdr! the-global-environment
	     (cons (car the-global-environment)
		   (cdr the-global-environment)))
   (set-car! the-global-environment (vector 1 var addr)))

;*---------------------------------------------------------------------*/
;*      update-global! ...                                             */
;*---------------------------------------------------------------------*/
(define (update-global! variable val run-stack)
   (let ((value (_evmeaning-internal val run-stack)))
      (if (eq? (global-tag variable) 1)
	  (location-set! (global-value variable) value)
	  (set-global-value! variable value))
      (global-name variable)))

;*---------------------------------------------------------------------*/
;*    extend-env ...                                                   */
;*---------------------------------------------------------------------*/
(define (extend-env extend old-env)
   (let _loop_ ((extend extend))
      (cond
	 ((null? extend)
	  old-env)
	 ((not (pair? extend))
	  (cons extend old-env))
	 (else
	  (cons (car extend) (_loop_ (cdr extend)))))))

;*---------------------------------------------------------------------*/
;*    Les environments ...                                             */
;*---------------------------------------------------------------------*/
(init-the-global-environment!)
       
;*---------------------------------------------------------------------*/
;*    init-the-global-environment! ...                                 */
;*---------------------------------------------------------------------*/
(define (init-the-global-environment!)
   (if (pair? the-global-environment)
       'done
       ;; je ne peux pas utiliser de constante car quand cette fonction
       ;; sera appellee, je ne suis pas sur que le module soit deja
       ;; initialise.
       (set! the-global-environment (cons (vector #f #f) '()))))

;*---------------------------------------------------------------------*/
;*    evmeaning ...                                                    */
;*---------------------------------------------------------------------*/
(define (evmeaning exp)
   (_evmeaning-internal (compile (expand exp) '() #f) '()))

;*---------------------------------------------------------------------*/
;*    _evmeaning-internal ...                                          */
;*---------------------------------------------------------------------*/
(define (_evmeaning-internal byte-code run-stack)
   (case (car byte-code)
      ((-9) ;; nil
       (error "eval" "Illegal form" '()))
      ((-2) ;; null
       '())
      ((-3) ;; faux
       #f)
      ((-4) ;; vrai
       #t)
      ((-5) ;; 1
       1)
      ((-6) ;; 0
       0)
      ((-7) ;; -1
       -1)
      ((-8) ;; 2
       2)
      ((-1) ;; les constantes
       (cdr byte-code))
;*---------------------------------------------------------------------*/
;*    Pour que les references soient plus performantes, j'utilise      */
;*    les `car' et `cdr' qui ne testent pas le type de leur argument.  */
;*---------------------------------------------------------------------*/
      ((0) ;; la premiere variable de l'env
       (c-car run-stack))
      ((1) ;; la deuxieme
       (c-car (c-cdr run-stack)))
      ((2) ;; la troisieme
       (c-car (c-cdr (c-cdr run-stack))))
      ((3) ;; la quatrieme
       (c-car (c-cdr (c-cdr (c-cdr run-stack)))))
      ((4) ;; une variable qui est loin dans l'environment
       (let ((offset (c-cdr byte-code)))
	  (do ((i 0 (+fx i 1))
	       (env run-stack (c-cdr env)))
		((=fx i offset) (c-car env)))))
      ((5) ;; une variable globale
       (global-value (cdr byte-code)))
      ((6) ;; les variables globales indefinies
       (let ((found (cadr byte-code)))
	  (if (global? found)
	      (global-value found)
	      (let ((global (evlookup (cddr byte-code)
				      the-global-environment)))
		 (if (global? global)
		     (begin
			(set-car! (cdr byte-code) global)
			(global-value global))
		     (error "eval"
			    "Unbound variable"
			    (cddr byte-code)))))))
      ((7) ;; l'affectation de la premiere variable de l'env
       (let ((val (_evmeaning-internal (cdr byte-code) run-stack)))
	  (set-car! run-stack val)
	  val))
      ((8) ;; l'affectation de la deuxieme variable de l'env
       (let ((val (_evmeaning-internal (cdr byte-code) run-stack)))
	  (set-car! (cdr run-stack) val)
	  val))
      ((9) ;; l'affectation de la troisieme variable de l'env
       (let ((val (_evmeaning-internal (cdr byte-code) run-stack)))
	  (set-car! (cddr run-stack) val)
	  val))   
      ((10) ;; l'affectation de la quatrieme variable de l'env
       (let ((val (_evmeaning-internal (cdr byte-code) run-stack)))
	  (set-car! (cdddr run-stack) val)
	  val))
      ((11) ;; l'affectation de la nieme variable de l'env
       (let ((val    (_evmeaning-internal (cddr byte-code) run-stack))
	     (offset (cadr byte-code)))
	  (do ((i 0 (+fx i 1))
	       (env run-stack (cdr env)))
		((=fx i offset) (set-car! env val)))
	  val))
      ((12) ;; l'affectation des variables globales
       (update-global! (cadr byte-code) (cddr byte-code) run-stack)
       (unspecified))
      ((13) ;; l'affectation des variables globales non definies
       (let ((found (cadr byte-code))
	     (var   (caddr byte-code))
	     (value (cdddr byte-code)))
	  (if (global? found)
	      (update-global! found value run-stack)
	      (let ((global (evlookup (dynamic-name variable)
				      the-global-environment)))
		 (if (global? global)
		     (begin
			(set-car! (cdr byte-code) global)
			(update-global! found value run-stack))
		     (error "eval"
			    "Unbound variable"
			    (dynamic-name variable))))))
       (unspecified))
      ((14) ;; if
       (if (_evmeaning-internal (cadr byte-code) run-stack)
	   (_evmeaning-internal (caddr byte-code) run-stack)
	   (_evmeaning-internal (cdddr byte-code) run-stack)))
      ((15) ;; begin
       (let _loop_ ((body (cdr byte-code)))
	  (if (null? (cdr body))
	      (_evmeaning-internal (car body) run-stack)
	      (begin
		 (_evmeaning-internal (car body) run-stack)
		 (_loop_ (cdr body))))))
      ((16) ;; define
       (cdr byte-code))
      ((17) ;; lambda-0
       (let ((lam (cdr byte-code)))
	  (lambda ()
	     (_evmeaning-internal lam run-stack))))
      ((18) ;; lambda-1
       (let ((lam (cdr byte-code)))
	  (lambda (x)
	     (_evmeaning-internal lam (cons x run-stack)))))
      ((19) ;; lambda-2
       (let ((lam (cdr byte-code)))
	  (lambda (x y)
	     (_evmeaning-internal lam (cons x (cons y run-stack))))))
      ((20) ;; lambda-3
       (let ((lam (cdr byte-code)))
	  (lambda (x y z)
	     (_evmeaning-internal lam
		      (cons x (cons y (cons z run-stack)))))))
      ((21) ;; lambda-4
       (let ((lam (cdr byte-code)))
	  (lambda (x y z t)
	     (_evmeaning-internal lam
		      (cons x (cons y (cons z (cons t run-stack))))))))
      ((22) ;; lambda--1
       (let ((lam (cdr byte-code)))
	  (lambda x
	     (_evmeaning-internal lam
		      (cons x run-stack)))))
      ((23) ;; lambda--2
       (let ((lam (cdr byte-code)))
	  (lambda (x . y)
	     (_evmeaning-internal lam
		      (cons x (cons y run-stack))))))
      ((24) ;; lambda--3
       (let ((lam (cdr byte-code)))
	  (lambda (x y . z)
	     (_evmeaning-internal lam
		      (cons x (cons y (cons z run-stack)))))))
      ((25) ;; lambda--4
       (let ((lam (cdr byte-code)))
	  (lambda (x y z . t)
	     (_evmeaning-internal lam
		      (cons x (cons y (cons z (cons t run-stack))))))))
      ((26) ;; lambda-n
       (lambda x
	  (let ((new-env (let _loop_ ((actuals x)
				      (formals (cadr byte-code)))
			    (cond
			       ((null? formals)
				(if (not (null? actuals))
				    (error "eval"
					   "Too many arguments provided"
					   actuals)
				    run-stack))
			       ((null? actuals)
				(error "eval"
				       "Too fee arguments provided"
				       formals))
			       ((not (pair? formals))
				(cons actuals run-stack))
			       (else
				(cons (car actuals)
				      (_loop_ (cdr actuals)
					      (cdr formals))))))))
	     (_evmeaning-internal (cddr byte-code) new-env))))
      ((27) ;; app-0
       ((global-value (cadr byte-code))))
      ((28) ;; app-1
       ((global-value (cadr byte-code))
	(_evmeaning-internal (caddr byte-code) run-stack)))
      ((29) ;; app-2
       ((global-value (cadr byte-code))
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)))
      ((30) ;; app-3
       ((global-value (cadr byte-code))
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)
	(_evmeaning-internal (cadddr (cdr byte-code)) run-stack)))
      ((31) ;; app-4
       ((global-value (cadr byte-code))
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)
	(_evmeaning-internal (cadddr (cdr byte-code)) run-stack)
	(_evmeaning-internal (cadddr (cddr byte-code))
		 run-stack)))
      ((32) ;; app-n
       (apply (global-value (cadr byte-code))
	      (map (lambda (v)
		      (_evmeaning-internal v run-stack))
		   (cddr byte-code))))
      ((33) ;; app-0
       ((cadr byte-code)))
      ((34) ;; app-1
       ((cadr byte-code) (_evmeaning-internal (caddr byte-code) run-stack)))
      ((35) ;; app-2
       ((cadr byte-code) (_evmeaning-internal (caddr byte-code) run-stack)
			 (_evmeaning-internal (cadddr byte-code) run-stack)))
      ((36) ;; app-3
       ((cadr byte-code) (_evmeaning-internal (caddr byte-code) run-stack)
			 (_evmeaning-internal (cadddr byte-code) run-stack)
			 (_evmeaning-internal (cadddr (cdr byte-code)) run-stack)))
      ((37) ;; app-4
       ((cadr byte-code) (_evmeaning-internal (caddr byte-code) run-stack)
			 (_evmeaning-internal (cadddr byte-code) run-stack)
			 (_evmeaning-internal (cadddr (cdr byte-code)) run-stack)
			 (_evmeaning-internal (cadddr (cddr byte-code)) run-stack)))
      ((38) ;; app-n
       (apply (cadr byte-code) (map (lambda (v)
				       (_evmeaning-internal v run-stack))
				    (cddr byte-code))))
      ((39) ;; app-0
       ((_evmeaning-internal (cadr byte-code) run-stack)))
      ((40) ;; app-1
       ((_evmeaning-internal (cadr byte-code) run-stack)
	(_evmeaning-internal (caddr byte-code) run-stack)))
      ((41) ;; app-2
       ((_evmeaning-internal (cadr byte-code) run-stack)
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)))
      ((42) ;; app-3
       ((_evmeaning-internal (cadr byte-code) run-stack)
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)
	(_evmeaning-internal (cadddr (cdr byte-code)) run-stack)))
      ((43) ;; app-4
       ((_evmeaning-internal (cadr byte-code) run-stack)
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)
	(_evmeaning-internal (cadddr (cdr byte-code)) run-stack)
	(_evmeaning-internal (cadddr (cddr byte-code)) run-stack)))
      ((44) ;; app-n
       (apply (_evmeaning-internal (cadr byte-code) run-stack)
	      (map (lambda (v)
		      (_evmeaning-internal v run-stack))
		   (cddr byte-code))))
      ((45) ;; app-0
       ((location-ref (global-value (cadr byte-code)))))
      ((46) ;; app-1
       ((location-ref (global-value (cadr byte-code)))
	(_evmeaning-internal (caddr byte-code) run-stack)))
      ((47) ;; app-2
       ((location-ref (global-value (cadr byte-code)))
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)))
      ((48) ;; app-3
       ((location-ref (global-value (cadr byte-code)))
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)
	(_evmeaning-internal (cadddr (cdr byte-code)) run-stack)))
      ((49) ;; app-4
       ((location-ref (global-value (cadr byte-code)))
	(_evmeaning-internal (caddr byte-code) run-stack)
	(_evmeaning-internal (cadddr byte-code) run-stack)
	(_evmeaning-internal (cadddr (cdr byte-code)) run-stack)
	(_evmeaning-internal (cadddr (cddr byte-code))
		 run-stack)))
      ((50) ;; app-n
       (apply (location-ref (global-value (cadr byte-code)))
	      (map (lambda (v)
		      (_evmeaning-internal v run-stack))
		   (cddr byte-code))))
      ((51) ;; location-ref
       (location-ref (global-value (cdr byte-code))))
      ((52) ;; unspecified
       (unspecified))
      ((53) ;; bind-exit
       (bind-exit (__dummy__)
		  ((_evmeaning-internal (cdr byte-code) run-stack)
		   __dummy__)))))

;*---------------------------------------------------------------------*/
;*    evlookup ...                                                     */
;*---------------------------------------------------------------------*/
(define (evlookup var env)
   (let loop ((env env))
      (cond
	 ((null? env)
	  #f)
	 ((eq? (global-name (car env)) var)
	  (car env))
	 (else
	  (loop (cdr env))))))

