;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.3/Llib/evcomp.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May  7 08:08:47 1993                          */
;*    Last change :  Thu Jun 10 09:41:41 1993  (serrano)               */
;*                                                                     */
;*    La pre-compilation des expressions a evaluer                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __evcomp
   (import (__evmeaning "Llib/evmeaning.scm"))
   (export (compile                  exp env tail?)
	   (inline global?           exp)
	   (inline global-value      global)
	   (inline global-name       global)
	   (inline global-tag        global)
	   (inline set-global-value! global value)
	   (inline dynamic?          variable)
	   (inline dynamic-name      variable)
	   *afile-list*
	   (variable                 symbol env)))

;*---------------------------------------------------------------------*/
;*    compile ...                                                      */
;*    s-exp x env x { t, f } --> (lambda () ...)                       */
;*    -------------------------------------------------------------    */
;*    La phase d'expansion a genere une syntaxe correcte. On n'a donc  */
;*    plus du tout a la tester maintenant.                             */
;*---------------------------------------------------------------------*/
(define (compile exp env tail?)
   (match-case exp
      (()
       '(-9))
      ((module ?- . ?decls)
       (module-declaration! decls)
       '(52))
      ((atom ?atom)
       (cond
	  ((symbol? atom)
	   (compile-ref (variable atom env) tail?))
	  (else
	   (compile-cnst atom tail?))))
      ((quote ?cnst)
       (compile-cnst cnst tail?))
      ((if ?si ?alors ?sinon)
       (compile-if (compile si env #f)
		  (compile alors env tail?)
		  (compile sinon env tail?)))
      ((begin . ?rest)
       (compile-begin rest env))
      (((or define define-inline) ?var ?val)
       (compile-define var (lambda () (compile val '() #f))))
      ((set! ?var ?val)
       (compile-set (variable var env) (compile val env #f)))
      ((bind-exit ?escape ?body)
       `(53 . ,(compile `(lambda ,escape ,body)
		       env
		       tail?)))
      ((lambda ?formals ?body)
       (compile-lambda formals
		       (compile body (extend-env formals env) #t)
		       tail?))
      (((atom ?fun) . ?args)
       (let ((actuals (map (lambda (a) (compile a env #f)) args)))
	  (cond
	     ((symbol? fun)
	      (let ((proc (variable fun env)))
		 (cond
		    ((global? proc)
		     (compile-global-application proc
						actuals
						tail?))
		    (else
		     (compile-application (compile-ref proc #f)
					 actuals
					 tail?)))))
	     ((procedure? fun)
	      (compile-compiled-application fun actuals tail?))
	     (else
	      (error "eval" "Not a procedure" fun)))))
      ((?fun . ?args)
       (let ((actuals (map (lambda (a) (compile a env #f)) args))
	     (proc    (compile fun env #f)))
	  (compile-application proc actuals tail?)))
      (else
       (error "eval" "Illegal form" exp))))
   
;*---------------------------------------------------------------------*/
;*    module-declaration! ...                                          */
;*---------------------------------------------------------------------*/
(define (module-declaration! decls)
   (let loop ((decls decls))
      (cond
	 ((null? decls)
	  'done)
	 ((not (pair? (car decls)))
	  (error "eval" "Illegal module declaration" decls))
	 ((eq? (car (car decls)) 'include)
	  (include! (cdr (car decls)))
	  (loop (cdr decls)))
	 ((eq? (car (car decls)) 'import)
	  (import! (cdr (car decls)))
	  (loop (cdr decls)))
	 (else
	  (loop (cdr decls))))))

;*---------------------------------------------------------------------*/
;*    *files* ...                                                      */
;*---------------------------------------------------------------------*/
(define *included-files* '())
(define *imported-files* '())
(define *afile-list*     '())

;*---------------------------------------------------------------------*/
;*    include! ...                                                     */
;*---------------------------------------------------------------------*/
(define (include! includes)
   (for-each (lambda (i)
		(if (not (member i *included-files*))
		    (begin
		       (set! *included-files* (cons i *included-files*))
		       (loadq i))))
	     includes))

;*---------------------------------------------------------------------*/
;*    import! ...                                                      */
;*---------------------------------------------------------------------*/
(define (import! iclauses)
   (let ((l (map (lambda (i)
		     (match-case i
			(?module
			 (let ((cell (assq module *afile-list*)))
			    (if (pair? cell)
				(cadr cell)
				#f)))
			((?- ?second)
			 (if (string? second)
			     second
			     (let ((cell (assq second *afile-list*)))
				(if (pair? cell)
				    (cadr cell)
				    #f))))
			((?- ?- ?third)
			 third)
		 	(else
			 #f)))
		  iclauses)))
      (for-each (lambda (i)
		   (if (and (string? i)
			    (not (member i *imported-files*)))
		       (begin
			  (set! *imported-files* (cons i *imported-files*))
			  (loadq i))))
		l)))
	     
;*---------------------------------------------------------------------*/
;*    variable ...                                                     */
;*---------------------------------------------------------------------*/
(define (variable symbol env)
   (let ((offset (let loop ((env   env)
			    (count 0))
		    (cond
		       ((null? env)
			#f)
		       ((eq? (car env) symbol)
			count)
		       (else
			(loop (cdr env) (+fx count 1)))))))
      (if offset
	  offset
	  (let ((global (evlookup symbol the-global-environment)))
	     (if (not global)
		 `#(,symbol)
		 global)))))

;*---------------------------------------------------------------------*/
;*    global? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (global? variable)
   (and (vector? variable)
	(=fx (vector-length variable) 3)))

;*---------------------------------------------------------------------*/
;*    global-tag ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (global-tag global)
   (vector-ref-ur global 0))

;*---------------------------------------------------------------------*/
;*    global-name ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (global-name global)
   (vector-ref-ur global 1))

;*---------------------------------------------------------------------*/
;*    global-value ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (global-value global)
   (vector-ref-ur global 2))

;*---------------------------------------------------------------------*/
;*    set-global-value! ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (set-global-value! global value)
   (vector-set-ur! global 2 value))

;*---------------------------------------------------------------------*/
;*    dynamic? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (dynamic? variable)
   (and (vector? variable)
	(=fx (vector-length variable) 1)))

;*---------------------------------------------------------------------*/
;*    dynamic-name ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (dynamic-name dynamic)
   (vector-ref-ur dynamic 0))

;*---------------------------------------------------------------------*/
;*    compile-ref ...                                                  */
;*---------------------------------------------------------------------*/
(define (compile-ref variable tail?)
   (cond
      ((global? variable)
       (if (eq? (global-tag variable) 1)
	   `(51 . ,variable)
	   `(5 . ,variable)))
      ((dynamic? variable)
       `(6 #f . ,(dynamic-name variable)))
      (else
       (case variable
	  ((0 1 2 3)
	   `(,variable))
	  (else
	   `(4 . ,variable))))))

;*---------------------------------------------------------------------*/
;*    compile-set ...                                                  */
;*---------------------------------------------------------------------*/
(define (compile-set variable value)
   (cond
      ((global? variable)
       `(12 ,variable . ,value))
      ((dynamic? variable)
       `(13 #f ,variable . ,value))
      (else
       (case variable
	  ((0 1 2 3)
	   `(,(+fx variable 7) . ,value))
	  (else
	   `(11 ,variable . ,value))))))
	  
;*---------------------------------------------------------------------*/
;*    compile-cnst ...                                                 */
;*    -------------------------------------------------------------    */
;*    Afin de ne pas allouer pour les cas trop frequents, on fait      */
;*    quelques cas particuliers.                                       */
;*---------------------------------------------------------------------*/
(define (compile-cnst cnst tail?)
   (cond
      ((null? cnst)
       '(-2))
      ((and (boolean? cnst) (not cnst))
       '(-3))
      ((boolean? cnst)
       '(-4))
      ((eq? cnst 1)
       '(-5))
      ((eq? cnst 0)
       '(-6))
      ((eq? cnst -1)
       '(-7))
      ((eq? cnst 2)
       '(-8))
      ((string? cnst)
       `(-1 . ,(escape-string cnst)))
      (else
       `(-1 . ,cnst))))

;*---------------------------------------------------------------------*/
;*    compile-if ...                                                   */
;*---------------------------------------------------------------------*/
(define (compile-if test then else)
   `(14 ,test ,then . ,else))

;*---------------------------------------------------------------------*/
;*    compile-begin ...                                                */
;*---------------------------------------------------------------------*/
(define (compile-begin body env)
   (cond
      ((and (pair? body) (and (null? (cdr body))))
       ;; le cas degenere
       (compile (car body) env #t))
      (else
       (let ((body (let loop ((rest body))
		      (cond
			 ((null? rest)
			  (error "eval" "Illegal form" body))
			 ((null? (cdr rest))
			  (cons (compile (car rest) env #t) '()))
			 (else
			  (cons (compile (car rest) env #f)
				(loop (cdr rest))))))))
	  `(15 ,@body)))))

;*---------------------------------------------------------------------*/
;*    compile-define ...                                               */
;*    -------------------------------------------------------------    */
;*    Le calcul de `val' a ete differe car on ne veut compiler la      */
;*    valeur liee d'un define qu'une fois que la variable a ete liee   */
;*    dans l'environment. Si on ne fait pas cela on se tape que des    */
;*    appels dynamics dans les definitions des fonctions               */
;*    auto-recursives !                                                */
;*---------------------------------------------------------------------*/
(define (compile-define var val)
   (let ((cell (evlookup var the-global-environment)))
      (if (global? cell)
	  (begin
	     (fprint
	      (current-error-port)
	      "*** WARNING:bigloo:eval\nredefinition of variable -- "
	      var)
	     (update-global! cell (val) '()))
	  (begin
	     (set-cdr! the-global-environment
		       (cons (car the-global-environment)
			     (cdr the-global-environment)))
	     (set-car! the-global-environment
		       (vector 0 var (unspecified)))
	     ;; on le fait en deux fois pour etre sur que la liaison
	     ;; existe.
	     (set-global-value! (car the-global-environment)
				(_evmeaning-internal (val) '())))))
   `(16 . ,var))
      
   
;*---------------------------------------------------------------------*/
;*    compile-lambda ...                                               */
;*---------------------------------------------------------------------*/
(define (compile-lambda formals body tail?)
   (match-case formals
      (()
       `(17 . ,body))
      ((?-)
       `(18 . ,body))
      ((?- ?-)
       `(19 . ,body))
      ((?- ?- ?-)
       `(20 . ,body))
      ((?- ?- ?- ?-)
       `(21 . ,body))
      ((atom ?-)
       `(22 . ,body))
      (((atom ?-) . (atom ?-))
       `(23 . ,body))
      (((atom ?-) (atom ?-) . (atom ?-))
       `(24 . ,body))
      (((atom ?-) (atom ?-) (atom ?-) . (atom ?-))
       `(25 . ,body))
      (else
       `(26 ,formals . ,body))))

;*---------------------------------------------------------------------*/
;*    compile-global-application ...                                   */
;*---------------------------------------------------------------------*/
(define (compile-global-application proc actuals tail?)
   (case (length actuals)
      ((0 1 2 3)
       (if (eq? (global-tag proc) 1)
	   `(,(+fx (length actuals) 45) ,proc ,@actuals)
	   `(,(+fx (length actuals) 27) ,proc ,@actuals)))
      (else
       (if (eq? (global-tag proc) 1)
	   `(50 ,proc ,@actuals)
	   `(32 ,proc ,@actuals)))))

;*---------------------------------------------------------------------*/
;*    compile-compiled-application ...                                 */
;*---------------------------------------------------------------------*/
(define (compile-compiled-application proc actuals tail?)
   (case (length actuals)
      ((0 1 2 3)
       `(,(+fx (length actuals) 33) ,proc ,@actuals))
      (else
       `(38 ,proc ,@actuals))))
       
;*---------------------------------------------------------------------*/
;*    compile-application ...                                          */
;*---------------------------------------------------------------------*/
(define (compile-application proc actuals tail?)
   (case (length actuals)
      ((0 1 2 3)
       `(,(+fx (length actuals) 39) ,proc ,@actuals))
      (else
       `(44 ,proc ,@actuals))))

