;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.3/Llib/eval.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May  7 08:04:58 1993                          */
;*    Last change :  Mon Jul  5 11:05:19 1993  (serrano)               */
;*                                                                     */
;*    L'evaluateur de Bigloo                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __eval
   (export  (eval  exp)
	    (load  string)
	    (loadq string)
	    (loada string)
	    (repl)
	    (expand-eval-define-macro    x e)
	    (expand-eval-define-expander x e))
   (import  (__expander "Llib/expander.scm")
	    (__expand   "Llib/expand.scm")
	    (__evcomp   "Llib/evcomp.scm"))
   (foreign (include "signal.h")
	    (define int sigint "SIGINT")))

;*---------------------------------------------------------------------*/
;*    eval ...                                                         */
;*---------------------------------------------------------------------*/
(define (eval exp)
   (evmeaning exp))

;*---------------------------------------------------------------------*/
;*    La boucle `top-level'. Puisqu'il faut eviter d'avoir plusieurs   */
;*    fichiers ou il a `eval' dans la libraire, on met la `repl' ici.  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Les variables de l'historique                                    */
;*---------------------------------------------------------------------*/
(define *history-head*       '(dummy))
(define *history-tail*       *history-head*)
(define *history-length*     0)
(define *history-max-length* 50)

;*---------------------------------------------------------------------*/
;*    h ...                                                            */
;*---------------------------------------------------------------------*/
(define (h . num)
   (let loop ((h (cdr *history-head*)))
      (cond
	 ((null? h)
	  (unspecified))
	 ((null? (cdr h))
	  (unspecified))
	 (else
	  (begin
	     (display* (car (car h)) ": ")
	     (write (cdr (car h)))
	     (newline)
	     (loop (cdr h)))))))

;*---------------------------------------------------------------------*/
;*    ! ...                                                            */
;*---------------------------------------------------------------------*/
(define (! num)
   (let ((event (assq num (cdr *history-head*))))
      (if (not (pair? event))
	  (error "history" "event not found" num)
	  (eval (cdr event)))))

;*---------------------------------------------------------------------*/
;*    *end-of-repl*                                                    */
;*---------------------------------------------------------------------*/
(define *end-of-repl* '())

;*---------------------------------------------------------------------*/
;*    repl ...                                                         */
;*---------------------------------------------------------------------*/
(define (repl)
   (bind-exit (end-of-repl)
	      (begin
		 (set! *end-of-repl* end-of-repl)
		 (internal-repl))))

;*---------------------------------------------------------------------*/
;*    internal-repl ...                                                */
;*---------------------------------------------------------------------*/
(define (internal-repl)
   ;; le vrai top level
   (let ((lambda-stack (get-lambda-stack)))
      (define (local-repl)
	 (letrec ((handler (lambda (escape proc mes obj)
			      (notify-error proc mes obj)
			      (dump-lambda-stack)
			      (set-lambda-stack! lambda-stack)
			      (local-repl))))
	    (try (begin
		    (newline)    
		    (display ":=> ") 
		    (let ((exp (read (current-input-port))))
		       ;; on s'occupe de l'historique
		       (set! *history-length* (+fx 1 *history-length*))
		       (set-cdr! *history-tail*
				 (cons (cons *history-length* exp) '()))
		       (set! *history-tail* (cdr *history-tail*))
		       (if (> *history-length* *history-max-length*)
			   (set! *history-head* (cdr *history-head*)))
		       (if (eof-object? exp)
			   (quit)
			   (let ((v (eval exp)))
			      (print v)
			      (local-repl)))))
		 handler)))
      ;; l'attrapeur de signaux
      (define (catch-intr n)
	 (print "*** INTERRUPT:bigloo:")
	 (flush-output-port (current-output-port))
	 (local-repl))
      ;; on les attrappe
      (signal sigint catch-intr)
      ;; on lance
      (local-repl)))
		       
;*---------------------------------------------------------------------*/
;*    quit ...                                                         */
;*---------------------------------------------------------------------*/
(define (quit)
   (if (procedure? *end-of-repl*)
       (*end-of-repl* 0)
       (exit 0)))

;*---------------------------------------------------------------------*/
;*    load ...                                                         */
;*---------------------------------------------------------------------*/
(define (load file-name)
   (loadv file-name #t))

(define (loadq file-name)
   (loadv file-name #f))

(define (loadv file-name v?)
   (let ((port (open-input-file file-name)))
      (if (input-port? port)
	  (let loop ((sexp         (read port))
		     (v            (unspecified))
		     (module-seen? #f)
		     (main         #f))
	     (cond
		((eof-object? sexp)
		 (close-input-port port)
		 (if main
		     main
		     v))
		((and (pair? sexp) (eq? (car sexp) 'module))
		 (if module-seen?
		     (error "load" "module defined twice" sexp)
		     (let ((main (assq 'main (cddr sexp))))
			(let ((v (eval sexp)))
			   (if v?
			       (print v))
			   (loop (read port)
				 v
				 #t
				 (if (pair? main)
				     (cadr main)
				     v))))))
		(else
		 (let ((v (eval sexp)))
		    (if v?
			(print v))
		    (loop (read port)
			  v
			  module-seen?
			  main)))))
	  (error "load" "Can't open file" file-name))))

;*---------------------------------------------------------------------*/
;*    loada ...                                                        */
;*---------------------------------------------------------------------*/
(define (loada file)
   (let ((port (open-input-file file)))
      (if (input-port? port)
	  (begin
	     (set! *afile-list* (append (read port) *afile-list*))
	     (close-input-port port))
	  (error "loada" "Can't open file" file))))
   
;*---------------------------------------------------------------------*/
;*    Les macros interpretes. Elles sont regroupees ici pour les memes */
;*    raisons que la boucle top level.                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    expand-eval-define-expander ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-expander x e)
   (match-case x
      ((?- (and (not (?- . ?-)) ?name)
	   (and ?macro (lambda (?x ?e) . ?body)))
       (install-expander name (eval macro))
       `(quote ,name))
      (else
       (error "define-expander" "Illegal syntax" x))))      

;*---------------------------------------------------------------------*/
;*    expand-eval-define-macro ...                                     */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-macro x e)
   (match-case x
      ((?- (?name . ?args) . ?body)
       (if (not (symbol? name))
	   (error "define-macro" "not a symbol" x)
	   (begin
	      (install-expander name
				(eval `(lambda (x e)
					  (e (let ,(destructure args '(cdr x)
								'())
						,(normalize-progn body))
					     e))))
	      `(quote ,name))))
      (else
       (error "define-macro" "Illegal syntax" x))))

;*---------------------------------------------------------------------*/
;*    destructure ...                                                  */
;*---------------------------------------------------------------------*/
(define (destructure pat arg bindings)
   (cond
      ((null? pat) bindings)
      ((symbol? pat) (cons `(,pat ,arg) bindings))
      ((pair? pat)
       (destructure (car pat) `(car ,arg)
		    (destructure (cdr pat) `(cdr ,arg)
				 bindings)))))

