;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.3/Llib/equiv.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 24 14:58:25 1992                          */
;*    Last change :  Wed Jun 23 16:06:08 1993  (serrano)               */
;*                                                                     */
;*    6.2. Equivalence predicates (page 13, r4)                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_equivalence_6_2
   (foreign (define bool c-eq? (obj obj) "EQP"))
   (export  (inline eqv? obj1 obj2)
	    (inline eq?  obj1 obj2)
	    (equal?      obj1 obj2))
   (pragma  (c-eq? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (equal? _no_side_effect_ _imutable_ _no_mutation_)))

;*---------------------------------------------------------------------*/
;*    eq? ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (eq? obj1 obj2)
   (c-eq? obj1 obj2))

;*---------------------------------------------------------------------*/
;*    eqv? ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (eqv? obj1 obj2)
   (c-eq? obj1 obj2))

;*---------------------------------------------------------------------*/
;*    equal? ...                                                       */
;*---------------------------------------------------------------------*/
(define (equal? obj1 obj2)
   (cond
      ((c-eq? obj1 obj2)
       #t)
      ((pair? obj1)
       (and (pair? obj2) (equal? (car obj1) (car obj2))
	    (equal? (cdr obj1) (cdr obj2))))
      ((vector? obj1)
       (let ((lobj1 (vector-length obj1)))
	  (and (vector? obj2)
	       (=fx (vector-length obj2) lobj1)
	       (let test ((i (-fx lobj1 1)))
		  (or (=fx i -1)
		      (and (equal? (vector-ref obj1 i) (vector-ref obj2 i))
			   (test (-fx i 1))))))))
      ((string? obj1)
       (and (string? obj2) (string=? obj1 obj2)))
      ((integer? obj1)
       (and (integer? obj2)
	    (=fx obj1 obj2)))
      ((c-real? obj1)
       (and (c-real? obj2)
	    (=fl obj1 obj2)))
      (else
       #f)))
