;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../characters.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 21 10:09:50 1992                          */
;*    Last change :  Wed Apr 28 11:12:17 1993  (serrano)               */
;*                                                                     */
;*    6.6 Characters (page 24, r4)                                     */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_characters_6_6
   (foreign (define bool  c-char?         (obj)         "CHARP")
	    (define bchar c-char-upcase   (bchar)       "CHAR_UPCASE")
	    (define bchar c-char-downcase (bchar)       "CHAR_DOWNCASE")
	    (define bool c-char<?         (bchar bchar) "CHAR_LT")
	    (define bool c-char>?         (bchar bchar) "CHAR_GT")
	    (define bool c-char<=?        (bchar bchar) "CHAR_LE")
	    (define bool c-char>=?        (bchar bchar) "CHAR_GE")
	    (define bint c-char->integer  (bchar)       "CHAR_TO_INT")
	    (define bchar c-integer->char (bint)        "INT_TO_CHAR"))
   (export  (inline char? obj)
	    (inline char=? char1 char2)
	    (inline char<? char1 char2)
	    (inline char>? char1 char2)
	    (inline char<=? char1 char2)
	    (inline char>=? char1 char2) 
	    (inline char-ci=? char1 char2)
	    (inline char-ci<? char1 char2)
	    (inline char-ci>? char1 char2)
	    (inline char-ci<=? char1 char2)
	    (inline char-ci>=? char1 char2)
	    (inline char-alphabetic? char)
	    (inline char-numeric? char)
	    (inline char-whitespace? char)
	    (inline char-upper-case? char)
	    (inline char-lower-case? char)
	    (inline char->integer char)
	    (integer->char int)
	    (inline integer->char-ur int)
	    (inline char-upcase  char)
	    (inline char-downcase char)))

;*---------------------------------------------------------------------*/
;*    char? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (char? obj)
   (c-char? obj))

;*---------------------------------------------------------------------*/
;*    char=? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (char=? char1 char2)
   (eq? char1 char2))

;*---------------------------------------------------------------------*/
;*    char<? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (char<? char1 char2)
   (c-char<? char1 char2))

;*---------------------------------------------------------------------*/
;*    char>? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline  (char>? char1 char2)
   (c-char>? char1 char2))

;*---------------------------------------------------------------------*/
;*    char<=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char<=? char1 char2)
   (c-char<=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char>=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char>=? char1 char2)
   (c-char>=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char-ci=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (char-ci=? char1 char2)
   (eq? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci<? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (char-ci<? char1 char2)
   (c-char<? (char-upcase char1) (char-upcase char2))) 

;*---------------------------------------------------------------------*/
;*    char-ci>? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline  (char-ci>? char1 char2)
   (c-char>? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci<=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char-ci<=? char1 char2)
   (c-char<=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci>=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char-ci>=? char1 char2)
   (c-char>=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-alphabetic? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-alphabetic? char)
   (let ((c (char-upcase char)))
      (and (char>=? c #\A)
	   (char<=? c #\Z))))

;*---------------------------------------------------------------------*/
;*    char-numeric? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (char-numeric? char)
   (and (char>=? char #\0)
	(char<=? char #\9)))

;*---------------------------------------------------------------------*/
;*    char-withespace? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-whitespace? char)
   (eq? char #\space))

;*---------------------------------------------------------------------*/
;*    char-upper-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-upper-case? char)
   (and (char>=? char #\A)
	(char<=? char #\Z)))

;*---------------------------------------------------------------------*/
;*    char-lower-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-lower-case? char)
   (and (char>=? char #\a)
	(char<=? char #\z)))

;*---------------------------------------------------------------------*/
;*    char->integer ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (char->integer char)
   (c-char->integer char))

;*---------------------------------------------------------------------*/
;*    integer->char ...                                                */
;*---------------------------------------------------------------------*/
(define (integer->char int)
   (if (and (>=fx int 0) (<=fx int 255))
       (c-integer->char int)
       (error "integer->char" "integer out of range" int)))

;*---------------------------------------------------------------------*/
;*    integer->char-ur ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (integer->char-ur int)
   (c-integer->char int))

;*---------------------------------------------------------------------*/
;*    char-upcase ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (char-upcase char)
   (c-char-upcase char))

;*---------------------------------------------------------------------*/
;*    char-downcase ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (char-downcase char)
   (c-char-downcase char))
		     
