;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.2/Llib/casting.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 21 09:14:24 1992                          */
;*    Last change :  Wed May  5 14:28:48 1993  (serrano)               */
;*                                                                     */
;*    Toutes les fonctions de conversions de type                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __casting
   (foreign (define bbool   c-cbool->bbool     (bool)    "CBOOL_TO_BBOOL")
	    (define bool    c-bbool->cbool     (bbool)   "BBOOL_TO_CBOOL")
	    (define bint    c-cint->bint       (int)     "BINT")
	    (define int     c-bint->cint       (bint)    "CINT")
	    (define bstring c-cstring->bstring (string)  "CSTRING_TO_BSTRING")
	    (define string  c-bstring->cstring (bstring) "BSTRING_TO_CSTRING")
	    (define bchar   c-cchar->bchar     (char)    "BCHAR")
	    (define char    c-bchar->cchar     (char)    "CCHAR")
	    (define breal   c-cdouble->breal   (double)  "DOUBLE_TO_REAL")
	    (define double  c-breal->cdouble   (breal)   "REAL_TO_DOUBLE"))
   (export  (inline cbool->bbool     bool)
	    (inline bbool->cbool     bool)
	    (inline cint->bint       int)
	    (inline bint->cint       int)
	    (inline cstring->bstring string)
	    (inline bstring->cstring string)
	    (inline cchar->bchar     char)
	    (inline bchar->cchar     char)
	    (inline double->real     float)
	    (inline real->double     float))
   (pragma  (c-cbool->bbool _no_side_effect_ _imutable_
			    _no_mutation_ _imbricable_)
	    (c-bbool->cbool _no_side_effect_ _imutable_
			    _no_mutation_ _imbricable_)
	    (c-cint->bint _no_side_effect_ _imutable_
			  _no_mutation_ _imbricable_)
	    (c-bint->cint _no_side_effect_ _imutable_
			  _no_mutation_ _imbricable_)
	    (c-cstring->bstring _no_side_effect_ _no_mutation_ _imbricable_)
	    (c-bstring->cstring _no_side_effect_ _no_mutation_ _imbricable_)
	    (c-cchar->bchar _no_side_effect_ _imutable_
			    _no_mutation_ _imbricable_)
	    (c-bchar->cchar _no_side_effect_ _imutable_
			    _no_mutation_ _imbricable_)
	    (c-cdouble->breal _no_side_effect_ _imutable_
			      _no_mutation_ _imbricable_)
	    (c-breal->cdouble _no_side_effect_ _imutable_
			      _no_mutation_ _imbricable_)))
	    
;*---------------------------------------------------------------------*/
;*    cbool->bbool ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (cbool->bbool void)
   (c-cbool->bbool void))

;*---------------------------------------------------------------------*/
;*    bbool->cbool ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (bbool->cbool bool)
   (c-bbool->cbool bool))

;*---------------------------------------------------------------------*/
;*    cint->bint ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (cint->bint int)
   (c-cint->bint int))

;*---------------------------------------------------------------------*/
;*    bint->cint ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (bint->cint int)
   (c-bint->cint int))

;*---------------------------------------------------------------------*/
;*    cstring->bstring ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (cstring->bstring string)
   (c-cstring->bstring string))

;*---------------------------------------------------------------------*/
;*    bstring->cstring ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (bstring->cstring string)
   (c-bstring->cstring string))

;*---------------------------------------------------------------------*/
;*    cchar->bchar ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (cchar->bchar char)
   (c-cchar->bchar char))

;*---------------------------------------------------------------------*/
;*    bchar->cchar ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (bchar->cchar char)
   (c-bchar->cchar char))

;*---------------------------------------------------------------------*/
;*    double->real ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (double->real double)
   (c-cdouble->breal double))

;*---------------------------------------------------------------------*/
;*    real->double ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (real->double real)
   (c-breal->cdouble real))
