;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.2/Llib/bit.scm ...          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct  6 14:48:11 1992                          */
;*    Last change :  Wed Apr 28 11:12:00 1993  (serrano)               */
;*                                                                     */
;*    Des fonctions de trippotages des `bit's (non r4)                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __bit
   (foreign (define bint c-bitor  (bint bint) "BITOR")
	    (define bint c-bitand (bint bint) "BITAND")
	    (define bint c-bitxor (bint bint) "BITXOR")
	    (define bint c-bitnot (bint)      "BITNOT")
	    (define bint c-bitrsh (bint bint) "BITRSH")
	    (define bint c-bitlsh (bint bint) "BITLSH"))
   (export  (inline bit-or  int int)
	    (inline bit-and int int)
	    (inline bit-xor int int)
	    (inline bit-not int)
	    (inline bit-rsh int int)
	    (inline bit-lsh int int)))

;*---------------------------------------------------------------------*/
;*    bit-or ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (bit-or x y)
   (c-bitor x y))

;*---------------------------------------------------------------------*/
;*    bit-and ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-and x y)
   (c-bitand x y))

;*---------------------------------------------------------------------*/
;*    bit-xor ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-xor x y)
   (c-bitxor x y))

;*---------------------------------------------------------------------*/
;*    bit-not ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-not x)
   (c-bitnot x))
   
;*---------------------------------------------------------------------*/
;*    bit-rsh ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-rsh x y)
   (c-bitrsh x y))
       
;*---------------------------------------------------------------------*/
;*    bit-lsh ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-lsh x y)
   (c-bitlsh x y))

