/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.3/Include/bigloo.h ...      */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 10 10:48:19 1991                          */
/*    Last change :  Fri Jul  2 14:26:03 1993  (serrano)               */
/*                                                                     */
/*    Les choses de `Bigloo'                                           */
/*---------------------------------------------------------------------*/
#ifndef BIGLOO_H
#define BIGLOO_H

/*---------------------------------------------------------------------*/
/*    Les includes indispensables                                      */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <setjmp.h>
#include <errno.h>
#if( defined( sun ) && defined( sparc ) )
#   include <stdlib.h>
#endif
#include <math.h>
#if defined( sony_news )
#   include <news/machparam.h>
#endif

/*---------------------------------------------------------------------*/
/*    Les sites ou sont ranges les libraries et les includes           */
/*---------------------------------------------------------------------*/
#define LIBRARY_DIR() "/home/cornas/icsla/serrano/prgm/project/bigloo/lib/1.3"
#define INCLUDE_DIR() "/home/cornas/icsla/serrano/prgm/project/bigloo/lib/1.3"
/*---------------------------------------------------------------------*/
/*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
/*    Attention, le deux macros ci-dessus doivent imperativement etre  */
/*    ligne 30 et 31 (pour la distribution)                            */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Quelques macros system dependant                                 */
/*---------------------------------------------------------------------*/
#define DOWN 55
#define UP   66

/*--- Les casts pour `longjmp'/`setjmp' -------------------------------*/
#define JMP_BUF int
#define JMP_VAL int


#if defined( SPARC ) || defined( sparc )
#   include <sys/signal.h>
#   define STACK_GROWS DOWN
    /* Le nombre de fenetre de registre sur sparc */
#   define NB_WINDOW_REGISTER SPARC_MAXREGWINDOW
#else
#   if( defined( PYR ) || defined( pyr ) \
        || (defined( sony_news ) && defined( r3000 )) )
#      define STACK_GROWS DOWN
#   else
#      if( defined( i386 ) )
#         define STACK_GROWS DOWN
#         define SIGBUS SIGUSR1
#      else
#         if( defined( __pa_risc ) || defined(_PA_RISC1_0) || defined(_PA_RISC1_1) )
#            define STACK_GROWS UP
#            define SIGBUS _SIGBUS
#         else
#            if( defined( sun ) && defined( mc68000 ) )
#               define STACK_GROWS DOWN
#            else
#               if( defined( ultrix ) && defined( mips ) )
#                  define STACK_GROWS DOWN
#               else
#                  if( defined( _IBMR2 ) )
#                     define STACK_GROWS DOWN
#                  else
                      --> error "I need to know the way the c-stack grows, see `public/grows.c'"
#                  endif
#               endif                   
#            endif
#         endif
#      endif
#   endif
#endif

#if( !defined( NB_WINDOW_REGISTER ) )
#   define NB_WINDOW_REGISTER 0
#endif

/*---------------------------------------------------------------------*/
/*    Quelques messages d'erreur personnel.                            */
/*---------------------------------------------------------------------*/
#define EHEAP       500  /* Pas assez de memoire pour allouer le tas   */
#define EMEMORY     501  /* Plus assez de place dans le tas            */
#define ETARGS      502  /* on passe trop d'args a apply               */

/*---------------------------------------------------------------------*/
/*    Les macros du GC ...                                             */
/*---------------------------------------------------------------------*/
#define NO_GC            1
#define BOEHM_1_X_GC     2
#define BOEHM_2_X_GC     3

#define GC BOEHM_2_X_GC

/*---------------------------------------------------------------------*/
/*    Il y a plusieurs formes d'objets:                                */
/*    Les objets allouees:                                             */
/*            +--------+--------+--------+--------+                    */
/*            |....signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 30 bits:                                    */
/*            +--------+--------+--------+--------+                    */
/*            |....signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 6 bits:                                     */
/*            +--------+--------+--------+--------+                    */
/*            |..........................|xxxxxx??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 8 bits:                                     */
/*            +--------+--------+--------+--------+                    */
/*            |.................|xxxxxxxx|......??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Ou sont les `tags' et quel `mask' cela represente.               */
/*---------------------------------------------------------------------*/
#define TAG_SHIFT     2  
#define TAG_MASK      3  

/*---------------------------------------------------------------------*/
/*    Les `tags' des pointeurs ...                                     */
/*---------------------------------------------------------------------*/
#if( (GC == BOEHM_1_X_GC) )
#   define TAG_INT          1  /*  Les integer sont tagues  ....01     */
#   define TAG_CNST         3  /*  Les cnsts sont taguees   ....11     */
#   define TAG_STRUCT       0  /*  Les pointer sont tagues  ....00     */
#else
#   if( GC == BOEHM_2_X_GC )
#      define TAG_INT       1  /*  Les integer sont tagues  ....01     */
#      define TAG_CNST      2  /*  Les cnsts sont taguees   ....10     */
#      define TAG_STRUCT    0  /*  Les pointer sont tagues  ....00     */
#      define TAG_PAIR      3  /*  Les pairs sont taguees   ....11     */
#   else
#      if( GC == NO_GC )
#         define TAG_INT    0  /*  Les integer sont tagues  ....00     */
#         define TAG_CNST   2  /*  Les cnsts sont taguees   ....10     */
#         define TAG_STRUCT 1  /*  Les pointer sont tagues  ....01     */
#      else
          --> error "Unknown garbage collector type"
#      endif
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    La taille de la table hashage                                    */
/*---------------------------------------------------------------------*/
#define HASH_TABLE_SIZE() 1024

/*---------------------------------------------------------------------*/
/*    Les `header' des structures ...                                  */
/*---------------------------------------------------------------------*/
#define HEADER_PAIR                  ((header_t)BINT( 0 ))
#define HEADER_STRING                ((header_t)BINT( 1 ))
#define HEADER_VECTOR                ((header_t)BINT( 2 ))
#define HEADER_PROCEDURE             ((header_t)BINT( 3 ))
#define HEADER_TRUE                  ((header_t)BINT( 4 ))
#define HEADER_FALSE                 ((header_t)BINT( 5 ))
#define HEADER_UNSPEC                ((header_t)BINT( 6 ))
#define HEADER_NIL                   ((header_t)BINT( 7 ))
#define HEADER_SYMBOL                ((header_t)BINT( 8 ))
#define HEADER_STACK                 ((header_t)BINT( 9 ))
#define HEADER_INPUT_PORT            ((header_t)BINT( 10 ))
#define HEADER_OUTPUT_PORT           ((header_t)BINT( 11 ))
#define HEADER_RGRAMMAR              ((header_t)BINT( 12 ))
#define HEADER_CELL                  ((header_t)BINT( 13 ))
#define HEADER_EOF                   ((header_t)BINT( 14 ))
#define HEADER_STRUCT                ((header_t)BINT( 15 ))
#define HEADER_REAL                  ((header_t)BINT( 16 ))
#define HEADER_EOA                   ((header_t)BINT( 17 ))

/*---------------------------------------------------------------------*/
/*    Les differents objects `Sqic' :                                  */
/*---------------------------------------------------------------------*/
typedef int   int_t;
typedef int_t header_t;

typedef union object {
   int_t              integer;   /*  Les entiers                       */
   
   header_t           header;    /*  Un champs un peu fictif mais      */
                                 /*  il est utile pour pouvoir acceder */
                                 /*  au header des objets sans savoir  */
                                 /*  quel est leur type. Tous les      */
                                 /*  headers sont en tete des struct   */
                                 /*  on peut donc le header global     */
                                 /*  plutot que les header locaux      */
   
   struct {                      /*  Les pairs.                        */
#if( !(defined( TAG_PAIR ) ) )            
      header_t        header;    /*  Le header est facultatif, il      */
#endif      
      union object   *car;       /*  depend du GC qu'on utilise.       */
      union object   *cdr;       /*  Dans tous les cas, il y a biensur */
   } pair_t;                     /*  un `car' et un `cdr' :-)          */

#if( defined( ALLOCATE_CONSTANT ) )
   struct {                      /*  Les booleens qui sont au nombre   */
      header_t        header;    /*  de 2: true et false               */
   } boolean_t;
#endif

   struct {                      /*  Les chaines de char, juste un     */
      header_t        header;    /*  pointer C                         */
      char           *string;
   } string_t;

   struct {                      /*  Les vecteurs, un nom et une       */
      header_t        header;    /*  taille.                           */
      union object   *length;
   } vector_t;

   struct {                      /*  Les fermetures:                   */
      header_t        header;    
      union object *(*entry)();
      union object *(*va_entry)();
      int             arity;       
      char           *env;       /*  Ce champs est utilise pour etre   */
   } procedure_t;                /*  que l'alignement est correct      */

   struct {                      /*  Les symboles, un nom et une       */
      header_t        header;    /*  valeur (qui n'est jamais utilisee */
      char           *name;      /*  pour le moment).                  */
      union object   *cval;
   } symbol_t;

   struct {                      /* Les output_port                    */
      header_t        header;    /* grosso-modo cette structure        */
      FILE           *file;      /* comporte juste un file et son nom  */
      char           *name;
   } output_port_t;
   
   struct {                      /*  Les input_port                    */
      header_t        header;    /*  un input_port est:                */
      union object   *class;     /*                      - une classe  */
      char           *name;      /*                      - une chaine  */
      FILE           *file;      /*                      - un file     */
      union object   *bufsiz;    /*                      - une taille  */
      union object   *eof;       /*                      - un flag     */
      union object   *backward;  /*                      - un backward */
      union object   *forward;   /*                      - un forward  */
      union object   *remember;  /*                      - un souvenir */
      union object   *mark;      /*                      - un marqueur */
      char           *buffer;    /*                      - un buffer   */
   } input_port_t;

   struct {                      /*  Les cellules. Ces objets sont     */
      header_t        header;    /*  utilisees quand il y a des var    */
      union object   *obj;       /*  capturees qui sont en plus ecrite */
   } cell_t;

   struct {                      /*  Les structures,                   */
      header_t        header;    /*  sont constituees de :             */
      union object   *key;       /*                      - une cle     */
      union object   *length;    /*                      - une long.   */
      union object   *slot;      /*                      - des slots   */
   } struct_t;

   struct {                      /*  Les nombres flottants             */
      header_t        header;
      double          real;
   } real_t;

   struct {                      /*  Les piles de `call/cc'            */
      header_t        header;    /*  sont:                             */
      union object   *self;      /*        - un ptr sur soit meme      */
      union object   *size;      /*        - une taille                */
      char           *stack;     /*        - un espace memoire         */
   } stack_t;
   
} *obj_t;

/*---------------------------------------------------------------------*/
/*    Les procedures d'allocations                                     */
/*---------------------------------------------------------------------*/
#if( GC == DELACOUR_GC )
#   define ALLOCATE( size )
#   define ALLOCATE_ATOMIC( size )
#   define INLINE_ALLOCATE( size )
#   define INLINE_ALLOCATE_ATOMIC( size )
#   define INIT_ALLOCATION() 
#   define FREE_ALLOCATION()
#else
#   if( GC == BOEHM_1_X_GC )
       extern obj_t gc_malloc();
       extern obj_t gc_malloc_atomic();
#      define ALLOCATE( size ) gc_malloc( size )
#      define ALLOCATE_ATOMIC( size ) gc_malloc_atomic( size )
#      define INLINE_ALLOCATE( size ) gc_malloc( size )
#      define INLINE_ALLOCATE_ATOMIC( size ) gc_malloc_atomic( size )
#      define INLINE_ALLOCATE( size ) gc_malloc( size )
#      define INIT_ALLOCATION( size ) (gc_init() , expand_hp( size ))
#      define FREE_ALLOCATION();
#   else
#      if( GC == BOEHM_2_X_GC )
#         if( !defined( GC_PRIVATE_H ) )
             extern obj_t GC_malloc();
             extern obj_t GC_malloc_atomic();
#         endif
#         define ALLOCATE( size ) GC_malloc( size )
#         define ALLOCATE_ATOMIC( size ) GC_malloc_atomic( size )
#         define INLINE_ALLOCATE( size ) GC_malloc( size )
#         define INLINE_ALLOCATE_ATOMIC( size ) GC_malloc_atomic( size )
#         if( (TAG_STRUCT != 0) && (TAG_PAIR != 0) )
#            define INIT_ALLOCATION( size )                \
                ( GC_init(),                               \
                  GC_expand_hp( size ),                    \
                  GC_register_displacement( TAG_STRUCT ),  \
                  GC_register_displacement( TAG_PAIR ) )
#         else
#            if( TAG_STRUCT != 0 ) 
#               define INIT_ALLOCATION( size )             \
                   ( GC_init(),                            \
                     GC_expand_hp( size ),                 \
                     GC_register_displacement( TAG_STRUCT ) )
#            else
#               if( TAG_PAIR != 0 )
#                  define INIT_ALLOCATION( size )          \
                      ( GC_init(),                         \
                        GC_expand_hp( size ),              \
                        GC_register_displacement( TAG_PAIR ) )
#               else
                   define INIT_ALLOCATION( size )          \
                      ( GC_init(), GC_expand_hp( size ) )
#               endif
#            endif
#         endif
#         define FREE_ALLOCATION();
#      else
#         if( GC == NO_GC )
             extern obj_t heap_alloc();
#            define ALLOCATE( size ) heap_alloc( size )
#            define ALLOCATE_ATOMIC( size ) heap_alloc( size )
#            define INLINE_ALLOCATE( size ) heap_alloc( size )
#            define INLINE_ALLOCATE_ATOMIC( size ) heap_alloc( size )
#            define INIT_ALLOCATION( size ) init_heap( size )
#            define FREE_ALLOCATION() free_heap()
#         else
             --> error "Unknown garbage collector type"
#         endif                
#     endif          
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    Les macros qui servent a boxer/deboxer                           */
/*---------------------------------------------------------------------*/
#define BOX( val, shift, tag )   ((int)(((int)(val) << shift) | tag))
#define UNBOX( val, shift, tag ) ((int)((int)(val) >> shift))

/*---------------------------------------------------------------------*/
/*    Les macros de conversions utilisees par `Sqic'                   */
/*    -------------------------------------------------------------    */
/*    Attention, il est normal que pour faire la conversion `bigloo->c'*/
/*    j'utilise une soustraction et non pas un `and'. En faisant comme */
/*    ca, le compilateur C peut bien optimiser les access aux          */
/*    differents champs.                                               */
/*---------------------------------------------------------------------*/
#define BINT( i )          (obj_t)BOX( i, TAG_SHIFT, TAG_INT )
#define CINT( i )          (int)UNBOX( i, TAG_SHIFT, TAG_INT )

#define BREF( r )          ((obj_t)((int)r | TAG_STRUCT))
#define CREF( r )          ((obj_t)((int)r - TAG_STRUCT))

#if( defined( TAG_PAIR ) )
#   define BPAIR( p )      ((obj_t)((int)p | TAG_PAIR))
#   define CPAIR( p )      ((obj_t)((int)p - TAG_PAIR))
#else
#   define BPAIR( p )      BREF( p )
#   define CPAIR( p )      CREF( p )
#endif

#define BFUN( f )          ((obj_t)(f))
#define CFUN( f )          ((obj_t (*)())(f))

#define BCNST( c )         (obj_t)BOX( c, TAG_SHIFT, TAG_CNST )
#define CCNST( c )         (int)UNBOX( c, TAG_SHIFT, TAG_CNST )

#define BCONT( c )         ((obj_t)(c))
#define CCONT( c )         (c)

#define TRUEP( c )         ((unsigned char)(c != BFALSE))

#define BCHAR( i )         ((obj_t)((int)BCHARH | ((int)((int)(i) << 8))))
#define CCHAR( i )         (int)((int)(i)>>8)

#define CTRUE              ((unsigned char)1)
#define CFALSE             ((unsigned char)0)

#define FAILURE( p, m, o ) the_failure( p, m, o )

/*---------------------------------------------------------------------*/
/*    Les `constantes' peuvent etre soit allouees soit constante.      */
/*---------------------------------------------------------------------*/
#if defined( ALLOCATE_CONSTANT )
#   define BNIL          nil_object
#   define BFALSE        false_object
#   define BTRUE         true_object
#   define BUNSPEC       unspec_object
#   define BEOF          end_of_file_object
#   define BEOA          end_of_argument_object
    extern obj_t nil_object, unspec_object, end_of_file_object;
    extern obj_t true_object, false_object;
#else
#   define BNIL          ((obj_t)BCNST( 0 ))
#   define BFALSE        ((obj_t)BCNST( 1 ))
#   define BTRUE         ((obj_t)BCNST( 2 ))
#   define BUNSPEC       ((obj_t)BCNST( 3 ))
#   define BEOF          ((obj_t)BCNST( 4 ))
#   define BCHARH        ((obj_t)BCNST( 5 ))
#   define BEOA          ((obj_t)BCNST( 6 ))
#endif

/*---------------------------------------------------------------------*/
/*    Les macros GENERALES                                             */
/*    -------------------------------------------------------------    */
/*    Les macros concernant tous les objects. On trouve ici les        */
/*    macros qui ne sont pas propre a une categorie d'object en        */
/*    particulier.                                                     */
/*---------------------------------------------------------------------*/
#define OBJ_SIZE      ((int)(sizeof( ((obj_t)0) ) ))
#define HEADER( o )   (CREF( o )->header)
#define POINTERP( o ) (o && ((((int)o) & TAG_MASK) == TAG_STRUCT))

/*---------------------------------------------------------------------*/
/*    Il existe plusieurs procedures d'allocation. Les `atomic'        */
/*    concernent les allocations qui ne contiennent pas de pointer.    */
/*---------------------------------------------------------------------*/
#define MAKE_OBJECT( size, head )                                       \
   (an_object = ALLOCATE( size ),                                       \
    an_object->header = head, an_object)

#define MAKE_INLINE_OBJECT( size, head )                                \
   (an_object = INLINE_ALLOCATE( size ),                                \
    an_object->header = head, an_object)

#define MAKE_ATOMIC_OBJECT( size, head )                                \
   (an_object = ALLOCATE_ATOMIC( size ),                                \
    an_object->header = head, an_object)

#define EQP( o1, o2 ) ((int)o1 == (int)o2)

#define BOOLEANP( o ) (((int)o == (int)BTRUE) || ((int)o == (int)BFALSE))

#define NOT( o ) (!o)   

/*---------------------------------------------------------------------*/
/*    La manipulation des SYMBOLS (brrr !)                             */
/*---------------------------------------------------------------------*/
#define SYMBOLP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_SYMBOL))

#define SYMBOL( o )  (CREF( o )->symbol_t)
   
#define GET_HASH_NUMBER( s ) (obj_t)(get_hash_number( SYMBOL( s ).name ))

#define SYMBOL_SIZE (sizeof( ((obj_t)0)->symbol_t ))

#define SYMBOL_TO_STRING( o ) c_string_to_string( SYMBOL( o ).name )
   
/*---------------------------------------------------------------------*/
/*    le trippotage des PAIRs                                          */
/*---------------------------------------------------------------------*/
#define PAIR_SIZE (sizeof( ((obj_t)0)->pair_t ))

#define PAIR( o ) (CPAIR( o )->pair_t)

#if( GC == BOEHM_2_X_GC )
    extern obj_t make_pair();
#   define MAKE_PAIR( a, d ) make_pair( a, d )
#else
#   define MAKE_PAIR( a, d )                                            \
      (a_pair = MAKE_INLINE_OBJECT( PAIR_SIZE, HEADER_PAIR ),           \
       a_pair->pair_t.car = a,                                          \
       a_pair->pair_t.cdr = d,                                          \
       BREF( a_pair ) )
#endif

#if( !(defined( TAG_PAIR ) ) )
#   define PAIRP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_PAIR))
#else
#   define PAIRP( c ) ((c  && ((((int)c)&TAG_MASK) == TAG_PAIR)))
#endif

#define NULLP( c ) ((int)(c) == (int)BNIL)

#define CAR( c )   (PAIR( c ).car)
#define CDR( c )   (PAIR( c ).cdr)

#define SET_CAR( c, v ) ((CAR( c ) = v), c)
#define SET_CDR( c, v ) ((CDR( c ) = v), c)

/*---------------------------------------------------------------------*/
/*    Les CHARs                                                        */
/*---------------------------------------------------------------------*/
#define CHARP( o ) (((int)(o) & (int)(BCHARH)) == (int)BCHARH)

#define WRITE_CHAR( o, p ) \
   ((obj_t)(fputc( CCHAR( o ), OUTPUT_PORT( p ).file )), o)

#define CHAR_LT( o1, o2 ) ((int)o1 < (int)o2)
   
#define CHAR_GT( o1, o2 ) ((int)o1 > (int)o2)
   
#define CHAR_LE( o1, o2 ) ((int)o1 <= (int)o2)
   
#define CHAR_GE( o1, o2 ) ((int)o1 >= (int)o2)
   
#define CHAR_UPCASE( o )   BCHAR( toupper( CCHAR( o ) ) )
#define CHAR_DOWNCASE( o ) BCHAR( tolower( CCHAR( o ) ) )
  
/*---------------------------------------------------------------------*/
/*      Les STRINGs de caracteres                                      */
/*---------------------------------------------------------------------*/
#define STRINGP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_STRING))

#define STRING( o )  (CREF( o )->string_t)

#define STRING_SIZE (sizeof( ((obj_t)0)->string_t))

#define STRING_EGP( s1, s2 )  \
   (!strcmp( STRING( s1 ).string, STRING( s2 ).string ))

#define STRING_LENGTH( s ) (strlen( STRING( s ).string ))

#define STRING_REF( s, i ) (STRING( s ).string[ CINT( i ) ])

#define STRING_SET( s, i, c ) \
   ((obj_t)(((int)(STRING( s ).string[ CINT( i ) ] = CCHAR( c )))), s)

#define STRING_COPY( s ) (c_string_to_string( STRING( s ).string))
    
/*---------------------------------------------------------------------*/
/*    Les macros concernant les VECTORs                                */
/*---------------------------------------------------------------------*/
#define VECTOR_SIZE (sizeof( ((obj_t)0)->vector_t))

#define VECTOR( o ) CREF( o )->vector_t

#define VECTORP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_VECTOR))

#if( (2 == TAG_SHIFT) )
#   define VECTOR_REF( v, i ) \
       (*((obj_t *)((int)CREF( v ) + (VECTOR_SIZE - TAG_INT) + ((int)i))))
#else       
#   define VECTOR_REF( v, i ) \
       (*((obj_t *)(((int)CREF( v )) + VECTOR_SIZE + (OBJ_SIZE * CINT( i )))))
#endif       
    
#define VECTOR_SET( v, i, o ) ((VECTOR_REF( v, i ) = o), v)
   
#define VECTOR_LENGTH( v ) (VECTOR( v ).length)

/*---------------------------------------------------------------------*/
/*    L'ARITHMETIQUE qui comme elle se doit est divisee en deux        */
/*    parties, l'ARITHMETIQUE ENTIERE et l'ARITHMETIQUE FLOTANTE. En   */
/*    plus il y a quelques macros valables pour les deux arithmetiques.*/
/*---------------------------------------------------------------------*/
/*--- l'ARITHMETIQUE ENTIERE ------------------------------------------*/
#define INTEGERP( o ) ((((int)o) & TAG_MASK) == TAG_INT)

#if( !TAG_INT )
#   define ADD_I( a, b ) ((obj_t)((int)( a ) + (int)( b ))) 
#   define SUB_I( a, b ) ((obj_t)((int)( a ) - (int)( b ))) 
#   define MUL_I( a, b ) ((obj_t)((CINT( a ) * (int)b)))    
#   define DIV_I( a, b ) (BINT( (CINT( a )   / CINT( b )) ))
#   define ADD_I_PTAG( a, b ) (ADD_I( a, b ))
#   define SUB_I_PTAG( a, b ) (SUB_I( a, b ))
#   define PSUB_TAG( a ) BINT( a )
#   define PADD_TAG( a ) BINT( a )
#else
#   define ADD_I( a, b ) ((obj_t)(((int)( a ) & ~TAG_INT) + (int)( b )))
#   define SUB_I( a, b ) ((obj_t)(((int)( a ) - (int)( b )) | TAG_INT))
#   define MUL_I( a, b ) (BINT( (CINT( a )    * CINT( b )) ))
#   define DIV_I( a, b ) (BINT( (CINT( a )    / CINT( b )) ))
#   define ADD_I_PTAG( a, b ) ((obj_t)((int)(a) + (int)(b)))
#   define SUB_I_PTAG( a, b ) ((obj_t)((int)(a) - (int)(b)))
#   define PADD_TAG( a ) ((obj_t)((int)BINT( a ) + (int)TAG_INT))
#   define PSUB_TAG( a ) ((obj_t)((int)BINT( a ) - (int)TAG_INT))
#endif

#define EQ_I( x, y ) (((int)x) == ((int)y))
#define LT_I( x, y ) (((int)x) <  ((int)y))
#define LE_I( x, y ) (((int)x) <= ((int)y))
#define GT_I( x, y ) (((int)x) >  ((int)y))
#define GE_I( x, y ) (((int)x) >= ((int)y))

#define NEG_I( x ) (BINT( -CINT( x )))
#define ABS_I( x ) (LT_I( x, BINT(  0 )) ? BINT( -CINT( x ) ) : x)

#define BITOR( x, y )  BINT( CINT( x ) | CINT( y ) )
#define BITAND( x, y ) BINT( CINT( x ) & CINT( y ) )
#define BITXOR( x, y ) BINT( CINT( x ) ^ CINT( y ) )
#define BITNOT( x )    BINT( ~CINT(x) )
#define BITLSH( x, y ) BINT( CINT(x) << CINT(y) )
#define BITRSH( x, y ) BINT( CINT(x) >> CINT(y) )

#define REMAINDER_I( a, b ) (BINT( (CINT( a ) % CINT( b )) ))
#define QUOTIENT_I( x, y ) DIV_I( x, y )

#define ODDP_I( x )  (CINT( x ) & 0x1)
#define EVENP_I( x ) (!ODDP_I( x ))

/*--- l'ARITHMETIQUE FLOTANTE -----------------------------------------*/
#define REAL_SIZE (sizeof( ((obj_t)0)->real_t ))

#define REALP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_REAL))

#define REAL( o ) CREF( o )->real_t

#define ADD_R( a, b ) (make_real( REAL( a ).real + REAL( b ).real))
#define SUB_R( a, b ) (make_real( REAL( a ).real - REAL( b ).real))
#define MUL_R( a, b ) (make_real( REAL( a ).real * REAL( b ).real))
#define DIV_R( a, b ) (make_real( REAL( a ).real / REAL( b ).real))
#define NEG_R( a )    (make_real( -REAL( a ).real ))
    
#define EQ_R( x, y ) ((REAL( x ).real) == (REAL( y ).real))
#define LT_R( x, y ) ((REAL( x ).real) < (REAL( y ).real))
#define LE_R( x, y ) ((REAL( x ).real) <= (REAL( y ).real))
#define GT_R( x, y ) ((REAL( x ).real) > (REAL( y ).real))
#define GE_R( x, y ) ((REAL( x ).real) >= (REAL( y ).real))

#define ZEROP_R( x )  ((REAL( x ).real) == (double)(0.0))
#define POSITIVEP_R(x) ((REAL( x ).real) > (double)(0.0))
#define NEGATIVEP_R(x) ((REAL( x ).real) < (double)(0.0))
    
#define ABS_R( x ) (REAL( x ).real < 0 ? make_real( -REAL( x ).real ) : x)
                                          
/*--- Les fonctions de converstions arithmetiques ---------------------*/
#define INT_TO_REAL(x) (make_real( (double)(CINT( x )) ))
#define REAL_TO_INT(x) (BINT( (int)(REAL( x ).real) ))
    
/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDUREs                                   */
/*---------------------------------------------------------------------*/
#define PROCEDURE_SIZE (sizeof( ((obj_t)0)->procedure_t))

#define PROCEDURE( o ) CREF( o )->procedure_t

#define PROCEDURE_ENTRY( fun ) (obj_t)(PROCEDURE( fun ).entry)
#define PROCEDURE_VA_ENTRY( fun ) (obj_t)(PROCEDURE( fun ).va_entry)

#define PROCEDUREP( fun ) \
   (POINTERP( fun ) && (HEADER( fun ) == HEADER_PROCEDURE))

#define VA_PROCEDUREP( fun ) LT_I( PROCEDURE( fun ).arity, BINT( 0 ))
   
#define PROCEDURE_ARITY( fun ) (PROCEDURE( fun ).arity)

#define PROCEDURE_ENV_REF( p, i ) \
   (*((obj_t *)(((int)&(PROCEDURE( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_ENV_SET( p, i, o ) ((PROCEDURE_ENV_REF( p, i ) = o), p)

/*---------------------------------------------------------------------*/
/*      Les CELLules                                                   */
/*---------------------------------------------------------------------*/
#define CELL_SIZE (sizeof( ((obj_t)0)->cell_t))

#define CELL( o ) CREF( o )->cell_t

#define MAKE_CELL( v )                                                  \
   ( a_cell = MAKE_OBJECT( CELL_SIZE, HEADER_CELL ),                    \
     a_cell->cell_t.obj = (obj_t)(v),                                   \
     BREF( a_cell ) )

#define CELL_SET( c, v ) ((CELL( c ).obj = v), c)
   
#define CELL_REF( c )    (CELL( c ).obj)

/*---------------------------------------------------------------------*/
/*    Les macros d'access aux OUTPUT_PORTs                             */
/*---------------------------------------------------------------------*/
#define OUTPUT_PORT_SIZE (sizeof( ((obj_t)0)->output_port_t ))

#define OUTPUT_PORT( o ) CREF( o )->output_port_t

#define OUTPUT_PORTP( o ) \
   (POINTERP( o ) && (HEADER( o ) == HEADER_OUTPUT_PORT))

#define FLUSH_OUTPUT_PORT( o ) ((fflush( OUTPUT_PORT( o ).file )), o)
   
/*---------------------------------------------------------------------*/
/*    Les macros d'access aux INPUT_PORTs                              */
/*---------------------------------------------------------------------*/
#define CLASS_FILE    BINT( 0 )
#define CLASS_CONSOLE BINT( 1 )
#define CLASS_STRING  BINT( 2 )
   
#define INPUT_PORT_SIZE (sizeof( ((obj_t)0)->input_port_t ))

#define INPUT_PORT( o ) CREF( o )->input_port_t

#define INPUT_PORTP( o ) \
    (POINTERP( o ) && (HEADER( o ) == HEADER_INPUT_PORT))

#define BUFFER( p ) ((char *) & (INPUT_PORT( p ).buffer))

#define EOF_OBJECTP( o ) ( o == BEOF )
    
/*--- Les macros de lecture -------------------------------------------*/
#define INPUT_PORT_READ_CHAR( p )                                           \
   (INPUT_PORT( p ).forward = ADD_I_PTAG( INPUT_PORT( p ).forward,          \
                                          PSUB_TAG( 1 ) ),                  \
     (int)((int)BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward ) - 1 ] ) )

#define READ_CHAR( p )                                                      \
   ( INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     INPUT_PORT( p ).forward = ADD_I_PTAG( INPUT_PORT( p ).forward,         \
                                           PSUB_TAG( 1 ) ),                 \
     BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward )-1 ] ?                \
     BCHAR( BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward )-1 ] ) :       \
        !input_port_fill_buffer( p )?                                       \
           INPUT_PORT( p ).forward =                                        \
             SUB_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),          \
           BEOF :                                                           \
           ( INPUT_PORT( p ).forward =                                      \
               ADD_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),        \
             BCHAR( BUFFER( p )[ (int)CINT( INPUT_PORT( p ).backward ) ] ) ) )
   
#define PEEK_CHAR( p )                                                      \
   ( INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward ) ] ?                  \
      BCHAR( BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward )] ) :         \
        (!input_port_fill_buffer( p )) ?                                    \
           BEOF :                                                           \
           (INPUT_PORT( p ).forward =                                       \
              ADD_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),         \
           BCHAR( BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward ) ] ) ))

#define INPUT_PORT_THROW_CHAR( p, n )                                       \
   INPUT_PORT( p ).backward = ADD_I( INPUT_PORT( p ).backward, n )

#define INPUT_PORT_REMEMBER_REF( p )                                        \
   INPUT_PORT( p ).remember = INPUT_PORT( p ).forward
   
#define INPUT_PORT_REMEMBER_BACK_REF( p )                                   \
   INPUT_PORT( p ).remember = SUB_I_PTAG( INPUT_PORT( p ).forward,          \
                                          PSUB_TAG( 1 ) )
      
#define INPUT_PORT_EOFP( p )                                                \
   ( (INPUT_PORT( p ).eof &&                                                \
      (BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward ) ] == '\0')) ?      \
     BTRUE : BFALSE )

#define INPUT_PORT_EOLP( p )                                                \
   ( (BUFFER( p )[ (int)CINT( INPUT_PORT( p ).forward ) ] == '\n') ?        \
      BTRUE : BFALSE )
      
#define INPUT_PORT_BOLP( p )                                                \
   ( (!INPUT_PORT( p ).backward ||                                          \
      (BUFFER( p )[ (int)CINT( INPUT_PORT( p ).backward ) - 1 ] == '\n'))  ?\
      BTRUE : BFALSE )
   
#define INPUT_PORT_GET_LENGTH( p )                                          \
   SUB_I( INPUT_PORT( p ).backward, INPUT_PORT( p ).mark)

#define INPUT_PORT_STOLE_CHAR( p )                                          \
   ( INPUT_PORT( p ).backward = ADD_I_PTAG( INPUT_PORT( p ).backward,       \
                                            PSUB_TAG( 1 ) ),                \
     INPUT_PORT( p ).forward = INPUT_PORT( p ).remember =                   \
     INPUT_PORT( p ).backward,                                              \
      BUFFER( p )[ (int)CINT( INPUT_PORT( p ).remember ) - 1 ] ?            \
        BCHAR( BUFFER( p )[ (int)CINT( INPUT_PORT( p ).remember )-1 ] ) :   \
        BEOF )
   
#define INPUT_PORT_AJUST_CURSOR( p )                                        \
   ( INPUT_PORT( p ).forward  = INPUT_PORT( p ).remember,                   \
     INPUT_PORT( p ).mark     = INPUT_PORT( p ).backward,                   \
     INPUT_PORT( p ).backward = INPUT_PORT( p ).forward )
   
/*---------------------------------------------------------------------*/
/*    Les STRUCtures                                                   */
/*---------------------------------------------------------------------*/
#define STRUCT_SIZE (sizeof( ((obj_t)0)->struct_t))

#define STRUCT( o ) CREF( o )->struct_t

#define STRUCTP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_STRUCT))

#define STRUCT_KEY( c ) STRUCT( c ).key

#define STRUCT_LENGTH( c ) STRUCT( c ).length
   
#define STRUCT_SLOT_REF( c, i )                                        \
   (*((obj_t *)(((int)&(STRUCT( c ).slot)) + (OBJ_SIZE * CINT( i ) ))))

#define STRUCT_SLOT_SET( c, i, o ) ((STRUCT_SLOT_REF( c, i ) = o), c)

/*---------------------------------------------------------------------*/
/*    Le `CASTING'                                                     */
/*---------------------------------------------------------------------*/
#define CBOOL_TO_BBOOL( o ) (o ? BTRUE : BFALSE )
#define BBOOL_TO_CBOOL( o ) (o != BFALSE)

#define CSTRING_TO_BSTRING( s ) c_string_to_string( s )
#define BSTRING_TO_CSTRING( s ) (STRING( s ).string)

#define CHAR_TO_INT( c ) BINT( (CCHAR( c )) )
#define INT_TO_CHAR( i ) BCHAR( CINT( i ) )

#define DOUBLE_TO_REAL( d ) (make_real( d ))
#define REAL_TO_DOUBLE( r ) (REAL( r ).real)
   
/*---------------------------------------------------------------------*/
/*    Les `STACK' (cf. call/cc)                                        */
/*---------------------------------------------------------------------*/
#define STACK_SIZE  (sizeof( ((obj_t)0)->stack_t))
   
#define STACK( _o_ ) CREF( _o_ )->stack_t

#define STACKP( _s_ ) (POINTERP( _s_ ) && (HEADER( _s_ ) == HEADER_STACK))

#define MAKE_STACK( _size_ ) \
   (BREF( MAKE_OBJECT( STACK_SIZE + (int)_size_, HEADER_STACK )))
   
/*---------------------------------------------------------------------*/
/*    Les `LOCATION's                                                  */
/*---------------------------------------------------------------------*/
#define LOCATION( x )        BREF( &x )
#define LOCATION_REF( x )    (*((obj_t *)CREF( x )))
#define LOCATION_SET( x, y ) ((LOCATION_REF( x ) = (obj_t)y ), y)

/*---------------------------------------------------------------------*/
/*    Les macros, structures et externes de debug bigloo.              */
/*---------------------------------------------------------------------*/
struct dframe {
   obj_t          symbol;
   struct dframe *link;
};

#define PUSH_LAMBDA_TRACE( name )                  \
   struct dframe frame;                            \
                                                   \
   frame.symbol = name;                            \
   frame.link   = top_of_frame;                    \
   top_of_frame = &frame;            
   
#define POP_LAMBDA_TRACE( res )  \
   ( top_of_frame = top_of_frame->link, res )

#define GET_LAMBDA_STACK() BREF( top_of_frame )
#define SET_LAMBDA_STACK( t ) \
   ( top_of_frame = (struct dframe *)CREF( t ), BUNSPEC )

extern struct dframe *top_of_frame;

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t an_object, a_pair;
extern obj_t a_procedure, a_cell;
extern obj_t __ContinueValue;
extern obj_t c_constant_string_to_string();
extern unsigned char input_port_fill_buffer();

extern obj_t c_string_to_string();
extern obj_t c_string_to_symbol();

extern obj_t apply();
extern obj_t eval_apply();

extern double strtod();
extern obj_t make_real();

#endif
