/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.3/Gc/inline_alloc.c ...     */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Nov 13 09:54:36 1992                          */
/*    Last change :  Wed Jun  9 12:48:30 1993  (serrano)               */
/*                                                                     */
/*    On essaye de faire un cons inliner                               */
/*---------------------------------------------------------------------*/
#ifndef GC_PRIVATE_H
#  include "gc_private.h"
#endif
#undef abs

#if defined( NULL )
#   undef NULL
#endif

#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_pair( car, cdr )
obj_t car, cdr;
{
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
#define NUMBER_OF_CONS_WORDS BYTES_TO_WORDS( PAIR_SIZE )

   opp =  &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);
   FASTLOCK();
   
   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      op = GC_generic_malloc_words_small(NUMBER_OF_CONS_WORDS, NORMAL);
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();
   }

#if( !defined( TAG_PAIR ) )   
   (((obj_t)op)->pair_t).header = HEADER_PAIR;
#endif   
   (((obj_t)op)->pair_t).car    = car;
   (((obj_t)op)->pair_t).cdr    = cdr;
   
   return BPAIR( (obj_t)op );
}
    
/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_real( d )
double d;
{
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;

#define NUMBER_OF_FLOAT_WORDS BYTES_TO_WORDS( REAL_SIZE )

   opp =  &(GC_objfreelist[ NUMBER_OF_FLOAT_WORDS ]);
   FASTLOCK();
   
   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      op = GC_generic_malloc_words_small(NUMBER_OF_FLOAT_WORDS, PTRFREE);
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
      FASTUNLOCK();
   }

   (((obj_t)op)->real_t).header = HEADER_REAL;
   (((obj_t)op)->real_t).real   = d;  

   return BREF( (obj_t)op );
}

