/*---------------------------------------------------------------------*/
/*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.3/Clib/writer.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 17 09:44:20 1991                          */
/*    Last change :  Mon Jun  7 10:04:14 1993  (serrano)               */
/*                                                                     */
/*    On imprime les objets (non recursifs)                            */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t c_constant_string_to_string();

/*---------------------------------------------------------------------*/
/*    Les noms des caracateres                                         */
/*---------------------------------------------------------------------*/
static char *char_name[] =
{
   "NULL","SOH","STX","ETX","EOT","ENQ","ACK","BEL",
   "BS",  "tab", "newline", "VT", "NP", "CR", "SO", "SI",
   "DLE", "DC1","DC2","DC3","DC4","NAK","SYN","ETB",
   "CAN", "EM", "SUB","ESC","FS", "GS", "RS", "US",
   "space", "!", "\\\"","#","$","%","&","\\\'",
   "(", ")", "*", "+", ",", "-", ".", "/",
   "0", "1", "2", "3", "4", "5", "6", "7",
   "8", "9", ":", ";", "<", "=", ">", "?",
   "@", "A", "B", "C", "D", "E", "F", "G",
   "H", "I", "J", "K", "L", "M", "N", "O",
   "P", "Q", "R", "S", "T", "U", "V", "W",
   "X", "Y", "Z", "[", "\\", "]", "^", "_",
   "`", "a", "b", "c", "d", "e", "f", "g",
   "h", "i", "j", "k", "l", "m", "n", "o",
   "p", "q", "r", "s", "t", "u", "v", "w",
   "x", "y", "z", "{", "|", "}", "~", "DEL"
};

/*---------------------------------------------------------------------*/
/*    write_object ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_object( o, f )
obj_t o, f;
{
   FILE *fout = OUTPUT_PORT( f ).file;

   if( INTEGERP( o ) )
   {
      fprintf( fout, "%d", CINT( o ) );
      return o;
   }
   else
      if( CHARP( o ) )
      {
         fputc( CCHAR( o ), fout );
         return BUNSPEC;
      }
      else
         switch( (int)o )
         {
#if !(defined( ALLOCATE_CONSTANT ))
            case (int)BNIL :
               fputs( "()", fout );
               return BNIL;

            case (int)BUNSPEC :
               fputs( "#UNSPECIFIED", fout );
               return BUNSPEC;
            
            case (int)BFALSE :
               fputs( "#f", fout );
               return BFALSE;
            
            case (int)BTRUE :
               fputs( "#t", fout );
               return BTRUE;

            case (int)BEOF :
               fputs( "#<END OF FILE>", fout);
               return BEOF;
#endif
               
            default :
               if( !POINTERP( o ) )
               {
                  fprintf( fout, "#<???>" );
                  return BUNSPEC;
               }
               else
                  switch( HEADER( o ) )
                  {
#if defined( ALLOCATE_CONSTANT )
                     case HEADER_TRUE :
                        fputs( "#t", fout );
                        return BTRUE;
                        
                     case HEADER_FALSE :
                        fputs( "#f", fout );
                        return BFALSE;
                  
                     case HEADER_NIL :
                        fputs( "", fout );
                        return BNIL;
                  
                     case HEADER_UNDEF :
                        fputs( "#UNDEF", fout );
                        return BUNSPEC;

                     case HEADER_EOF :
                        fputs( "#<END OF FILE>", fout);
                        return BEOF;
#endif
                     case HEADER_STRING :
                        fputs( STRING( o ).string, fout );
                        return o;
               
                     case HEADER_SYMBOL :
                        fputs( SYMBOL( o ).name, fout );
                        return o;
               
                     case HEADER_REAL :
                        fprintf( fout, "%f", REAL( o ).real );
                        return o;
               
                     case HEADER_PROCEDURE :
                        fprintf( fout, "#<procedure:%x.%d>", o,
                                 PROCEDURE( o ).arity );
                        return o;
                  
                     case HEADER_OUTPUT_PORT :
                        fprintf( fout, "#<output_port:%s>",
                                 OUTPUT_PORT( o ).name );
                        return o;
                     
                     case HEADER_INPUT_PORT :
                        fprintf( fout, "#<input_port:%x.%s.%d>",
                                 o,
                                 INPUT_PORT( o ).name,
                                 INPUT_PORT( o ).bufsiz );
                        return o;
               
                     default :
                        fprintf( fout, "#<???>" );
                        return o;
            }
      }
}
         
/*---------------------------------------------------------------------*/
/*    write_string ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_string( string, port )
obj_t string, port;
{
   FILE *fout = OUTPUT_PORT( port ).file;
   char *aux  = STRING( string ).string;
   
   fputc( '"', fout );
   fputs( aux, fout );
   fputc( '"', fout );
   return string;
}

/*---------------------------------------------------------------------*/
/*    write_char ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
write_char( c, port )
obj_t c, port;
{
   FILE *fout = OUTPUT_PORT( port ).file;
   char *aux;

   aux = ( CCHAR( c ) < 127 ) ? char_name[ CCHAR( c ) ] : "???";
   
   fputs( "#\\", fout );
   fputs( aux, fout );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    ill_char_rep ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
ill_char_rep( c )
obj_t c;
{
   char aux[ 10 ];

   sprintf( aux, "#a%d", CCHAR( c ) );

   return c_constant_string_to_string( aux );
}
