/*---------------------------------------------------------------------*/
/*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.3/Clib/vector.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 10 14:55:28 1991                          */
/*    Last change :  Tue Jun 15 14:34:39 1993  (serrano)               */
/*                                                                     */
/*    La gestion des vecteurs                                          */
/*---------------------------------------------------------------------*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    make_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_vector( klen, init )
obj_t  klen;
obj_t  init;
{
   obj_t vector;
   int   i;
   int   len = CINT( klen );

   vector = MAKE_OBJECT( VECTOR_SIZE + ( len * OBJ_SIZE ),
                         HEADER_VECTOR );
   vector->vector_t.length = klen;
   for( i = 0; i < len; i++ )
      (*((obj_t *)(((int)vector) + VECTOR_SIZE + (OBJ_SIZE * i)))) = init;
      
   return BREF( vector );
}

