/*---------------------------------------------------------------------*/
/*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.2/Clib/symbol.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Feb 12 14:51:41 1992                          */
/*    Last change :  Sat Apr 10 16:48:35 1993  (serrano)               */
/*                                                                     */
/*    La gestion des symbol (leur creation et la table de hash)        */
/*    -------------------------------------------------------------    */
/*    Dans tout le code qui suit on est oblige de prendre certaines    */
/*    precautions:                                                     */
/*       - Le code ne peut pas etre ecrit en `Bigloo' car le code est  */
/*         commun au mode `scheme' et `xla'. On veut donc que le link  */
/*         avec la libairie `scheme' soit facultatif.                  */
/*       - On est obliger malgre C de respecter les structures `K2'    */
/*         ainsi que l'appel aux procedures d'allocations pour le `GC' */
/*         soit capable d'aller scruter la table des symboles.         */
/*---------------------------------------------------------------------*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Quelques prototypes                                              */
/*---------------------------------------------------------------------*/
extern obj_t c_string_to_symbol();
static obj_t make_symbol();
extern obj_t make_vector();

/*---------------------------------------------------------------------*/
/*    Quelques variables statics                                       */
/*---------------------------------------------------------------------*/
static obj_t symtab;
static obj_t c_symtab;
static char  hash_random_table[] = {
   1, 14, 110, 25, 97, 174, 132, 119, 138, 170, 125, 118, 27, 233, 140, 51,
   87, 197, 177, 107, 234, 169, 56, 68, 30, 7, 173, 73, 188, 40, 36, 65,
   49, 213, 104, 190, 57, 211, 148, 223, 48, 115, 15, 2, 67, 186, 210, 28,
   12, 181, 103, 70, 22, 58, 75, 78, 183, 167, 238, 157, 124, 147, 172, 144,
   176, 161, 141, 86, 60, 66, 128, 83, 156, 241, 79, 46, 168, 198, 41, 254,
   178, 85, 253, 237, 250, 154, 133, 88, 35, 206, 95, 116, 252, 192, 54, 221,
   102, 218, 255, 240, 82, 106, 158, 201, 61, 3, 89, 9, 42, 155, 159, 93,
   166, 80, 50, 34, 175, 195, 100, 99, 26, 150, 16, 145, 4, 33, 8, 189,
   121, 64, 77, 72, 208, 245, 130, 122, 143, 55, 105, 134, 29, 164, 185, 194,
   193, 239, 101, 242, 5, 171, 126, 11, 74, 59, 137, 228, 108, 191, 232, 139,
   6, 24, 81, 20, 127, 17, 91, 92, 251, 151, 225, 207, 21, 98, 113, 112,
   84, 226, 18, 214, 199, 187, 13, 32, 94, 220, 224, 212, 247, 204, 196, 43,
   249, 236, 45, 244, 111, 182, 153, 136, 129, 90, 217, 202, 19, 165, 231, 71,
   230, 142, 96, 227, 62, 179, 246, 114, 162, 53, 160, 215, 205, 180, 47, 109,
   44, 38, 31, 149, 135, 0, 216, 52, 63, 23, 37, 69, 39, 117, 146, 184,
   163, 200, 222, 235, 248, 243, 219, 10, 152, 131, 123, 229, 203, 76, 120, 209
};

/*---------------------------------------------------------------------*/
/*    init_symbol_table ...                                            */
/*---------------------------------------------------------------------*/
init_symbol_table()
{
   symtab = make_vector( BINT( HASH_TABLE_SIZE() ), BNIL );
   c_symtab = CREF( symtab );
}

/*---------------------------------------------------------------------*/
/*    get_hash_number ...                                              */
/*    char* --> int                                                    */
/*---------------------------------------------------------------------*/
int
get_hash_number( string )
char *string;
{
   unsigned char hash = 0;

   while( *string )
      hash = hash_random_table[ hash ^ (unsigned char)(*string++) ];
      
   return hash;
}
      
/*---------------------------------------------------------------------*/
/*    make_symbol ...                                                  */
/*---------------------------------------------------------------------*/
static obj_t
make_symbol( name )
char *name;
{
   obj_t symbol;
   
   symbol = MAKE_OBJECT( SYMBOL_SIZE, HEADER_SYMBOL );
   symbol->symbol_t.name = (char *)ALLOCATE_ATOMIC( strlen( name ) + 1 );
   
   strcpy( symbol->symbol_t.name, name );

   return BREF( symbol );
}
   
/*---------------------------------------------------------------------*/
/*    c_string_to_symbol ...                                           */
/*    char * --> obj_t                                                 */
/*---------------------------------------------------------------------*/
obj_t
c_string_to_symbol( name )
char *name;
{
   int hash_number;
   obj_t bucket;

/*---------------------------------------------------------------------*/
/*    Veut-on des symbols `case unsensitive' ?                         */
/*---------------------------------------------------------------------*/
#define SYMBOL_UNCASE_SENSITIVE 1

#ifdef SYMBOL_UNCASE_SENSITIVE

   char *upname;
   char *read;
   char *write;

   upname = (char *)ALLOCATE( strlen( name ) + 1 );
   
   for( read = name, write = upname; *read; read++, write++ )
      *write = toupper( *read );
      
   *write = '\0';
#else
   char *upname = name;
#endif

   hash_number = get_hash_number( upname );
   bucket = *(obj_t *)(((int)&c_symtab->vector_t) +
                        VECTOR_SIZE + (OBJ_SIZE * hash_number));
   
   if( NULLP( bucket ) )
   {
      obj_t symbol = make_symbol( upname );
      
      *(obj_t *)(((int)&c_symtab->vector_t) +
                  VECTOR_SIZE +
                  (OBJ_SIZE * hash_number)) = MAKE_PAIR( symbol, BNIL );
      
      return symbol;
   }
   else
   {
      obj_t run = bucket, back = bucket;
      
      while( !NULLP( run ) &&
             strcmp( STRING( CAR( run ) ).string, upname ) )
         back = run, run = CDR( run );
      
      if( !NULLP( run ) )
         return CAR( run );
      else
      {
         obj_t symbol = make_symbol( upname );

         SET_CDR( back, MAKE_PAIR( symbol, BNIL ) );

         return symbol;
      }
   }
}



      
   
   
