/*---------------------------------------------------------------------*/
/*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.2/Clib/string.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 11:33:47 1992                          */
/*    Last change :  Sat Apr 10 17:10:52 1993  (serrano)               */
/*                                                                     */
/*    La gestion C des chaines de caracteres                           */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    make_string ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_string( k, c )
int_t  k;
obj_t  c;
{
   obj_t string;
   int i;
   int len = CINT( k );
   
   string = MAKE_OBJECT( STRING_SIZE, HEADER_STRING );

   string->string_t.string = (char *)ALLOCATE_ATOMIC( len + 1 );
   for( i = 0; i < len; i++ )
      string->string_t.string[ i ] = CCHAR( c );

   string->string_t.string[ i ] = '\0';

   return BREF( string );
}

/*---------------------------------------------------------------------*/
/*    c_constant_string_to_string ...                                  */
/*---------------------------------------------------------------------*/
obj_t
c_constant_string_to_string( c_string )
char *c_string;
{
   obj_t string;
   
   string = MAKE_OBJECT( STRING_SIZE, HEADER_STRING );
   
   string->string_t.string = c_string;
     
   return BREF( string );
}

/*---------------------------------------------------------------------*/
/*    c_string_to_string ...                                           */
/*---------------------------------------------------------------------*/
obj_t
c_string_to_string( c_string )
char *c_string;
{
   obj_t string;
   int i;

   if( !c_string )
      c_string = "";
      
   string = MAKE_OBJECT( STRING_SIZE, HEADER_STRING );

   string->string_t.string = (char *)ALLOCATE_ATOMIC( strlen( c_string ) + 1 );
   
   strcpy( string->string_t.string, c_string );

   return BREF( string );
}

/*---------------------------------------------------------------------*/
/*    string_append ...                                                */
/*---------------------------------------------------------------------*/
obj_t
string_append( s1, s2 )
obj_t s1, s2;
{
   int l1, l2;
   char *reader;
   char *writer;
   obj_t string;
   
   l1 = strlen( STRING( s1 ).string );
   l2 = strlen( STRING( s2 ).string );

   string = MAKE_OBJECT( STRING_SIZE, HEADER_STRING );
   string->string_t.string = (char *)ALLOCATE_ATOMIC( l1 + l2 + 1 );

   writer = string->string_t.string, reader = STRING( s1 ).string;
   while( *reader )
      *writer++ = *reader++;

   reader = STRING( s2 ).string;
   while( *reader )
      *writer++ = *reader++;
      
   *writer = '\0';

   return BREF( string );
}
 
/*---------------------------------------------------------------------*/
/*    substring ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
c_substring( src_string, min, max )
obj_t src_string, min, max;
{
   int len;
   obj_t dst_string;
   
   len = CINT( SUB_I( max, min ) );

   dst_string = MAKE_OBJECT( STRING_SIZE, HEADER_STRING );
   dst_string->string_t.string = (char *)ALLOCATE_ATOMIC( len + 1 );

   strncpy( dst_string->string_t.string,
            &(STRING( src_string ).string[ CINT( min ) ]),
            len );
   dst_string->string_t.string[ len ] = '\0';

   return BREF( dst_string );
}
   
/*---------------------------------------------------------------------*/
/*    integer_to_string ...                                            */
/*---------------------------------------------------------------------*/
char *
integer_to_string( x, radix )
int x, radix;
{
   char *aux;

   aux = (char *)ALLOCATE_ATOMIC( 1024 );

   switch( radix )
   {
      case 8 :
         sprintf( aux, "#o%o", x );
         break;
         
      case 10 :
         sprintf( aux, "%d", x );
         break;
         
      case 16 :
         sprintf( aux, "#x%x", x );
         break;
   }

   return aux;
}

/*---------------------------------------------------------------------*/
/*    real_to_string ...                                               */
/*---------------------------------------------------------------------*/
char *
real_to_string( x )
double x;
{
   char *aux;

   aux = (char *)ALLOCATE_ATOMIC( 1024 );

   sprintf( aux, "%f", x );
   
   return aux;
}

/*---------------------------------------------------------------------*/
/*    strcicmp ...                                                     */
/*---------------------------------------------------------------------*/
unsigned char
strcicmp( st1, st2 )
char *st1, *st2;
{
   for( ; tolower( *st1 ) == tolower( *st2 ); st1++, st2++ )
      if( *st1 == '\0' )
         return 1;

   return 0;
}

/*---------------------------------------------------------------------*/
/*    string_lt ...                                                    */
/*---------------------------------------------------------------------*/
unsigned char
string_lt( st1, st2 )
char *st1, *st2;
{
   for( ; *st1 == *st2; st1++, st2++ )
      if( *st1 == '\0' )
         return 0;

   return *st1 < *st2;
}

/*---------------------------------------------------------------------*/
/*    string_le ...                                                    */
/*---------------------------------------------------------------------*/
unsigned char
string_le( st1, st2 )
char *st1, *st2;
{
   for( ; *st1 == *st2; st1++, st2++ )
      if( *st1 == '\0' )
         return 1;

   return *st1 <= *st2;
}

/*---------------------------------------------------------------------*/
/*    string_gt ...                                                    */
/*---------------------------------------------------------------------*/
unsigned char
string_gt( st1, st2 )
char *st1, *st2;
{
   for( ; *st1 == *st2; st1++, st2++ )
      if( *st1 == '\0' )
         return 0;

   return *st1 > *st2;
}

/*---------------------------------------------------------------------*/
/*    string_ge ...                                                    */
/*---------------------------------------------------------------------*/
unsigned char
string_ge( st1, st2 )
char *st1, *st2;
{
   for( ; *st1 == *st2; st1++, st2++ )
      if( *st1 == '\0' )
         return 1;

   return *st1 >= *st2;
}

/*---------------------------------------------------------------------*/
/*    string_cilt ...                                                  */
/*---------------------------------------------------------------------*/
unsigned char
string_cilt( st1, st2 )
char *st1, *st2;
{
   for( ; tolower( *st1 ) == tolower( *st2 ); st1++, st2++ )
      if( *st1 == '\0' )
         return 0;

   return tolower( *st1 ) < tolower( *st2 );
}

/*---------------------------------------------------------------------*/
/*    string_cile ...                                                  */
/*---------------------------------------------------------------------*/
unsigned char
string_cile( st1, st2 )
char *st1, *st2;
{
   for( ; tolower( *st1 ) == tolower( *st2 ); st1++, st2++ )
      if( *st1 == '\0' )
         return 1;

   return tolower( *st1 ) <= tolower( *st2 );
}

/*---------------------------------------------------------------------*/
/*    string_cigt ...                                                  */
/*---------------------------------------------------------------------*/
unsigned char
string_cigt( st1, st2 )
char *st1, *st2;
{
   for( ; tolower( *st1 ) == tolower( *st2 ); st1++, st2++ )
      if( *st1 == '\0' )
         return 0;

   return tolower( *st1 ) > tolower( *st2 );
}

/*---------------------------------------------------------------------*/
/*    string_cige ...                                                  */
/*---------------------------------------------------------------------*/
unsigned char
string_cige( st1, st2 )
char *st1, *st2;
{
   for( ; tolower( *st1 ) == tolower( *st2 ); st1++, st2++ )
      if( *st1 == '\0' )
         return 1;

   return tolower( *st1 ) >= tolower( *st2 );
}

/*---------------------------------------------------------------------*/
/*    escape_string ...                                                */
/*    -------------------------------------------------------------    */
/*    Cette fonction construit une chaine ou la representation des     */
/*    caracteres de controles a ete remplacee par ces caracteres.      */
/*    ex:     +---+---+---+---+          +---+---+---+                 */
/*            | \ | n | a | 0 |    ==>   | \n| a | 0 |                 */
/*            +---+---+---+---+          +---+---+---+                 */
/*    Cette conversion est utile pour l'interprete car les chaines     */
/*    lues ne sont pas parsees. On donne donc la possibilite de le     */
/*    faire avec cette fonction.                                       */
/*---------------------------------------------------------------------*/
char *
escape_string( src )
char *src;
{
   int   len = strlen( src );
   char *dst = (char *)ALLOCATE_ATOMIC( len + 1 );
   char *head = dst;

   while( *src )
   {
      if( *src != '\\' )
         *dst++ = *src++;
      else
      {
         switch( *++src ) 
         {
            case '\0' : *dst++ = '\\';
                        break;

            case 'n'  : *dst++ = '\n';
                        break;
                        
            case 't'  : *dst++ = '\t';
                        break;
                        
            case 'b'  : *dst++ = '\b';
                        break;
                        
            case 'r'  : *dst++ = '\r';
                        break;
                        
            case 'f'  : *dst++ = '\f';
                        break;
                        
            case 'v'  : *dst++ = '\v';
                        break;
                        
            case '\\' : *dst++ = '\\';
                        break;
                        
            case '\'' : *dst++ = '\'';
                        break;
                        
            case '"'  : *dst++ = '\"';
                        break;

#if( defined( __STDC___ ) )                          
            case 'a'  : *dst++ = '\a';
                        break;

            case '?'  : *dst++ = '\?';
                        break;
#endif                        

            default   : *dst++ = *src;
                        break;
         }
         src++;
      }
   }
   *dst = '\0';
   
   return head;
}
       
