;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/rgc-trap.scm ...             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 24 14:24:02 1992                          */
;*    Last change :  Fri Nov 27 17:59:45 1992  (serrano)               */
;*                                                                     */
;*    Un essai de grammaire qui trappe                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc-trap
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc-trap)))

;*---------------------------------------------------------------------*/
;*    rgc-test ...                                                     */
;*---------------------------------------------------------------------*/
(define (rgc-test)
   (let ((ncontext      0)
	 (ntiti         0)
	 (neol          0)
	 (nbol          0)
	 (neof          0)
	 (n             0))
      (let ((grammar (regular-grammar ((lettre  (>-< #\a #\z)))
			((+ (in #\space #\newline))
			 (set! n (+ (the-length) n))
			 (ignore))
			(titi ("titi")
			      (context)
			      (set! n (+ (the-length) n))
			      (set! ncontext (+ 1 ncontext))
			      (ignore))
			(("titi")
			 (set! ntiti (+ 1 ntiti))
			 (set! n (+ (the-length) n)) 
			 (context 'titi)
			 (ignore))
			((eof "toto")
			 (set! n (+ (the-length) n))
			 (set! neof (+ 1 neof))
			 (ignore))
			((eol "toto")
			 (set! n (+ (the-length) n))
			 (set! neol (+ 1 neol))
			 (ignore))
			((bol "toto")
			 (set! nbol (+ 1 nbol))
			 (ignore))
			(("toto")
			 (set! n (+ (the-length) n)) 
			 (ignore))
			((+ lettre)
			 (set! n (+ (the-length) n)) 
			 (ignore)))))
	 (labels ((foo (port)
		       (let loop ((r (read/rp grammar port)))
			  (if (eof-object? r)
			      (list ncontext ntiti neol nbol neof n)
			      (loop (read/rp grammar port))))))
	    (call-with-input-file "misc/trap.txt" foo)))))
      
;*---------------------------------------------------------------------*/
;*    test-rgc-trap ...                                                */
;*---------------------------------------------------------------------*/
(define (test-rgc-trap)
   (test-module "rgc-trap" "rgc-trap.scm" #f)
   (test "test" (rgc-test) '(3 3 3 3 1 66)))
