;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/read.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 22 16:17:03 1992                          */
;*    Last change :  Fri Jan  8 09:37:46 1993  (serrano)               */
;*                                                                     */
;*    Un essai de reader                                               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-read)))

;*---------------------------------------------------------------------*/
;*    read-test ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-test port)
   (let ((npair   0)
	 (nint    0)
	 (nstring 0)
	 (nvector 0)
	 (nchar   0)
	 (nsymbol 0))
      (let loop ((sexp   (read port))
		 (n      0))
	 (if (eof-object? sexp)
	     (list nsymbol nchar nvector nstring nint npair n)
	     (begin
		(cond
		   ((pair? sexp)
		    (set! npair (+ 1 npair)))
		   ((integer? sexp)
		    (set! nint (+ 1 nint)))
		   ((string? sexp)
		    (set! nstring (+ 1 nstring)))
		   ((vector? sexp)
		    (set! nvector (+ 1 nvector)))
		   ((char? sexp)
		    (set! nchar (+ 1 nchar)))
		   (else
		    (set! nsymbol (+ 1 nsymbol))))
		(loop (read port)
		      (+ 1 n)))))))
   
;*---------------------------------------------------------------------*/
;*    test-read ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-read)
   (test-module "read" "read.scm" #f)
   (test "test" (call-with-input-file "misc/input.txt" read-test)
	 '(16 2 2 5 2 7 34))
   (test "read" (cdr '((foo . bar) . hux)) 'hux))
		   
