;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/match.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 10 16:37:46 1992                          */
;*    Last change :  Wed Jun 23 15:57:07 1993  (serrano)               */
;*                                                                     */
;*    Un essai de match-case                                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module match
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-match)))

;*---------------------------------------------------------------------*/
;*    match-test ...                                                   */
;*---------------------------------------------------------------------*/
(define (match-test)
   (let ((l '(let ((x 6))
		(+ x 5))))
      (match-case l
	 ((let ?bindings . ?body)
	  'ok)
	 (else
	  (print 'error)))))

;*---------------------------------------------------------------------*/
;*    match-test-2 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-2 x)
   (match-case x
      ;; 1- on definit une lambda typee
      ((?- ((?type ?name) . ?args) . ?body)
       'do-define-lambda)
      ;; 1- on definit une lambda non typee
      ((or (?- (?name . ?args) . ?body)
	   (?- ?name (lambda ?args . ?body)))
       'do-define-lambda)
      ;; 2- on definit une valeur non typee
      ((?- ?name . (?value . ()))
       'do-define-value)
      ;; 2b- on definit une valeur typee
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    match-test-3 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-3 x)
   (match-case x
      ((foo bar)
       x))
   #t)

;*---------------------------------------------------------------------*/
;*    match-test-4 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-4 x)
   (match-case x
      (((and ?let-part (let ?- ?body)) . ?args)
       'let)
      (((and ?x (labels ?- ?body)) . ?args)
       'app)
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    match-test-5 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-5 x)
   (match-case x
      ((atom ?-)
       'atom)
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    test-match ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-match)
   (test-module "match" "match.scm" #f)
   (test "let" (match-test) 'ok)
   (test "expand-define" (match-test-2 '(define (foo x) x)) 'do-define-lambda)
   (test "expand-define" (match-test-2 '(define foo (lambda (x) x)))
	 'do-define-lambda)
   (test "expand-define" (match-test-2 '(define foo 3))
	 'do-define-value)
   (test "expand-define" (match-test-2 '(define foo))
	 'else)
   (test "expand" (match-test-3 8) #t)
   (test "match-test-4" (match-test-4 '((labels ((gee (x) x)) gee) 1)) 'app)
   (test "atom" (match-test-5 '#(1 2 3)) 'else))
	
