;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/eval.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 14:42:03 1992                          */
;*    Last change :  Fri Jul  2 14:23:42 1993  (serrano)               */
;*                                                                     */
;*    On fait des tests pour tester eval.                              */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module eval
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-eval)))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define *g* 4)
(define (foo)
   *g*)

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define *f* 6)
(define (bar)
   (set! *f* 7))

;*---------------------------------------------------------------------*/
;*    test-eval ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-eval)
   (test-module "eval" "eval.scm" #t)
   (test "eval" (eval '1) 1)
   (test "eval" (eval 'car) car)
   (test "eval" (eval '(car '(1 2))) 1)
   (test "eval" (eval '((lambda (x) (+ 1 x)) 4)) 5)
   (test "eval" ((eval '(lambda (x) (+ 1 x))) 4) 5)
   (test "eval" (apply (eval '(lambda (x) (+ 1 x)))
		       '(4))
	 5)
   (test "eval" (let ((foo (lambda (x) (+ 1 x))))
		   (eval `(,foo 4)))
	 5)
   (test "eval" (eval '(apply (lambda (x) (+ 1 x)) '(4)))
	 5)
   (test "eval" (let ((foo (lambda (x) (+ 1 x))))
		   (eval `(apply ,foo '(4))))
	 5)
   (test "fib" (eval '(letrec ((fib (lambda (x)
				       (if (<fx x 2)
					   1
					   (+fx (fib (-fx x 1))
						(fib (-fx x 2)))))))
			 (fib 20)))
	 10946)
   (test "args" ((eval '(lambda (a b c d e f g h)
			   (+ a b c d e f g h)))
		 1 2 3 4 5 6 7 8)
	 
	 36)
   (test "args" ((eval '(lambda (a b c d e f g . h)
			   (+ a b c d e f g (apply + h))))
		 1 2 3 4 5 6 7 8 9)
	 45)
   (test "args" (let ((foo (lambda (a b c d e f g h)
			      (+ a b c d e f g h))))
		   (eval `(,foo 1 2 3 4 5 6 7 8)))
	 36)
   (test "args" (let ((foo (lambda (a b c d e f g . h)
			      (+ a b c d e f g (apply + h)))))
		   (eval `(,foo 1 2 3 4 5 6 7 8 9)))
	 45)
   (test "set!" (begin (eval '(set! *g* #t)) (foo)) #t)
   (test "set!" (eval '(begin (bar) *f*)) 7)
   (test "variable" (eval '(procedure? read)) #t)
   (test "-4 args" (eval '(let ((foo  (lambda  (a b c . d) d)))
			    (foo 1 2 3 4)))
	 '(4))
   (test "4 args" (eval '(let ((foo  (lambda  (a b c d) (+ a b c d))))
			    (foo 1 2 3 4)))
	 10)
   (test "5 args" (eval '(let ((foo (lambda (a b c d e) (+ a b c d e))))
			    (foo 1 2 3 4 5)))
	 15))
   
			       

