;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/define.scm ...               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan  7 16:20:22 1993                          */
;*    Last change :  Sat Jan  9 20:02:31 1993  (serrano)               */
;*                                                                     */
;*    On test les `define's internes                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module define
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-define)))

;*---------------------------------------------------------------------*/
;*    test-define ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-define)
   (test-module "define" "define.scm" #f)
   (test "internal" (test1 1) 1)
   (test "internal" (test3 1) 1)
   (test "internal" (test4 1) 1)
   (test "internal" (test5 (lambda (x)
			      (define (bar x)
				 (define (hux x)
				    x)
				 (hux x))
			      (bar x))) 1)
   (test "internal" (test5 (lambda (x)
			      (define (bar x)
				 x)
			      (bar x))) 1))

;*---------------------------------------------------------------------*/
;*    Une forme top-level                                              */
;*---------------------------------------------------------------------*/
(lambda (x)
   (define (bar x)
      x)
   (bar x))
 
(lambda (x)
   (define (bar x)
      (define (hux x)
	 x)
      (hux x))
   (bar x))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define test1
   (lambda (x)
      (define (bar x)
	 x)
      (bar x)))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3 x)
   (define (bar x)
      x)
   (bar x))

;*---------------------------------------------------------------------*/
;*    test4 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test4 x)
   (define (bar x)
      (define (hux x)
	 x)
      (hux x))
   (bar x))

;*---------------------------------------------------------------------*/
;*    test5 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test5 f)
   (f 1))
