;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../cell.scm ...                                                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 29 17:16:25 1992                          */
;*    Last change :  Mon Nov  2 16:32:11 1992  (serrano)               */
;*                                                                     */
;*    Un essai de fonction qui kapture des variables qui doivent       */
;*    etre placees dans des variables d'indirection.                   */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    le module                                                        */
;*---------------------------------------------------------------------*/
(module glo_cell
   (import main)
   (static (test1 (lambda (a b)))
	   (test2 (lambda (a b . c)))
	   (test3 (lambda c)))
   (export (glo_cell (lambda ()))))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 a b)
   (labels ((foo (x) (set! x b) x))
      foo))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 a b . c)
   (labels ((foo (x y) (set! c y) y)
	    (bar (z)   (foo 2 1))
	    (hux (t)   (set! a (foo t t)) c))
      hux))

;*---------------------------------------------------------------------*/
;*    test3                                                            */
;*---------------------------------------------------------------------*/
(define (test3 . c)
   (let ((a 0)
	 (b 0))
      (labels ((foo (x) (set! a x) a)
	       (bar (y) (set! b y) (foo b)))
	 (bar 1)
	 foo)))
      
;*---------------------------------------------------------------------*/
;*    glo_cell ...                                                     */
;*---------------------------------------------------------------------*/
(define (glo_cell)
   (start-testing "glo_cell" "Globalisation/cell.scm")
   (test "cell"
	 (lambda () ((test1 1 2) 3))
	 (lambda (res) (eq? res 2)))
   (test "cell"
	 (lambda () ((test2 1 2 3 4) 2))
	 (lambda (res) (eq? res 2)))
   (test "cell"
	 (lambda () ((test3 1 2 3 4) 2))
	 (lambda (res) (eq? res 2))))
   
