;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/lib/scheme-files/trace.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 21 14:56:30 1993                          */
;*    Last change :  Sat Feb 27 12:50:39 1993  (serrano)               */
;*                                                                     */
;*    On implemente un petit traceur pour l'interprete.                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    *traced-function* ...                                            */
;*---------------------------------------------------------------------*/
(define *traced-function* '())

;*---------------------------------------------------------------------*/
;*    *counter* ...                                                    */
;*---------------------------------------------------------------------*/
(define *counter* 0)

;*---------------------------------------------------------------------*/
;*    trace  ...                                                       */
;*---------------------------------------------------------------------*/
(define-macro (trace procedure)
   (if (not (symbol? procedure))
       (error "trace" "Not a function name" procedure)
       (let ((name (gensym "procedure"))
	     (proc (eval procedure)))
	  (cond
	     ((procedure? proc)
	      (if (assq procedure *traced-function*)
		  (print "*** WARNING:bigloo:trace" #\Newline
			 "procedure already traced -- " procedure)
		  (begin
		     (set! *traced-function* (cons (cons procedure name)
						   *traced-function*))
		     (expand-trace-procedure proc
					     name
					     procedure))))
	     (else
	      (error "trace" "Not a procedure" procedure))))))

;*---------------------------------------------------------------------*/
;*    untrace ...                                                      */
;*---------------------------------------------------------------------*/
(define-macro (untrace procedure)
   (if (not (symbol? procedure))
       (error "untrace" "Not a function name" procedure)
       (let ((proc (eval procedure)))
	  (cond
	     ((procedure? proc)
	      (let ((cell (assq procedure *traced-function*)))
		 (if (not (pair? cell))
		     (print "*** WARNING:bigloo:untrace" #\Newline
			    "procedure not currently traced -- " procedure)
		     (begin
			(set! *traced-function* (remq! cell *traced-function*))
			(expand-untrace-procedure procedure (cdr cell))))))
	     (else
	      (error "untrace" "Not a procedure" procedure)))))))

;*---------------------------------------------------------------------*/
;*    display-entry ...                                                */
;*---------------------------------------------------------------------*/
(define (display-entry counter num name args)
   (display-arrow ">" counter)
   (display* " " name "." num " : " )
   (let loop ((args args))
      (cond
	 ((null? args)
	  (newline))
	 ((not (pair? args))
	  (print args))
	 ((null? (car args))
	  (print (car args)))
	 (else
	  (display* (car args) #\space)
	  (loop (cdr args))))))

;*---------------------------------------------------------------------*/
;*    display-return ...                                               */
;*---------------------------------------------------------------------*/
(define (display-return counter num name res)
   (display-arrow "<" counter)
   (display* " " name "." num " : " res)
   (newline))

;*---------------------------------------------------------------------*/
;*    display-arrow ...                                                */
;*---------------------------------------------------------------------*/
(define (display-arrow cursor counter)
   (let loop ((counter counter))
      (if (=fx counter 0)
	  (display cursor)
	  (begin
	     (write-char #\-)
	     (loop (-fx counter 1))))))

;*---------------------------------------------------------------------*/
;*    expand-trace-procedure ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-trace-procedure proc name procedure)
   (let* ((args  (make-args-list proc))
	  (aargs (make-pair-from-args args)))
      `(begin
	  (define ,name ,procedure)
	  (define ,procedure
	     (let ((num -1))
		(lambda ,args
		   (set! num (+fx num 1))
		   (set! *counter* (+fx 1 *counter*))
		   (display-entry *counter*
				  num
				  ',procedure
				  (list ,@aargs))
		   (let ((res ,(if (< (closure-arity proc) 0)
				   `(apply ,name ,@aargs)
				   `(,name ,@aargs))))
		      (display-return *counter* num ',procedure res)
		      (set! *counter* (-fx *counter* 1))
		      (set! num (-fx num 1))
		      res)))))))

;*---------------------------------------------------------------------*/
;*    make-pair-from-args ...                                          */
;*---------------------------------------------------------------------*/
(define (make-pair-from-args args)
   (cond
      ((null? args)
       '())
      ((not (pair? args))
       (list args))
      (else
       (cons (car args) (make-pair-from-args (cdr args))))))

;*---------------------------------------------------------------------*/
;*    make-args-list ...                                               */
;*---------------------------------------------------------------------*/
(define (make-args-list proc)
   (let ((arity (closure-arity proc)))
      (if (<fx arity 0)
	  (make-va-args-list arity)
	  (make-fx-args-list arity '()))))

;*---------------------------------------------------------------------*/
;*    make-va-args-list ...                                            */
;*---------------------------------------------------------------------*/
(define (make-va-args-list arity)
   (if (=fx arity -1)
       (gensym)
       (cons (gensym) (make-va-args-list (+fx 1 arity)))))

;*---------------------------------------------------------------------*/
;*    make-fx-args-list ...                                            */
;*---------------------------------------------------------------------*/
(define (make-fx-args-list arity args)
   (if (=fx arity 0)
       args
       (make-fx-args-list (-fx arity 1) (cons (gensym) args))))

;*---------------------------------------------------------------------*/
;*    expand-untrace-procedure ...                                     */
;*---------------------------------------------------------------------*/
(define (expand-untrace-procedure name proc)
   `(define ,name ,proc))

