;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expanded.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 18 14:25:54 1992                          */
;*    Last change :  Thu Mar 25 17:02:42 1993  (serrano)               */
;*                                                                     */
;*    On ecrit du scheme expanse                                       */
;*---------------------------------------------------------------------*/
  
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module write_expanded
   (include "Var/variable.sch")
   (import  var_env
	    var_variable
	    engine_param
	    write_scheme
	    tools_args
	    tools_shape
	    tools_file
	    tools_hash)
   (export  (write-expanded expanded)))

;*---------------------------------------------------------------------*/
;*    write-expanded ...                                                */
;*---------------------------------------------------------------------*/
(define (write-expanded expanded)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (string? *src*)
			       (string-append (remove-extansion *src*) ".escm")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-expanded" "Can't open file" output-name)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (close-output-port port)
			    (exit -4))))
	     (try (begin
		     (write-scheme-file-header
		      port "Le fichier scheme macro expanse")
		     (for-each (lambda (code)
				  (match-case code
				     ((define (?name . ?args) ?value)
				      (write `(define ,(cons name args)
						 ,value) port))
				     ((define ?name ?value)
				      (write `(define ,name ,value) port))
				     ((define-inline (?name . ?args) ?value)
				      (write `(define-inline
						 ,(cons name args)
						 ,value) port))
				     (else
				      (write code port))))
			       expanded))
		  handler)))))
