;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Var/variable.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 13:23:31 1993                          */
;*    Last change :  Thu Apr  1 09:05:35 1993  (serrano)               */
;*                                                                     */
;*    Quelques fonctions de trippotage des `variable's                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module var_variable
   (include "Var/variable.sch")
   (import  tools_shape
	    engine_param)
   (export  (global-create id)
	    (global-shape  id)
	    (global-pp     port global)
	    (local-pp      port local marge)
	    (local-shape   id)))

;*---------------------------------------------------------------------*/
;*    global-create ...                                                */
;*    -------------------------------------------------------------    */
;*    On cree une structure global en remplissant le champs `id'       */
;*---------------------------------------------------------------------*/
(define (global-create id)
   (let ((new (make-global)))
      (global-name-set! new id)
      new))

;*---------------------------------------------------------------------*/
;*    global-shape ...                                                 */
;*---------------------------------------------------------------------*/
(define (global-shape global)
   (if (global? global)
       (let ((name (cond
		      ((eq? (global-class global) 'foreign)
		       (string-append "_"
				      (symbol->string (global-name global))))
		      (*alpha*
		       (string-append (symbol->string (global-name global))
				      *separateur*
				      (symbol->string (global-module global))))
		      ((symbol? (global-name global))
		       (symbol->string (global-name global)))
		      (else
		       (global-name global)))))
	  (if *error-shape*
	      (string->symbol (string-append "^" name "^"))
	      (string->symbol name)))
       (error "global-shape" "Not a global" (shape global))))

;*---------------------------------------------------------------------*/
;*    global-pp ...                                                    */
;*    -------------------------------------------------------------    */
;*    On pretty-print une structure `global'                           */
;*---------------------------------------------------------------------*/
(define (global-pp port global)
   (if (not (global? global))
       (error "global-pp" "Not a global" (shape global))
       (begin
	  (fprint port (global-name global) ":")
	  (fprint port (make-string (string-length
				     (symbol->string (global-name global)))
				    #\~))
	  (fprint port "   module      : " (global-module global))
	  (fprint port "   c-name      : " (global-c-name global))
	  (fprint port "   shape       : " (global-shape global))
	  (fprint port "   import      : " (global-import global))
	  (fprint port "   class       : " (global-class global))
	  (fprint port "   library?    : " (global-library? global))
	  (fprint port "   pragma      : " (global-pragma global))
	  (if (or (eq? *pp-env-mode* 'long)
		  (eq? *pp-env-mode* 'extra-long))
	      (case (global-class global)
		 ((function)
		  (function-pp port (global-value global) 3))
		 ((foreign)
		  (foreign-pp port (global-value global) 3)))))))

;*---------------------------------------------------------------------*/
;*    local-pp ...                                                     */
;*---------------------------------------------------------------------*/
(define (local-pp port local marge)
   (if (not (local? local))
       (error "local-pp" "Not a local" (shape local))
       (let ((marge (make-string marge #\space)))
	  (fprint port marge (local-name local) ":")
	  (fprint port marge (make-string
			      (string-length
			       (symbol->string (local-name local)))
			      #\-))
	  (fprint port marge "   key      : " (local-key local))
	  (fprint port marge "   class    : " (local-class local))
	  (fprint port marge "   access   : " (local-access local))
	  (if (or (eq? *pp-env-mode* 'long)
		  (eq? *pp-env-mode* 'extra-long))
	      (case (local-class local)
		 ((function)
		  (function-pp port (local-value local) 3))
		 ((return)
		  (return-pp port (local-value local) 3)))))))

;*---------------------------------------------------------------------*/
;*       local-shape ...                                               */
;*---------------------------------------------------------------------*/
(define (local-shape local)
   (if (local? local)
       (let ((name (if *alpha*
		       (string-append (symbol->string (local-name local))
				      *separateur*
				      (integer->string (local-key local)))
		       (symbol->string (local-name local)))))
	  (if *error-shape*
	      (string->symbol (string-append "<" name ">"))
	      (string->symbol name)))
       (error "local-shape" "Not a local" (shape local))))

;*---------------------------------------------------------------------*/
;*    function-pp ...                                                  */
;*---------------------------------------------------------------------*/
(define (function-pp port fun marge)
   (let ((marge (make-string marge #\space)))
      (fprint port marge "inline?     : " (function-inline? fun))
      (fprint port marge "arity       : " (function-arity fun))
      (if (eq? *pp-env-mode* 'extra-long)
	  (begin
	     (fprint port marge "args        : " (shape (function-args fun)))
	     (fprint port marge "body        : " (shape
						  (function-body fun)))
	     (fprint port marge "escape?     : " (function-escape? fun))))))
   
;*---------------------------------------------------------------------*/
;*    foreign-pp ...                                                   */
;*---------------------------------------------------------------------*/
(define (foreign-pp port for marge)
    (let ((marge (make-string marge #\space)))
      (fprint port marge "class       : " (foreign-class for))
      (fprint port marge "type        : " (foreign-type for))))
  
;*---------------------------------------------------------------------*/
;*    return-pp ...                                                    */
;*---------------------------------------------------------------------*/
(define (return-pp port ret marge)
   (let ((marge (make-string marge #\space)))
      (if (eq? *pp-env-mode* 'extra-long)
	  (begin
	     (fprint port marge "escape?     : " (return-escape? ret))))))
      
