;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Var/pragma.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 28 11:31:19 1993                          */
;*    Last change :  Thu Apr 29 14:48:05 1993  (serrano)               */
;*                                                                     */
;*    La gestion des pragma des variables globales                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module var_pragma
   (include "Var/variable.sch")
   (import  tools_error
	    var_env)
   (export  (put-pragma! list)
	    (pragma-no-side-effect? global)
	    (pragma-no-mutation?    global)
	    (pragma-imutable?       global)
	    (pragma-imbricable?     global)))

;*---------------------------------------------------------------------*/
;*    put-pragma! ...                                                  */
;*---------------------------------------------------------------------*/
(define (put-pragma! pragma-list)
   (let loop ((l pragma-list))
      (if (null? l)
	  'done
	  (let* ((pragma (car l))
		 (fun    (car pragma))
		 (prop   (cdr pragma)))
	     (let ((global (find-in-global-environment fun *Genv*)))
		(if (not (global? global))
		    (error "put-pragma!"
			   "Unbound variable" fun)
		    (begin
		       (global-pragma-set! global prop)
		       (loop (cdr l)))))))))

;*---------------------------------------------------------------------*/
;*    pragma-no-side-effect? ...                                       */
;*---------------------------------------------------------------------*/
(define (pragma-no-side-effect? global)
   (pair? (memq '_no_side_effect_ (global-pragma global))))
       
;*---------------------------------------------------------------------*/
;*    pragma-no-mutation? ...                                          */
;*---------------------------------------------------------------------*/
(define (pragma-no-mutation? global)
   (pair? (memq '_no_mutation_ (global-pragma global))))
       
;*---------------------------------------------------------------------*/
;*    pragma-imutable? ...                                             */
;*---------------------------------------------------------------------*/
(define (pragma-imutable? global)
   (pair? (memq '_imutable_ (global-pragma global))))
       
;*---------------------------------------------------------------------*/
;*    pragma-imbricable? ...                                           */
;*    -------------------------------------------------------------    */
;*    Peut-on imbrique une appel a une fonction dans un autre ?        */
;*---------------------------------------------------------------------*/
(define (pragma-imbricable? global)
   (pair? (memq '_imbricable_ (global-pragma global))))

