;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Var/declare.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 16:09:31 1993                          */
;*    Last change :  Tue May 11 15:11:39 1993  (serrano)               */
;*                                                                     */
;*    Le module ou on declare les variables globales                   */
;*    -------------------------------------------------------------    */
;*    Il y a deux temps lors de la creation des variables:             */
;*       1- La creation.                                               */
;*       2- Le remplissage.                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module var_declare
   (include "Var/variable.sch"
	    "Expand/expander.sch")
   (import  var_env
	    type_name
	    tools_speek
	    tools_args
	    tools_shape
	    engine_param)
   (export  (declare-global-inline! name args module import)
	    (declare-global-procedure! name args module import)
	    (declare-global-variable! name module import)
	    (declare-global-foreign-function! l c type args-type class)
	    (declare-global-foreign-variable! l c type class)
	    (make-global-function class args)
	    (remove-from-remember-list! name)
	    (get-remember-list)
	    (add-to-remember-list! name)))

;*---------------------------------------------------------------------*/
;*    declare-global-inline! ...                                       */
;*---------------------------------------------------------------------*/
(define (declare-global-inline! name args module import)
   (let ((sname (if (string? name)
		    (string->symbol name)
		    name)))
      (define (fill! global)
	 (if (eq? module *module-name*)
	     (add-to-remember-list! sname))
	 (if (string? name)
	     (global-c-name-set! global name))
	 (global-module-set!     global module)
	 (global-import-set!     global import)
	 (global-class-set!      global 'function)
	 (global-value-set!      global (make-global-function 'inline args))
	 global)
      (let ((old   (find-in-global-environment sname *Genv*))
	    (O-exp (find-in-global-environment sname *Oenv*)))
	 (if (and (expander? O-exp)
		  (or (eq? import 'static)
		      (eq? import 'export)))
	     (begin
		(unbind-in-global-environment! sname *Oenv*)
		(if (not *lib-mode*)
		    (warning "top-level"
			     "Redefinition of library function -- " name))))
	 (if (and (global? old)
		  (or (null? (global-library? old))
		      (not *lib-mode*)))
	     (begin
		(warning "top-level"
			 "Redefinition of variable -- " name)
		(fill! old))
	     (fill! (bind-in-global-environment! sname *Genv*))))))

;*---------------------------------------------------------------------*/
;*    declare-global-procedure! ...                                    */
;*---------------------------------------------------------------------*/
(define (declare-global-procedure! name args module import)
   (let ((sname (if (string? name)
		    (string->symbol name)
		    name)))
      (define (fill! global)
	 (if (eq? module *module-name*)
	     (add-to-remember-list! sname))
	 (if (string? name)
	     (global-c-name-set! global name))
	 (global-module-set!     global module)
	 (global-import-set!     global import)
	 (global-class-set!      global 'function)
	 (global-value-set! global (make-global-function 'normal args))
	 global)
      (let ((old (find-in-global-environment sname *Genv*))
	    (O-exp (find-in-global-environment sname *Oenv*)))
	 (if (and (expander? O-exp)
		  (or (eq? import 'static)
		      (eq? import 'export)))
	     (begin
		(unbind-in-global-environment! sname *Oenv*)
		(if (not *lib-mode*)
		    (warning "top-level"
			     "Redefinition of library function -- " name))))
	 (if (and (global? old)
		  (or (null? (global-library? old))
		      (not *lib-mode*)))
	     (begin
		(if (eq? (global-module old) module)
		    (error "declare-global-variable!"
			   "Redefinition of variable"
			   (shape old))
		    (warning "top-level"
			     "Redefinition of variable -- " name))
		(fill! old))
	     (fill! (bind-in-global-environment! sname *Genv*))))))

;*---------------------------------------------------------------------*/
;*    declare-global-variable! ...                                     */
;*---------------------------------------------------------------------*/
(define (declare-global-variable! name module import)
    (let ((sname (if (string? name)
		    (string->symbol name)
		    name)))
       (define (fill! global)
	  (if (eq? module *module-name*)
	     (add-to-remember-list! sname))
	  (if (string? name)
	      (global-c-name-set! global name))
	  (global-module-set!     global module)
	  (global-import-set!     global import)
	  (global-class-set!      global 'variable)
	  global)
       (let ((old (find-in-global-environment sname *Genv*))
	     (O-exp (find-in-global-environment sname *Oenv*)))
	 (if (and (expander? O-exp)
		  (or (eq? import 'static)
		      (eq? import 'export)))
	     (begin
		(unbind-in-global-environment! sname *Oenv*)
		(if (not *lib-mode*)
		    (warning "top-level"
			     "Redefinition of library function -- " name))))
	  (if (and (global? old)
		  (or (null? (global-library? old))
		      (not *lib-mode*)))
	      (begin
		 (if (eq? (global-module old) module)
		    (error "declare-global-variable!"
			   "Redefinition of variable"
			   (shape old))
		    (warning "top-level"
			     "Redefinition of variable -- " name))
		 (fill! old))
	      (fill! (bind-in-global-environment! sname *Genv*))))))

;*---------------------------------------------------------------------*/
;*    declare-global-foreign-function! ...                             */
;*---------------------------------------------------------------------*/
(define (declare-global-foreign-function! name c-name type args-type class)
   (define (fill! global)
      (global-c-name-set!  global c-name)
      (global-module-set!  global 'foreign)
      (global-import-set!  global 'foreign)
      (global-class-set!   global 'foreign)
      (global-value-set!   global (make-global-foreign
				   class
				   `(-> ,type ,@args-type)))
      global)
   (let ((old (find-in-global-environment name *Genv*)))
      (if (and (global? old)
	       (or (null? (global-library? old))
		   (not *lib-mode*)))
	  (begin
	     (warning "top-level"
		      "Redefinition of variable -- " name)
	     (fill! old))
	  (fill! (bind-in-global-environment! name *Genv*)))))
   
;*---------------------------------------------------------------------*/
;*    declare-global-foreign-variable! ...                             */
;*---------------------------------------------------------------------*/
(define (declare-global-foreign-variable! name c-name type class)
   (define (fill! global)
      (global-c-name-set!  global c-name)
      (global-module-set!  global 'foreign)
      (global-import-set!  global 'foreign)
      (global-class-set!   global 'foreign)
      (global-value-set!   global (make-global-foreign
				   class
				   type))
      global)
   (let ((old (find-in-global-environment name *Genv*)))
      (if (and (global? old)
	       (or (null? (global-library? old))
		   (not *lib-mode*)))
	  (begin
	     (warning "top-level"
		      "Redefinition of variable -- " name)
	     (fill! old))
	  (fill! (bind-in-global-environment! name *Genv*)))))
   
;*---------------------------------------------------------------------*/
;*    make-global-function ...                                         */
;*---------------------------------------------------------------------*/
(define (make-global-function class args)
   (let ((new (make-function)))
      (if (eq? class 'inline)
	  (function-inline?-set! new #t))
      (function-arity-set!       new (arity args))
      new))

;*---------------------------------------------------------------------*/
;*    make-global-foreign ...                                          */
;*---------------------------------------------------------------------*/
(define (make-global-foreign class type)
   (let ((new (make-foreign)))
      (foreign-class-set! new class)
      (foreign-type-set!  new type)
      new))

;*---------------------------------------------------------------------*/
;*    *remember-global-list* ...                                       */
;*    -------------------------------------------------------------    */
;*    La listes des fonctions dont on doit trouver une definition.     */
;*---------------------------------------------------------------------*/
(define *remember-global-list* '())

;*---------------------------------------------------------------------*/
;*    add-to-remember-list! ...                                        */
;*---------------------------------------------------------------------*/
(define (add-to-remember-list! name)
   (set! *remember-global-list* (cons name *remember-global-list*)))

;*---------------------------------------------------------------------*/
;*    remove-from-remember-list! ...                                   */
;*---------------------------------------------------------------------*/
(define (remove-from-remember-list! name)
   (set! *remember-global-list* (remq! name *remember-global-list*)))

;*---------------------------------------------------------------------*/
;*    get-remember-list  ...                                           */
;*---------------------------------------------------------------------*/
(define (get-remember-list)
   *remember-global-list*)

