;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Type/walk.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 24 17:00:13 1993                          */
;*    Last change :  Mon Jun 21 10:36:42 1993  (serrano)               */
;*                                                                     */
;*    On pose les tests de type et les fonctions de casting            */
;*    -------------------------------------------------------------    */
;*    Les tests de type n'interviennent que lors de l'appel a des      */
;*    fonctions etrangeres. Ce n'est que la qu'on peut avoir a tester  */
;*    le type d'un objet.                                              */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    type_expression)
   (export  (type-walk tree)))

;*---------------------------------------------------------------------*/
;*    type-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (type-walk tree)
    (verbose "   . Type" #\Newline)
    (start-partial-error "Type")
    (let loop ((walk tree))
       (if (null? walk)
	   (begin
	      (fail-if-partial-error)
	      tree)
	   (let* ((var   (car walk))
		  (value (global-value var))
		  (body  (function-body value)))
	      (enter-function (shape var))
	      (find-escape-variable! body)
	      (function-body-set! value (type-expression body 'bobj))
	      (leave-function)
	      (loop (cdr walk))))))

;*---------------------------------------------------------------------*/
;*    find-escape-variable! ...                                        */
;*---------------------------------------------------------------------*/
(define (find-escape-variable! exp)
   (let loop ((exp exp))
      (cond
	 ((null? exp)
	  'done)
	 ((not (pair? exp))
	  (cond
	     ((local? exp)
	      (cond
		 ((eq? (local-class exp) 'return)
		  (return-escape?-set! (local-value exp) #t))
		 ((eq? (local-class exp) 'function)
		  (function-escape?-set! (local-value exp) #t))))
	      ((global? exp)
	       (if (eq? (global-class exp) 'function)
		   (function-escape?-set! (global-value exp) #t)))))
	 ((eq? (car exp) 'quote)
	  'done)
	 ((eq? (car exp) 'apply)
	  (if (not (pair? (cadr exp)))
	      (loop (cddr exp))
	      (loop (cdr exp))))
	 (else
	  (let liip ((exp (if (pair? (car exp))
			      exp
			      (cdr exp))))
	     (if (null? exp)
		 'done
		 (begin
		    (loop (car exp))
		    (liip (cdr exp)))))))))
