;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Type/type.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 08:31:09 1993                          */
;*    Last change :  Fri May 14 17:36:30 1993  (serrano)               */
;*                                                                     */
;*    On retourne le type d'une expression                             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_type
   (include "Var/variable.sch")
   (import  tools_error
	    tools_shape)
   (export  (type-of exp)))

;*---------------------------------------------------------------------*/
;*    type-of ...                                                      */
;*---------------------------------------------------------------------*/
(define (type-of exp)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       (cond
	  ((global? atom)
	   (case (global-class atom)
	      ((function)
	       'bprocedure)
	      ((foreign)
	       (case (foreign-class (global-value atom))
		  ((function)
		   'cfunction)
		  ((macro-function)
		   'cvoid)
		  (else
		   (foreign-type (global-value atom)))))
	      (else
	       'bobj)))
	  ((local? atom)
	   (case (local-class atom)
	      ((function)
	       'bprocedure)
	      ((return)
	       'breturn)
	      (else
	       'bobj)))
	  ((integer? atom)
	   'cint)
	  ((real? atom)
	   'cdouble)
	  ((string? atom)
	   'cstring)
	  ((symbol? atom)
	   'csymbol)
	  ((char? atom)
	   'cchar)
	  ((boolean? atom)
	   'cbool)
	  (else
	   (partial-error "type-of" "Unknown atom type" (shape atom)))))
;*--- quote -----------------------------------------------------------*/
      ((quote ?exp)
       (cond
	  ((symbol? exp)
	   'bsymbol)
	  ((pair? exp)
	   'bpair)
	  ((vector? exp)
	   'bvector)
	  (else
	   'bobj)))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((body body))
	  (if (null? (cdr body))
	      (type-of (car body))
	      (loop (cdr body)))))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       'bobj)
;*--- let, letrec & labels --------------------------------------------*/
      (((or let letrec labels) ?- ?body)
       (if (not (pair? body))
	   (type-of body)
	   (let loop ((body body))
	      (if (null? (cdr body))
		  (type-of (car body))
		  (loop (cdr body))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       'bcameleon)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?-) ?body)
       (let loop ((body body))
	  (if (null? (cdr body))
	      (type-of (car body))
	      (loop (cdr body)))))
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       'bobj)
;*--- if --------------------------------------------------------------*/
      (((or cif if) ?si ?alors ?sinon)
       (type-unification (type-of alors) (type-of sinon)))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (let loop ((type (type-of (cadr (car clauses))))
		  (clauses (cdr clauses)))
	  (cond
	     ((null? clauses)
	      type)
	     ((eq? type 'bobj)
	      type)
	     (else
	      (loop (type-unification (type-of (cadr (car clauses))) type)
		    (cdr clauses))))))
;*--- function --------------------------------------------------------*/
      ((function . ?-)
       'bprocedure)
;*--- apply & funcall -------------------------------------------------*/
      (((or apply funcall) . ?-)
       'bobj)
;*--- atom-application ------------------------------------------------*/
      (((atom ?function) . ?args)
       (cond
	  ((global? function)
	   (if (eq? (global-class function) 'foreign)
	       (if (not (pair? (foreign-type (global-value function))))
		   (partial-error ""
				  "Illegal foreign application"
				  (shape exp))
		   (cadr (foreign-type (global-value function))))
	       'bobj))
	  ((local? function)
	   'bobj)
	  (else
	   (partial-error "" "Illegal application" (shape exp)))))
;*--- application -----------------------------------------------------*/
      (else
       (if (and (global? (car exp))
		(eq? (global-class (car exp)) 'foreign))
	   (case (foreign-class (global-value (car exp)))
	      ((function macro-function)
	       (cadr (foreign-type (car exp))))
	      (else
	       (partial-error "" "Illegal foreign application" (shape exp))))
	   'bobj))))
	  
;*---------------------------------------------------------------------*/
;*    type-unification ...                                             */
;*---------------------------------------------------------------------*/
(define (type-unification t1 t2)
   (cond
      ((eq? t1 t2)
       t1)
      ((eq? t1 'bcameleon)
       t2)
      ((eq? t2 'bcameleon)
       t1)
      (else
       'bobj)))
       
	   
	   
