;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Type/name.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 08:18:38 1993                          */
;*    Last change :  Wed Apr 28 09:03:42 1993  (serrano)               */
;*                                                                     */
;*    Les noms des types                                               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_name
   (import type_misc)
   (export (user-scheme-type->type    user-type)
	   (user-c-type->type         user-type)
	   (user-args-list->type-list args)
	   (bigloo-type->c-type       type)))

;*---------------------------------------------------------------------*/
;*    user-scheme-type->type ...                                       */
;*---------------------------------------------------------------------*/
(define (user-scheme-type->type user-type)
   (if (bigloo-type? user-type)
       user-type
       (case user-type
	  ((obj)
	   'bobj)
	  ((bbool bint breal bpair bstring bchar
		  bprocedure bsymbol bobj bvector bstruct
		  boutput-port binput-port bcameleon)
	   user-type)
	  (else
	   (error "user-scheme-name->type-name"
		  "Illegal type name"
		  user-type)))))
   
;*---------------------------------------------------------------------*/
;*    user-c-type->type ...                                            */
;*---------------------------------------------------------------------*/
(define (user-c-type->type user-type)
   (if (foreign-type? user-type)
       user-type
       (case user-type
	  ((bool int double char jmp_buf void function string)
	   (string->symbol (string-append "c" (symbol->string user-type))))
	  (else
	   (user-scheme-type->type user-type)))))

;*---------------------------------------------------------------------*/
;*    user-args-list->type-list ...                                    */
;*---------------------------------------------------------------------*/
(define (user-args-list->type-list args)
   (let loop ((args args)
	      (res  '()))
      (cond
	 ((null? args)
	  (reverse! res))
	 ((not (pair? args))
	  (reverse! (cons (user-scheme-type->type 'pair) res)))
	 (else
	  (if (pair? (car args))
	      (loop (cdr args)
		    (cons (user-scheme-type->type (car (car args)))
			  res))
	      (loop (cdr args)
		    (cons 'bobj
			  res)))))))
		    
;*---------------------------------------------------------------------*/
;*    bigloo-type->c-type ...                                          */
;*---------------------------------------------------------------------*/
(define (bigloo-type->c-type type)
   (if (bigloo-type? type)
       "obj_t"
       (case type
	  ((cbool)
	   "unsigned char")
	  ((cstring)
	   "char *")
	  ((cfunction)
	   "((obj_t (*)())())")
	  ((cjmp_buf)
	   "jmp_buf")
	  (else
	   (let ((s (symbol->string type)))
	      (string-downcase (substring s 1 (string-length s))))))))
	   
      
