;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Type/misc.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 19 13:19:01 1993                          */
;*    Last change :  Thu Apr  1 19:59:35 1993  (serrano)               */
;*                                                                     */
;*    Des operations diverses sur les types                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_misc
   (export (bigloo-type?     type)
	   (foreign-type?    type)
	   (type-compatible? t1 t2)))

;*---------------------------------------------------------------------*/
;*    bigloo-type? ...                                                 */
;*---------------------------------------------------------------------*/
(define (bigloo-type? type)
   (pair? (memq type '(bbool
		       bint
		       breal
		       bpair
		       bstring
		       bchar
		       bprocedure
		       breturn
		       bsymbol
		       bobj
		       bvector
		       bstruct
		       boutput-port
		       binput-port
		       bcameleon))))

;*---------------------------------------------------------------------*/
;*    foreign-type? ...                                                */
;*---------------------------------------------------------------------*/
(define (foreign-type? type)
   (pair? (memq type '(cbool
		       cint
		       cdouble
		       cchar
		       cprocedure
		       cjmp-buf
		       cstring))))

;*---------------------------------------------------------------------*/
;*    type-compatible? ...                                             */
;*---------------------------------------------------------------------*/
(define (type-compatible? t1 t2)
   (cond
      ((eq? t1 t2)
       #t)
      ((and (bigloo-type? t1)
	    (bigloo-type? t2))
       (or (eq? t1 'bobj) (eq? t2 'bobj)))
      (else
       #f)))
