;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expression.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 24 17:05:30 1993                          */
;*    Last change :  Thu Jun 10 15:05:05 1993  (serrano)               */
;*                                                                     */
;*    On type une expression                                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_expression
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tools_progn
	    type_application
	    type_apply
	    type_bind-exit
	    type_cast
	    type_type)
   (export  (type-expression expression to)))

;*---------------------------------------------------------------------*/
;*    type-expression ...                                              */
;*---------------------------------------------------------------------*/
(define (type-expression exp to)
   (trace type "type: " (shape exp) " [" to #\] #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (cast exp (type-of exp) to))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       (cast exp 'bobj to))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? (cdr hook))
	      (begin
		 (set-car! hook (type-expression (car hook) to))
		 exp)
	      (begin
		 (set-car! hook (type-expression (car hook) 'bobj))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (set-car! (cddr exp) (type-expression val (type-of var)))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (type-expression body to))
		 exp)
	      (begin
		 (set-car! (cdar hook)
			   (type-expression (cadr (car hook)) 'bobj))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (type-expression body to))
		 exp)
	      (begin
		 (set-car! (cddar hook)
			   (type-expression (caddr (car hook)) 'bobj))
		 (function-body-set! (local-value (car (car hook)))
				     (caddr (car hook)))
		 (loop (cdr hook))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (set-car! (cdr exp) (type-expression proc 'bobj))
       (set-car! (cddr exp) (type-expression msg 'bobj))
       (set-car! (cdddr exp) (type-expression obj 'bobj))
       exp)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit . ?-)
       (type-bind-exit exp to))
;*--- apply -----------------------------------------------------------*/
      ((apply . ?-)
       (type-apply exp to))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (type-expression test type))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook))
			   (type-expression (cadr (car hook)) to))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((if (if ?si #f #t) ?alors ?sinon)
       ;; ce cas correspond au `not'
       (set-car! exp 'cif)
       (set-car! (cdr exp) (type-expression si 'cbool))
       (set-car! (cdddr exp) (type-expression alors to))
       (set-car! (cddr exp) (type-expression sinon to))
       exp)
      ((if ?si ?alors ?sinon)
       (set-car! exp 'cif)
       (set-car! (cdr exp) (type-expression si 'cbool))
       (set-car! (cddr exp) (type-expression alors to))
       (set-car! (cdddr exp) (type-expression sinon to))
       exp)
;*--- atom-application ------------------------------------------------*/
      (((atom ?function) . ?args)
       (type-atom-application exp to))
;*--- application -----------------------------------------------------*/
      (else
       ;; les appels etrangers calcules ne sont pas permis. C'est donc
       ;; ici un appel bigloo.
       (type-unknown-bigloo-application exp to))))
