;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Type/enforce.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 10:50:33 1993                          */
;*    Last change :  Wed Jun 23 13:27:09 1993  (serrano)               */
;*                                                                     */
;*    On force les objects a avoir les bons types                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_enforce
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  engine_param
	    tools_error
	    tools_speek
	    tools_shape
	    heap_abstract
	    scan_lexical
	    type_type)
   (export  (enforce-procedure arity exp)
	    (enforce           type exp)))

;*---------------------------------------------------------------------*/
;*    enforce-procedure ...                                            */
;*---------------------------------------------------------------------*/
(define (enforce-procedure arity proc)
   (enforce-arity arity (enforce 'bprocedure proc) proc))

;*---------------------------------------------------------------------*/
;*    enforce-arity ...                                                */
;*---------------------------------------------------------------------*/
(define (enforce-arity arity procedure proc-name)
   (if *unsafe-arity*
       procedure
       (if (pair? procedure)
	   (let ((aux (get-type-aux-var proc-name)))
	      `(let ((,aux ,procedure))
		  ,(enforce-atom-arity arity aux)))
	   (enforce-atom-arity arity procedure))))

;*---------------------------------------------------------------------*/
;*    enforce-atom-arity ...                                           */
;*---------------------------------------------------------------------*/
(define (enforce-atom-arity arity procedure)
   (define (copy-list exp)
      (cond
	 ((pair? exp)
	  (map copy-list exp))
	 (else
	  exp)))
   `(cif ,(abstract-=fx (copy-list arity)
			(abstract-cint->bint
			 (abstract-procedure-arity procedure)))
	 ,procedure
	 (cif ,(abstract-va-procedure? procedure)
	      (cif ,(abstract-<=fx (abstract--fx (abstract-negfx
						  (copy-list arity))
						 (abstract-cint->bint 1))
				   (abstract-cint->bint
				    (abstract-procedure-arity procedure)))
		   ,procedure
		   (failure ,(list 'quote (current-function))
			    ,(abstract-cstring->bstring
			      "Wrong number of arguments for")
			    ,(list 'quote (shape procedure))))
	      (failure ,(list 'quote (current-function))
		       ,(abstract-cstring->bstring
			 "Wrong number of arguments for")
		       ,(list 'quote (shape procedure))))))

;*---------------------------------------------------------------------*/
;*    enforce ...                                                      */
;*    -------------------------------------------------------------    */
;*    On evite ici de placer des tests qui sont des tautologie. C'est  */
;*    a dire qu'avant de tester qu'une expression est un int, on       */
;*    verifie si on ne peut pas le deduire car c'est une expression    */
;*    du style `(c-cint->bint ...)'.                                   */
;*---------------------------------------------------------------------*/
(define (enforce type exp)
   (trace type "enforce: " (shape exp) " --> " type #\Newline)
   (if *unsafe-type*
       exp
       (case type
	  ((cbool)
	   (enforce-type 'cbool abstract-boolean? exp))
	  ((bbool)
	   (enforce-type 'bbool abstract-boolean? exp))
	  ((cint)
	   (enforce-type 'cint abstract-integer? exp))
	  ((bint)
	   (enforce-type 'bint abstract-integer? exp))
	  ((cstring)
	   (enforce-type 'cstring abstract-string? exp))
	  ((bstring)
	   (enforce-type 'bstring abstract-string? exp))
	  ((cchar)
	   (enforce-type 'cchar abstract-char? exp))
	  ((bchar)
	   (enforce-type 'bchar abstract-char? exp))
	  ((cdouble)
	   (enforce-type 'cdouble abstract-real? exp))
	  ((breal)
	   (enforce-type 'breal abstract-real? exp))
	  ((bpair)
	   (enforce-type 'bpair abstract-pair? exp))
	  ((bvector)
	   (enforce-type 'bvector abstract-vector? exp))
	  ((bsymbol)
	   (enforce-type 'bsymbol abstract-symbol? exp))
	  ((bprocedure)
	   (if (eq? (type-of exp) 'bprocedure)
	       exp
	       (check abstract-procedure? exp 'bprocedure)))
	  ((binput-port)
	   (if (eq? (type-of exp) 'binput-port)
	       exp
	       (check abstract-input-port? exp 'binput-port)))
	  ((boutput-port)
	   (if (eq? (type-of exp) 'boutput-port)
	       exp
	       (check abstract-output-port? exp 'boutput-port)))
	  ((bstruct)
	   (if (eq? (type-of exp) 'bstruct)
	       exp
	       (check abstract-struct? exp 'bstruct)))
	  ((bobj)
	   exp)
	  (else
	   (error "enforce" "Unknown type" type)))))
	   
;*---------------------------------------------------------------------*/
;*    enforce-type ...                                                 */
;*---------------------------------------------------------------------*/
(define (enforce-type type abstract exp)
   (let ((type-exp (type-of exp)))
      (cond
	 ((eq? type-exp 'bobj)
	  (check abstract exp type))
	 ((not (eq? type-exp type))
	  (warning (current-function)
		   "Illegal type for expression -- "
		   (shape exp) #\Newline
		   "type wanted `" type "', type provided `"
		   type-exp "'")
	  (check abstract exp type))
	 (else
	  exp))))

;*---------------------------------------------------------------------*/
;*    check ...                                                        */
;*---------------------------------------------------------------------*/
(define (check abstract exp type)
   (define (check-atom exp)
      `(cif ,(abstract exp)
	    ,exp
	    (failure ,(list 'quote (current-function))
		  ,(abstract-type-error (list 'quote type)
					(list 'quote (shape exp)))
		  ,exp)))
   (if (pair? exp)
       (let ((aux (get-type-aux-var exp)))
	  `(let ((,aux ,exp))
	      ,(check-atom aux)))
       (check-atom exp)))

;*---------------------------------------------------------------------*/
;*    get-type-aux-var ...                                             */
;*---------------------------------------------------------------------*/
(define (get-type-aux-var exp)
   (let ((type-aux-name (cond
			   ((global? exp)
			    (global-name exp))
			   ((local? exp)
			    (local-name exp))
			   (else
			    'type-aux))))
      (cdar (allocate-local-variables (list type-aux-name)))))
      
