;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Type/cast.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 08:19:55 1993                          */
;*    Last change :  Mon May 17 11:50:19 1993  (serrano)               */
;*                                                                     */
;*    Les fonctions de casting                                         */
;*    -------------------------------------------------------------    */
;*    Ce module se content de faire les conversion de type. Il ne      */
;*    se preocupe pas de verifier que les types sont correctes. Cette  */
;*    tache est faite ailleurs. Ici, on cast seulement.                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_cast
   (include "Tools/trace.sch")
   (import  heap_abstract
	    tools_speek
	    tools_error
	    tools_shape
	    type_misc
	    type_enforce)
   (export  (cast exp from to)))

;*---------------------------------------------------------------------*/
;*    cast ...                                                         */
;*---------------------------------------------------------------------*/
(define (cast exp from to)
   (trace type "cast: " from " -> " to " : " (shape exp) #\Newline)
   (cond
      ((eq? from to)
       exp)
      ((bigloo-type? from)
       (if (bigloo-type? to)
	   (cast-bigloo->bigloo exp from to)
	   (cast-bigloo->foreign exp from to)))
      (else
       (if (bigloo-type? to)
	   (cast-foreign->bigloo exp from to)
	   (cast-foreign->foreign exp from to)))))

;*---------------------------------------------------------------------*/
;*    cast-bigloo->bigloo ...                                          */
;*---------------------------------------------------------------------*/
(define (cast-bigloo->bigloo exp from to)
   (cond
      ((eq? from 'bprocedure)
       `(function ,exp))
      ((eq? from 'breturn)
       `(function ,exp))
      (else
       (enforce to exp))))

;*---------------------------------------------------------------------*/
;*    cast-bigloo->foreign ...                                         */
;*---------------------------------------------------------------------*/
(define (cast-bigloo->foreign exp from to)
   (let ((exp (cast-bigloo->bigloo exp from 'bobj)))
      ;; on commence d'abord par ce ramener a un `bobj'
      (case to
	 ((cfunction)
	  (partial-error "cast-bigloo->foreign" "Illegal cast" to)
	  exp)
	 ((cint)
	  (abstract-bint->cint (enforce 'bint exp)))
	 ((cstring)
	  (abstract-bstring->cstring (enforce 'bstring exp)))
	 ((cchar)
	  (abstract-bchar->cchar (enforce 'bchar exp)))
	 ((cdouble)
	  (abstract-breal->cdouble (enforce 'breal exp)))
	 ((cbool)
	  (abstract-bbool->cbool exp))
	 (else
	  (error "cast-bigloo->foreign" "Unknown foreign type" to)))))

;*---------------------------------------------------------------------*/
;*    cast-foreign->bigloo ...                                         */
;*---------------------------------------------------------------------*/
(define (cast-foreign->bigloo exp from to)
   (case from
      ((cfunction)
       (partial-error "cast-foreign->bigloo" "Illegal cast" from)
       exp)
      ((cint)
       (abstract-cint->bint exp))
      ((cstring)
       (abstract-cstring->bstring exp))
      ((cchar)
       (abstract-cchar->bchar exp))
      ((cdouble)
       (abstract-cdouble->breal exp))
      ((cbool)
       (abstract-cbool->bbool exp))
      ((csymbol)
       (abstract-csymbol->bsymbol exp))
      (else
       (error "cast-foreign->bigloo" "Unknown foreign type" from))))

;*---------------------------------------------------------------------*/
;*    cast-foreign->foreign ...                                        */
;*---------------------------------------------------------------------*/
(define (cast-foreign->foreign exp from to)
   (cond
      ((or (eq? to 'cbool) (eq? to 'cbool))
       ;; tout est castable en 'cbool car tout est booleen C
       exp)
      (else
       (warning (current-function)
		"Illegal foreign cast -- " from " -> " to)
       exp)))

