;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Type/apply.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 29 09:26:52 1993                          */
;*    Last change :  Mon May 10 13:50:31 1993  (serrano)               */
;*                                                                     */
;*    Le module ou on type les formes `apply'                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_apply
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  type_enforce
	    type_cast
	    type_expression
	    type_type
	    tools_error
	    tools_shape
	    heap_abstract
	    scan_lexical
	    engine_param)
   (export (type-apply exp to)))

;*---------------------------------------------------------------------*/
;*    type-apply ...                                                   */
;*---------------------------------------------------------------------*/
(define (type-apply exp to)
   (trace type "type-apply: " (shape exp) #\Newline)
   (let ((fun (cadr exp))
	 class
	 value)
      (cond
	 ((global? fun)
	  (set! class (global-class fun))
	  (set! value (global-value fun)))
	 ((local? fun)
	  (set! class (local-class fun))
	  (set! value (local-value fun)))
	 (else
	  (set! class 'variable)))
      (cond
	 ((eq? class 'foreign)
	  (partial-error ""
			 "A foreign variable can't be `applied'"
			 (shape exp)))
	 ((eq? class 'function)
	  (type-known-bigloo-apply exp value to))
	 (else
	  (type-unknown-bigloo-apply exp to)))))

;*---------------------------------------------------------------------*/
;*    type-known-bigloo-apply ...                                      */
;*    -------------------------------------------------------------    */
;*    Ce type d'application ne correspond pas a un appel calcule. Il   */
;*    suffit ici de destructurer la liste d'arguements.                */
;*    -------------------------------------------------------------    */
;*    On fait une descrimination suivant le nombre d'argument de la    */
;*    fonction.                                                        */
;*---------------------------------------------------------------------*/
(define (type-known-bigloo-apply exp fun to)
   (if (>=fx (function-arity fun) 0)
       (cast (enforce-fx-arity fun exp) 'bobj to)
       (cast (enforce-va-arity fun exp) 'bobj to)))

;*---------------------------------------------------------------------*/
;*    enforce-fx-arity ...                                             */
;*---------------------------------------------------------------------*/
(define (enforce-fx-arity fun exp)
   (trace type "enforce-fx-arity: " (shape exp) #\Newline
	  "   args: " (shape (function-args fun)) #\Newline)
   (let* ((frame    (allocate-local-variables
		      (cons 'aux (map shape (function-args fun)))))
	  (aux      (cdr (car frame)))
	  (formals  (map cdr frame)))
      (trace type "   formals: " (shape formals) #\Newline)
      (local-access-set! aux 'write)
      `(let ,(map (lambda (arg)
		      `(,arg ,(abstract-unspecified)))
		   formals)
	  (begin
	     ,(type-expression `(set! ,aux ,(caddr exp)) 'bobj)
	     ,@(let loop ((auxiliaires (cdr formals)))
		  (if (null? auxiliaires)
		      (if *unsafe-type*
			  (list `(,(cadr exp) ,@(cdr formals)))
			  (list
			   `(cif ,(abstract-null? aux)
				 (,(cadr exp) ,@(cdr formals))
				 (failure ,(list 'quote (current-function))
					  ,(abstract-cstring->bstring
					    "Too many argument provided")
					  ,(list 'quote (shape (cadr exp)))))))
		      (begin
			 (local-access-set! (car auxiliaires) 'write)
			 (append
			  (list (type-expression `(set! ,(car auxiliaires)
							,(abstract-car aux))
						 'bobj)
				(type-expression `(set! ,aux
							,(abstract-cdr aux))
						 'bobj))
			  (loop (cdr auxiliaires))))))))))
	  
;*---------------------------------------------------------------------*/
;*    enforce-va-arity ...                                             */
;*---------------------------------------------------------------------*/
(define (enforce-va-arity fun exp)
   (trace type "enforce-va-arity: " (shape exp) #\Newline
	       "            args: " (shape (function-args fun)) #\Newline)
   (let* ((frame    (allocate-local-variables
		      (map shape (function-args fun))))
	  (aux      (cdr (car (last-pair frame))))
	  (formals  (map cdr frame)))
      (local-access-set! aux 'write)
      `(let ,(map (lambda (arg)
		      `(,arg ,(abstract-unspecified)))
		   formals)
	  (begin
	     ,(type-expression `(set! ,aux ,(caddr exp)) 'bobj)
	     ,@(let loop ((auxiliaires formals)
			  (arity       (function-arity fun)))
		  (if (=fx arity -1)
		      (list `(,(cadr exp) ,@formals))
		      (begin
			 (local-access-set! (car auxiliaires) 'write)
			 (append
			  (list (type-expression `(set! ,(car auxiliaires)
							,(abstract-car aux))
						 'bobj)
				(type-expression `(set! ,aux
							,(abstract-cdr aux))
						 'bobj))
			  (loop (cdr auxiliaires)
				(+fx arity 1))))))))))

;*---------------------------------------------------------------------*/
;*    type-unknown-bigloo-apply ...                                    */
;*---------------------------------------------------------------------*/
(define (type-unknown-bigloo-apply exp to)
   (let ((len (cdar (allocate-local-variables '(len))))
	 (actuals (type-expression (caddr exp) 'bobj)))
      (set-car! (cdr exp) (enforce-procedure
			   (abstract-length len)
			   (type-expression (cadr exp) 'bobj)))
      (set-car! (cddr exp) len)
      `(let ((,len ,actuals))
	  ,(cast exp 'bobj to))))
