;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Tools/speek.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 12 14:06:13 1992                          */
;*    Last change :  Tue May 11 18:22:24 1993  (serrano)               */
;*                                                                     */
;*    Le module ou l'on parle                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_speek
   (import  engine_param)
   (export  (say     . args)
	    (verbose . args)
	    (warning . args)))

;*---------------------------------------------------------------------*/
;*    speek ...                                                        */
;*---------------------------------------------------------------------*/
(define (speek port var args)
   (if var
       (begin
	  (for-each (lambda (v) (display v port)) args)
	  (flush-output-port port))))

;*---------------------------------------------------------------------*/
;*    verbose ...                                                      */
;*---------------------------------------------------------------------*/
(define (verbose . args)
   (speek (current-output-port) *verbose* args))

;*---------------------------------------------------------------------*/
;*    say ...                                                          */
;*---------------------------------------------------------------------*/
(define (say . args)
   (speek (current-output-port) (not *silent*) args))

;*---------------------------------------------------------------------*/
;*    warning ...                                                      */
;*---------------------------------------------------------------------*/
(define (warning . args)
   (speek (current-error-port) *warning* `(#\Newline "*** WARNING:bigloo:"
						     ,(car args)
						     #\Newline
						     ,@(cdr args) #\Newline)))





