;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Tools/hash.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jun 13 15:28:29 1992                          */
;*    Last change :  Fri Mar 19 09:42:06 1993  (serrano)               */
;*                                                                     */
;*    Les fonctions de `hashage'                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_hash
   (foreign (int get-hash-number (string) "get_hash_number"))
   (import  tools_shape)
   (export  (make-hash-table     key type creator identifier printer)
	    (walk-on-hash-table! proc table key)
	    (hashtable?          table key)
	    (find-object         obj env key)
	    (bind-object!        obj env key)
	    (unbind-object!      obj env key)
	    (pp-hashtable        port table key)))

;*---------------------------------------------------------------------*/
;*    table ...                                                        */
;*---------------------------------------------------------------------*/
(define-struct table key type creator identificator printer vector)

;*---------------------------------------------------------------------*/
;*    Une variable static                                              */
;*---------------------------------------------------------------------*/
(define *hash-table-length* 256)

;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Les tables de hashage que je manipule ici sont uniformes.        */
;*    Tous les objects contenues possedent le meme type. C'est donc    */
;*    a la creation des tables qu'on passe les createurs et extracteurs*/
;*    -------------------------------------------------------------    */
;*    Les tables de hash peuvent reperer les objets soit par des       */
;*    symboles soit par des chaines.                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    make-hash-table ...                                              */
;*---------------------------------------------------------------------*/
(define (make-hash-table key type creator identificator printer)
   (if (not (or (eq? type 'symbol) (eq? type 'string)))
       (error "make-hash-table" "Illegal table type" type)
       (let ((table (make-table)))
	  (table-key-set!           table key)
	  (table-type-set!          table type)
	  (table-creator-set!       table creator)
	  (table-identificator-set! table identificator)
	  (table-printer-set!       table printer)
	  (table-vector-set!        table (make-vector *hash-table-length*))
	  table)))

;*---------------------------------------------------------------------*/
;*    hashtable? ...                                                   */
;*    exp x symbol --> { t, f }                                        */
;*---------------------------------------------------------------------*/
(define (hashtable? table key)
   (eq? (table-key table) key))

;*---------------------------------------------------------------------*/
;*    find-object ...                                                  */
;*    { symbol U string } x table x key --> object @ f @ error         */
;*---------------------------------------------------------------------*/
(define (find-object id table key)
   (if (not (hashtable? table key))
       (error "find-symbol" "not an hash-table" table)
       (let* ((symbol-name   (if (eq? (table-type table) 'symbol)
				 (symbol->string id)
				 id))
	      (hash-number   (get-hash-number symbol-name))
	      (bucket        (vector-ref (table-vector table) hash-number))
	      (identificator (table-identificator table)))
	  (let loop ((bucket bucket))
	     (cond
		((null? bucket)
		 #f)
		((eq? (identificator (car bucket)) id)
		 (car bucket))
		((and (eq? (table-type table) 'string)
		      (string=? (identificator (car bucket)) id))
		 (car bucket))
		(else
		 (loop (cdr bucket))))))))

;*---------------------------------------------------------------------*/
;*    bind-object! ..                                                  */
;*    { symbol U string } x table x symbol --> object @ error          */
;*---------------------------------------------------------------------*/
(define (bind-object! id table key)
   (if (not (hashtable? table key))
       (error "bind-symbol!" "not an hash-table" table)
       (let* ((symbol-name   (if (eq? (table-type table) 'symbol)
				 (symbol->string id)
				 id))
	      (hash-number   (get-hash-number symbol-name))
	      (bucket        (vector-ref (table-vector table) hash-number))
	      (identificator (table-identificator table))
	      (creator       (table-creator table)))
	  (cond
	     ((null? bucket)
	      (let ((new (creator id)))
		 (vector-set! (table-vector table) hash-number (list new))
		 new))
	     (else
	      (let loop ((bucket bucket))
		 (cond
		    ((eq? (identificator (car bucket)) id)
		     (car bucket))
		    ((and (eq? (table-type table) 'string)
			  (string=? (identificator (car bucket)) id))
		     (car bucket))
		    ((null? (cdr bucket))
		     ;; cette structure est la derniere et on n'a pas trouve
		     ;; ce qu'on cherchait. Il faut donc creer.
		     (let ((new (creator id)))
			(set-cdr! bucket (list new))
			new))
		    (else
		     (loop (cdr bucket))))))))))

;*---------------------------------------------------------------------*/
;*    unbind-object!  ...                                              */
;*    { symbol U string } x table --> {}                               */
;*---------------------------------------------------------------------*/
(define (unbind-object! id table key)
   (if (not (hashtable? table key))
       (error "unbind-symbol!" "not an hash-table" table)
       (let* ((symbol-name   (if (eq? (table-type table) 'symbol)
				 (symbol->string id)
				 id))
	      (hash-number   (get-hash-number symbol-name))
	      (identificator (table-identificator table))
	      (bucket        (vector-ref (table-vector table) hash-number)))
	  (vector-set! (table-vector table)
		       hash-number
		       (let loop ((bucket bucket))
			  (cond
			     ((null? bucket)
			      '())
			     ((eq? (identificator (car bucket)) id)
			      (cdr bucket))
			     ((and (eq? (table-type table) 'string)
				   (string=? (identificator (car bucket)) id))
			      (cdr bucket))
			     (else
			      (cons (car bucket) (loop (cdr bucket))))))))))
		   
;*---------------------------------------------------------------------*/
;*    pp-hashtable ...                                                 */
;*    port x table x (mask x vector --> ) --> 'done @ error            */
;*---------------------------------------------------------------------*/
(define (pp-hashtable port table key)
   (if (not (hashtable? table key))
       (error "pp-hashtable" "not an hash-table" table)
       (let ((printer (table-printer table)))
	  (let loop ((i 0))
	     (if (=fx i *hash-table-length*)
		 'done
		 (let liip ((bucket (vector-ref (table-vector table) i)))
		    (if (null? bucket)
			(loop (+fx i 1))
			(begin
			   (printer port (car bucket))
			   (liip (cdr bucket))))))))))


;*---------------------------------------------------------------------*/
;*    walk-on-hash-table! ...                                          */
;*    -------------------------------------------------------------    */
;*    On parcours une hash table en appliquant `proc' sur chaque bucket*/
;*---------------------------------------------------------------------*/
(define (walk-on-hash-table! proc table key)
   (if (not (hashtable? table key))
       (error "walk-on-hash-table!" "not an hash-table" table)
       (let loop ((i 0))
	  (if (=fx i *hash-table-length*)
	      'done
	      (begin
		 (proc (vector-ref (table-vector table) i))
		 (loop (+fx i 1)))))))
	    
	    
