;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Tools/error.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 10 14:48:45 1992                          */
;*    Last change :  Tue May 11 15:22:58 1993  (serrano)               */
;*                                                                     */
;*    Les erreurs de `Bigloo'                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_error
   (export  (bigloo-abort          obj obj)
	    (start-partial-error   pass)
	    (partial-error         proc mes obj)
	    (fail-if-partial-error)
	    (enter-function        function-name)
	    (leave-function)
	    (current-function))
   (import  (*bigloo-name*         engine_param)))

;*---------------------------------------------------------------------*/
;*    bigloo-abort ...                                                 */
;*---------------------------------------------------------------------*/
(define (bigloo-abort obj1 obj2)
   (error "bigloo-abort" obj1 obj2)
   (exit -1))

;*---------------------------------------------------------------------*/
;*    Une variable qui memorise le nombre d'erreur                     */
;*---------------------------------------------------------------------*/
(define *nb-partial-error* 0)
(define *partial-pass*     "")

;*---------------------------------------------------------------------*/
;*    start-partial-error ...                                          */
;*---------------------------------------------------------------------*/
(define (start-partial-error pass)
   (set! *partial-pass* pass)
   (set! *nb-partial-error* 0))

;*---------------------------------------------------------------------*/
;*    partial-error ...                                                */
;*---------------------------------------------------------------------*/
(define (partial-error proc mes obj)
   (set! *nb-partial-error* (+fx 1 *nb-partial-error*))
   (if (and (string? proc) (=fx (string-length proc) 0))
       (notify-error (current-function) mes obj)
       (notify-error (string-append (if (string? proc)
					proc
					(symbol->string proc))
				    ":"
				    (if (string? (current-function))
					(current-function)
					(symbol->string
					 (current-function))))
		     mes obj))
   #f)

;*---------------------------------------------------------------------*/
;*    fail-if-partial-error ...                                        */
;*---------------------------------------------------------------------*/
(define (fail-if-partial-error)
   (if (>fx *nb-partial-error* 0)
       (error *partial-pass* *nb-partial-error* "error(s) occurs ending ...")
       #f))

;*---------------------------------------------------------------------*/
;*    Quelle est la fonction qu'on est en train de compiler ?          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    *current-function*                                               */
;*---------------------------------------------------------------------*/
(define *current-function* '("nowhere"))

;*---------------------------------------------------------------------*/
;*    enter-function ...                                               */
;*---------------------------------------------------------------------*/
(define (enter-function function-name)
   (set! *current-function* (cons function-name *current-function*)))

;*---------------------------------------------------------------------*/
;*    leave-function ...                                               */
;*---------------------------------------------------------------------*/
(define (leave-function)
   (if (null? (cdr *current-function*))
       'nothing
       (set! *current-function* (cdr *current-function*))))

;*---------------------------------------------------------------------*/
;*    current-function ...                                             */
;*---------------------------------------------------------------------*/
(define (current-function)
   (car *current-function*))
	 

