;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.2/Tools/alpha.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  9 18:14:20 1993                          */
;*    Last change :  Thu May 13 09:57:21 1993  (serrano)               */
;*                                                                     */
;*    Un petit module qui fait de l'alpha-conversion                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_alpha
    (include "Tools/trace.sch"
	     "Var/variable.sch")
    (import  tools_shape
	     scan_lexical)
    (export  (alphatize body)))

;*---------------------------------------------------------------------*/
;*    name ...                                                         */
;*---------------------------------------------------------------------*/
(define-struct name var)

;*---------------------------------------------------------------------*/
;*    alphatize ...                                                    */
;*---------------------------------------------------------------------*/
(define (alphatize body)
   (trace inline "alphatize: " (shape body) #\Newline)
   (match-case body
      ((atom ?-)
       (if (local? body)
	   (if (name? (local-info body))
	       (name-var (local-info body))
	       body)
	   body))
      ((quote . ?-)
       body)
      ((let ?bindings ?body)
       (let ((new-bindings
	      (let loop ((bindings bindings)
			 (res      '()))
		 (if (null? bindings)
		     res
		     (let* ((binding (car bindings))
			    (new (copy-local-variable (car binding)))
			    (name (make-name)))
			(name-var-set! name new)
			(local-info-set! (car binding) name)
			(loop (cdr bindings)
			      (cons `(,new ,(alphatize (cadr binding)))
				    res)))))))
	  `(let ,new-bindings ,(alphatize body))))
      ((labels ?bindings ?body)
       (let ((new-bindings
	      (let loop ((bindings bindings)
			 (res     '()))
		 (if (null? bindings)
		     res
		     (let* ((binding   (car bindings))
			    (fun       (car binding))
			    (formals   (cadr binding))
			    (body      (caddr binding))
			    (new-fun   (copy-local-variable fun))
			    (name-fun  (make-name))
			    (old-value (local-value fun))
			    (new-value (make-function))
			    (new-fls   (map (lambda (f)
					       (let ((new-f
						      (copy-local-variable f))
						     (name-f (make-name)))
						  (name-var-set! name-f new-f)
						  (local-info-set! f name-f)
						  new-f))
					    formals))
			    new-body)
			(local-info-set! fun name-fun)
			(name-var-set!   name-fun new-fun)
			(set! new-body  (alphatize body))
			(function-arity-set! new-value
					     (function-arity old-value))
			(function-args-set!  new-value new-fls)
			(function-body-set!  new-value new-body)
			(function-escape?-set! new-value (function-escape?
							  old-value))
			(local-value-set! new-fun new-value)
			(loop (cdr bindings)
			      (cons `(,new-fun ,new-fls ,new-body)
				    res)))))))
	  `(labels ,new-bindings ,(alphatize body))))
      (else
       (let liip ((body body)
		  (res  '()))
	  (cond
	     ((null? body)
	      (reverse! res))
	     ((not (pair? body))
	      (reverse! (cons (alphatize body) res)))
	     (else
	      (liip (cdr body)
		    (cons (alphatize (car body)) res))))))))
		 
	       

      
       
