;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.3/Scan/tree.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Apr 13 11:24:06 1993                          */
;*    Last change :  Fri May 14 09:32:13 1993  (serrano)               */
;*                                                                     */
;*    La construction de l'arbre de syntaxe abstraite.                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_tree
   (include "Var/variable.sch"
	    "Scan/temporary.sch"
	    "Tools/trace.sch")
   (import  scan_lexical
	    scan_temporary
	    scan_application
	    scan_let
	    scan_labels
	    scan_bind-exit
	    var_env
	    tools_shape
	    tools_error
	    tools_args
	    heap_abstract
	    engine_param)
   (export  (make-function-tree   parent args body)
	    (make-value-tree      parent value)
	    (make-expression-tree exp site env)
	    (use-local!           local site)
	    get-new-lambda-name))

;*---------------------------------------------------------------------*/
;*    make-function-tree...                                            */
;*---------------------------------------------------------------------*/
(define (make-function-tree parent args body)
   (let* ((frame  (allocate-local-variables args))
	  (body   (make-expression-tree body 'value frame))
	  (res    `(define ,parent (lambda ,(map cdr frame) ,body))))
      (function-body-set! (global-value parent) body)
      (function-args-set! (global-value parent) (map cdr frame))
      res))

;*---------------------------------------------------------------------*/
;*    make-value-tree ...                                              */
;*---------------------------------------------------------------------*/
(define (make-value-tree parent value)
   `(set! ,parent ,(make-expression-tree value 'value '())))

;*---------------------------------------------------------------------*/
;*    make-expression-tree ...                                         */
;*---------------------------------------------------------------------*/
(define (make-expression-tree exp site env)
   (trace init "make-expression-tree: " #\Newline
	        "   exp   : " exp #\Newline
		"   site  : " site #\Newline
		"   env   : " (shape env) #\Newline #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       (cond
	  ((not (symbol? atom))
	   ;; ce n'est pas une variable, on ne fait rien
	   atom)
	  ((lookup? atom env)
	   ;; c'est une variable lexicale.
	   (let ((local (re-lookup-value)))
	      (use-local! local site)
	      local))
	  (else
	   ;; c'est donc une variable globale, on la cherche dans
	   ;; l'environment
	   (let ((global (find-in-global-environment atom *Genv*)))
	      (cond
		 ((not (global? global))
		  ;; il faut creer une variable temporaire
		  (create-temporary atom '() site))
		 ((temporary? (global-info global))
		  ;; c'est deja une variable temporaire, on marque son
		  ;; utilisation.
		  (use-temporary! (global-info global) site)
		  global)
		 ((eq? (global-import global) 'top-level)
		  (set! *eval?* #t)
		  (abstract-eval global))
		 (else
		  (use-global! global site)
		  ;; c'est bon c'est une variable globale normale
		  global))))))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook
			   (make-expression-tree (car hook) 'read env))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (set-car! (cdr exp) (make-expression-tree var 'write env))
       (set-car! (cddr exp) (make-expression-tree val 'read env))
       exp)
;*--- let & letrec ----------------------------------------------------*/
      (((or let letrec) ?- ?-)
       (make-let-tree exp 'read env))
;*--- let' (pour Jean-Marie et ses filtres) ---------------------------*/
      (((let ?- ?body) . ?args)
       (let ((let-part (car exp)))
	  (set-car! (cddr let-part) `(,body ,@args))
	  (make-let-tree let-part 'read env)))
;*--- labels ----------------------------------------------------------*/
      ((labels ?- ?-)
       (make-labels-tree exp 'read env))
;*--- labels' (pour Jean-Marie et ses filtres) ------------------------*/
      (((labels ?- ?body) . ?args)
       (let ((labels-part (car exp)))
	  (set-car! (cddr labels-part) `(,body ,@args))
	  (make-labels-tree labels-part 'read env)))
;*--- lambda ----------------------------------------------------------*/
      ((lambda ?args ?body)
       (let ((name (get-new-lambda-name (arity args))))
	  (make-labels-tree `(labels ((,name ,args ,body))
				,name)
			    'read env)))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (set-car! (cdr exp) (make-expression-tree proc 'read env))
       (set-car! (cddr exp) (make-expression-tree msg 'read env))
       (set-car! (cdddr exp) (make-expression-tree obj 'read env))
       exp)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?-) ?-)
       (make-bind-exit-tree exp 'read env))
;*--- apply -----------------------------------------------------------*/
      ((apply ?proc ?arg)
       (set-car! (cdr exp) (make-expression-tree proc 'apply env))
       (set-car! (cddr exp) (make-expression-tree arg 'read env))
       exp)
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (make-expression-tree test 'read env))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook))
			   (make-expression-tree (cadr (car hook))
						 'read env))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((if ?si ?alors ?sinon)
       (set-car! (cdr exp) (make-expression-tree si 'read env))
       (set-car! (cddr exp) (make-expression-tree alors 'read env))
       (set-car! (cdddr exp) (make-expression-tree sinon 'read env))
       exp)
;*--- application -----------------------------------------------------*/
      (else
       (make-application-tree exp 'read env))))
      
;*---------------------------------------------------------------------*/
;*      get-new-lambda-name ...                                        */
;*---------------------------------------------------------------------*/
(define get-new-lambda-name
   (let ((key -1))
      (lambda (arity)
	 (set! key (+fx key 1))
	 (string->symbol (string-append "lambda_" (integer->string arity)
					"_" (integer->string key))))))
   
;*---------------------------------------------------------------------*/
;*      use-global! ...                                                */
;*---------------------------------------------------------------------*/
(define (use-global! global site)
   (if (abstract-eval? global)
       (set! *eval?* #t))
   (cond
      ((or (eq? site 'application)
	   (eq? site 'apply))
       'ok)
      ((and (eq? site 'write)
	    (eq? (global-class global) 'function))
       (partial-error "use-global!"
		      "A function can't be written"
		      (shape global)))
      (else
       'ok)))

;*---------------------------------------------------------------------*/
;*    use-local! ...                                                   */
;*---------------------------------------------------------------------*/
(define (use-local! local site)
   (cond
      ((or (eq? site 'application)
	   (eq? site 'apply))
       'ok)
      ((eq? site 'write)
       (if (eq? (local-class local) 'function)
	   (partial-error "use-local!"
			  "A function can't be written"
			  (shape local))
	   (local-access-set! local 'write)))))
