;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../temporary.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 19 10:37:51 1993                          */
;*    Last change :  Tue May 11 15:27:06 1993  (serrano)               */
;*                                                                     */
;*    L'environment des liaisons temporaires                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_temporary
   (include "Scan/temporary.sch"
	    "Var/variable.sch")
   (import  tools_shape
	    tools_hash
	    tools_error
	    var_declare
	    var_env
	    engine_param)
   (export  (create-temporary name form access)
	    (use-temporary!   tmp access)
	    (fixe-temporary!)))

;*---------------------------------------------------------------------*/
;*    *temporary-list*                                                 */
;*---------------------------------------------------------------------*/
(define *temporary-list* '())

;*---------------------------------------------------------------------*/
;*    create-temporary ...                                             */
;*---------------------------------------------------------------------*/
(define (create-temporary name form access)
   (let* ((sname (if (string? name)
		     (string->symbol name)
		     name))
	  (global (bind-in-global-environment! sname *Genv*))
	  (tmp    (make-temporary)))
      (if (string? name)
	  (global-c-name-set! global name))
      (if (not (null? form))
	  ;; on n'est pas en train de definir la variable puisque form
	  ;; est nulle.
	  (begin
	     (temporary-form-set! tmp form)
	     (match-case form
		((define-inline (?name . ?args) . ?-)
		 (global-class-set! global 'function)
		 (global-value-set! global
				    (make-global-function 'inline args)))
		((define (?name . ?args) . ?-)
		 (global-class-set! global 'function)
		 (global-value-set! global
				    (make-global-function 'normal args)))
		(else
		 (global-class-set! global 'variable))))
	  (begin
	     (temporary-where-set!  tmp (cons (current-function) '()))
	     (temporary-access-set! tmp access)))
      (global-module-set! global *module-name*)
      (global-import-set! global 'static)
      (global-info-set!   global tmp)
      (set! *temporary-list* (cons global *temporary-list*))
      global))
	     
;*---------------------------------------------------------------------*/
;*    fixe-temporary! ...                                              */
;*    -------------------------------------------------------------    */
;*    Maintenant qu'on a construit l'arbre on sait ce qui est          */
;*    fonction et ce qui est variable, on termine donc les definitions */
;*    des variables static                                             */
;*---------------------------------------------------------------------*/
(define (fixe-temporary!)
   (let loop ((tmp-list *temporary-list*))
      (if (null? tmp-list)
	  ;; on fini en verifiant que le main a la bonne arite
	  (if *main*
	      (let ((main (find-in-global-environment
			   (if (string? *main*)
			       (string->symbol *main*)
			       *main*)
			   *Genv*)))
		 (if (or (not (global? main))
			 (not (eq? (global-class main) 'function))
			 (and (not (=fx (function-arity (global-value main))
					1))
			      (not (<fx (function-arity (global-value main))
					0))))
		     (partial-error ""
				    "Illegal `main' function"
				    *main*))))
	  (let* ((var (car tmp-list))
		 (tmp (global-info var)))
	     (cond
		((null? (temporary-form tmp))
		 ;; si la forme est nulle c'est que la variable est
		 ;; unbound
		 (for-each (lambda (w)
			      (enter-function (shape w))
			      (partial-error ""
					     "Unbound variable"
					     (global-name var))
			      (leave-function))
			   (temporary-where tmp)))
		((eq? (temporary-access tmp) 'write)
		 ;; c'est une variable
		 (global-class-set! var 'variable))
		((function? (global-value var))
		 ;; c'est une fonction
		 (global-class-set! var 'function))
		(else
		 (global-value-set! var '())
		 (global-class-set! var 'variable)))
	     (remove-from-remember-list! (global-name var))
	     (loop (cdr tmp-list))))))

;*---------------------------------------------------------------------*/
;*    use-temporary! ...                                               */
;*---------------------------------------------------------------------*/
(define (use-temporary! tmp access)
   (if (eq? access 'write)
       (temporary-access-set! tmp 'write))
   (if (not (memq (current-function) (temporary-where tmp)))
       (temporary-where-set! tmp (cons (current-function)
				       (temporary-where tmp)))))
	    
   
