;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Scan/labels.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 22 10:33:20 1993                          */
;*    Last change :  Tue Apr 27 17:28:28 1993  (serrano)               */
;*                                                                     */
;*    On construit les formes `labels'                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_labels
   (include "Var/variable.sch")
   (import  scan_lexical
	    scan_tree
	    tools_args)
   (export  (make-labels-tree exp site env)))

;*---------------------------------------------------------------------*/
;*    make-labels-tree ...                                             */
;*---------------------------------------------------------------------*/
(define (make-labels-tree exp site env)
   (let* ((bindings   (cadr exp))
	  (body       (caddr exp))
	  (body-frame (allocate-local-functions (map car bindings)))
	  (new-env    (append body-frame env)))
      ;; on calcule le body
      (set-car! (cddr exp) (make-expression-tree body site new-env))
      ;; on calcule les body de toutes les fonctions locales
      (let loop ((bindings bindings))
	 (if (null? bindings)
	     exp
	     (let* ((local-def      (car bindings))
		    (local-function (cdr (assq (car local-def) new-env)))
		    (local-frame    (allocate-local-variables
				     (cadr local-def))))
		(set-car! local-def local-function)
		(function-arity-set! (local-value local-function)
				     (arity (cadr local-def)))
		(set-car! (cdr local-def) (map cdr local-frame))
		(function-args-set!  (local-value local-function)
				     (cadr local-def))
		(set-car! (cddr local-def) (make-expression-tree
					    (caddr local-def)
					    site
					    (append local-frame new-env)))
		(set-car! bindings local-def)
		(loop (cdr bindings)))))))
      
