;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../definition.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 18 20:08:16 1993                          */
;*    Last change :  Tue Apr 13 18:07:23 1993  (serrano)               */
;*                                                                     */
;*    On scan une definition en commencant par verifier la             */
;*    concordance entre le prototype et la definition.                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_definition
   (include "Var/variable.sch"
	    "Scan/temporary.sch")
   (import  scan_temporary
	    scan_tree
	    engine_param
	    var_env
	    tools_error
	    tools_args
	    tools_shape
	    tools_speek
	    type_misc
	    type_name
	    var_declare)
   (export  (scan-function-definition exp)
	    (scan-value-definition    exp)))

;*---------------------------------------------------------------------*/
;*    scan-function-definition ...                                     */
;*---------------------------------------------------------------------*/
(define (scan-function-definition form)
   (let* ((name   (car (cadr form)))
	  (args   (cdr (cadr form)))
	  (body   (caddr form))
	  (s-name (if (string? name)
		      (string->symbol name)
		      name)))
      (enter-function s-name)
      ;; on supprime la variable de la liste remember
      (remove-from-remember-list! s-name)
      ;; on commence tout de suite par tester si la variable existe
      (let ((old (find-in-global-environment s-name *Genv*)))
	 (if (global? old)
	     (cond
		((not (eq? (global-module old) *module-name*))
		 (partial-error ""
				"Illegal redefinition of variable"
				(shape old)))
		((temporary? (global-info old))
		 (if (not (null? (global-class old)))
		     (partial-error ""
				    "Redefinition of variable"
				    (shape old))
		     (begin
			(global-class-set! old 'function)
			(global-value-set! old (make-global-function
						(if (eq? (car form)
							 'define-inline)
						    'inline
						    'normal)
						args))
			(temporary-form-set! (global-info old) form)
			(let ((res (make-function-tree old args body)))
			   (leave-function)
			   res))))
		((eq? (global-class old) 'variable)
		 (scan-value-definition `(define ,s-name (lambda ,args
							  ,body))))
		((check-function-definition? old
					     'function
					     (if (eq? (car form)
						      'define-inline)
						 #t
						 '())
					     s-name args)
		 (let ((res (make-function-tree old args body)))
		    (leave-function)
		    res))
		(else
		 ;; non, il y a une erreur
		 (partial-error "scan-function-definition"
				"Prototype and definition don't match"
				s-name)))
	     ;; on definie une variable temporaire
	     (let* ((tmp (create-temporary s-name form 'create))
		    (res (make-function-tree tmp args body)))
		(leave-function)
		res)))))
    
;*---------------------------------------------------------------------*/
;*    scan-value-definition ...                                        */
;*---------------------------------------------------------------------*/
(define (scan-value-definition form)
   (let* ((name   (cadr form))
	  (value  (caddr form))
	  (s-name (if (string? name)
		      (string->symbol name)
		      name)))
      (enter-function s-name)
      ;; on supprime la variable de la liste remember
      (remove-from-remember-list! s-name)
      ;; on commence tout de suite par tester si la variable existe
      (let ((old (find-in-global-environment s-name *Genv*)))
	 (if (global? old)
	     (cond
		((temporary? (global-info old))
		 (if (not (null? (global-class old)))
		     (partial-error ""
				    "Redefinition of variable"
				    (shape old))
		     (begin
			(global-class-set! old 'variable)
			(temporary-form-set! (global-info old) form)
			(let ((res (make-value-tree old value)))
			   (leave-function)
			   res))))
		((check-value-definition? old s-name)
		 ;; ok, on scan le value
		 (let ((res (make-value-tree old value)))
		    (leave-function)
		    res))
		(else
		 ;; non, il y a une erreur
		 (partial-error "scan-value-definition"
				"Prototype and definition don't match"
				s-name)))
	     ;; on definie une variable temporaire
	     (let* ((tmp (create-temporary s-name form 'create))
		    (res (make-value-tree tmp value)))
		(leave-function)
		res)))))
   
;*---------------------------------------------------------------------*/
;*    check-function-definition? ...                                   */
;*---------------------------------------------------------------------*/
(define (check-function-definition? global class inline? name args)
   (cond
      ((eq? (global-class global) 'variable)
       #t)
      ((not (eq? (global-class global) class))
       #f)
      (else
       (and (=fx (function-arity (global-value global)) (arity args))
	    (eq? (function-inline? (global-value global)) inline?)))))

;*---------------------------------------------------------------------*/
;*    check-value-definition? ...                                      */
;*---------------------------------------------------------------------*/
(define (check-value-definition? global name)
   (eq? (global-class global) 'variable))
