;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../application.scm ...                                          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 21 11:49:57 1993                          */
;*    Last change :  Mon Jun 21 10:37:58 1993  (serrano)               */
;*                                                                     */
;*    On construit l'arbre d'une application                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_application
   (import  scan_tree
	    scan_let)
   (export  (make-application-tree exp site env)))

;*---------------------------------------------------------------------*/
;*    make-application-tree ...                                        */
;*---------------------------------------------------------------------*/
(define (make-application-tree exp site env)
   (match-case exp
;*--- atom-application ------------------------------------------------*/
      (((atom ?function) . ?args)
       (set-car! exp (make-expression-tree function 'application env))
       (let loop ((hook args))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook
			   (make-expression-tree (car hook) 'read env))
		 (loop (cdr hook)))))
       exp)
;*--- lambda-application ----------------------------------------------*/
      (((lambda ?vars ?body) . ?args)
       (make-let-tree
	`(let ,(let loop ((vars vars)
			  (args args))
		  (cond
		     ((null? vars)
		      '())
		     ((not (pair? vars))
		      (list
		       (list vars
			     (let liip ((args args))
				(if (null? args)
				    '()
				    `(cons ,(car args)
					   ,(liip (cdr args))))))))
		     (else
		      (cons (list (car vars) (car args))
			    (loop (cdr vars) (cdr args))))))
	    ,body)
	site env))
;*--- begin-application -----------------------------------------------*/
      (((begin . ?body) . ?args)
       (make-expression-tree
	`(begin ,@(let loop ((exp body))
		     (cond
			((null? (cdr exp))
			 (list `(,(car exp) ,@args)))
			(else
			 (cons (car exp)
			       (loop (cdr exp)))))))
	site env))
;*--- if-application --------------------------------------------------*/
      (((if ?si ?alors ?sinon) . ?args)
       (let ((args-aux (get-args-aux (length args))))
	  (make-expression-tree
	   `(let ,(map (lambda (aux args)
			  `(,aux ,args))
		       args-aux
		       args)
	       (if ,si
		   (,alors ,@args-aux)
		   (,sinon ,@args-aux)))
	   site env)))
;*--- unknown-application ---------------------------------------------*/
      ((?function . ?args)
       (set-car! exp (make-expression-tree function 'application env))
       (let loop ((hook args))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook
			   (make-expression-tree (car hook) 'read env))
		 (loop (cdr hook))))))))

;*---------------------------------------------------------------------*/
;*      get-args-aux ...                                               */
;*---------------------------------------------------------------------*/
(define (get-args-aux n)
   (let loop ((n   n)
	      (res '()))
      (if (=fx n 0)
	  res
	  (loop (-fx n 1)
		(cons (gensym 'aux) res)))))
   
