;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Rgc/tree.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  3 14:24:53 1992                          */
;*    Last change :  Wed Mar 31 09:38:21 1993  (serrano)               */
;*                                                                     */
;*    L'evaluation de l'arbre syntaxique                               */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc_dfa_tree
   (include "Rgc/tree.sch"
	    "Tools/trace.sch")
   (import  tools_speek)
   (export  (eval-tree   tree na)
	    (vector-grow vec len)))

;*---------------------------------------------------------------------*/
;*    eval-tree ...                                                    */
;*    tree x int --> pos x pos* x store x env x vector x vector        */ 
;*    -------------------------------------------------------------    */
;*    Les structures de constructions de l'arbre et du dfa sont:       */
;*        pos: position dans l'arbre syntaxique                        */
;*        position:   pos       --->  lettre                           */
;*        f-env:      pos       --->  location                         */
;*        f-store:    location  --->  pos*                             */
;*    La plus part des fonctions reg-??? font des effets de bords sur  */
;*    walk. La valeur de walk est juste en entree et doit etre         */
;*    ajustee a la sortie. Toutes fois certaines fonctions ne font     */
;*    que consulter cette variable.                                    */
;*    -------------------------------------------------------------    */
;*    fast-union, comme son nom l'indique calcule l'union entre 2      */
;*    listes. fast-union utilise fast-union-v. fast-union-v croit      */
;*    comme f-env.                                                     */
;*---------------------------------------------------------------------*/
(define (eval-tree tree nb-usr-action)
   (trace parse "eval-tree..." tree #\Newline)
   (let ((store-indice   -1)
	 (env-indice     -1)
	 (walk           #f)
	 (store-len      1023)
	 (env-len        1023)
	 (fast-union-v   (make-vector 1024 #f))
	 (position       (make-vector 1024 '()))
	 (f-env          (make-vector 1024 '()))
	 (f-store        (make-vector 1024 '()))
	 (t-trap         (make-vector nb-usr-action '()))
	 (*rule-num*     (-fx nb-usr-action 1)))
;*---------------------------------------------------------------------*/
;*     fast-union                                                      */
;*---------------------------------------------------------------------*/
      (labels ((fast-union (l1 l2)
			   (trace parse
				  "l1: " l1 #\Newline
				  "l2: " l2 #\Newline)
			   (if (and (not (null? l1))
				    (not (null? l2)))
			       (warning
				"NOT BOTH NULL? in FAST-UNION (passe 2)" '()))
			   (if (null? l1)
			       l2
			       (if (null? l2)
				   l1
				   (let ((max (car l1))
					 (min (car l1)))
				      (labels ((read (l)
						     (if (null? l)
							 '()
							 (let ((c (car l)))
							    (trace parse
								   "c: " c
								   #\Newline
								   "min: " min
								   #\Newline
								   "max: " max
								   #\Newline)
							    (if (<fx c min)
								(set! min c)
								(if (>fx c max)
								    (set! max
									  c)))
							    (vector-set!
							     fast-union-v c #t)
							    (read (cdr l))))))
					 (read l1)
					 (read l2))
				      (let loop ((i   max)
						 (acc '()))
					 (if (<fx i min)
					     acc
					     (if (vector-ref fast-union-v i)
						 (begin
						    (vector-set! fast-union-v
								 i
								 #f)
						    (loop (-fx i 1)
							  (cons i acc)))
						 (loop (-fx i 1)
						       acc))))))))
;*---------------------------------------------------------------------*/
;*     double-position                                                 */
;*---------------------------------------------------------------------*/
	       (double-position ()
				(trace parse "double position.." #\Newline)
				(set! env-len  (*fx 2 env-len))
				(set! position (vector-grow position env-len))
				(set! f-env    (vector-grow f-env    env-len))
				(set! fast-union-v
				      (vector-grow fast-union-v env-len))
				(let loop ((i (+fx 1 (/fx env-len 2))))
				   (trace parse "    dp: " i "  " env-len
					  #\Newline)
				   (if (=fx i env-len)
				       '()
				       (begin
					  (vector-set! fast-union-v i #f)
					  (loop (+fx i 1))))))
;*---------------------------------------------------------------------*/
;*     get-location                                                    */
;*---------------------------------------------------------------------*/
	       (get-location ()
			     (if (=fx store-indice store-len)
				 (begin
				    (set! f-store
					  (vector-grow f-store
						       (*fx 2 store-len)))
				    (let loop ((i (+fx 1 store-len)))
				       (trace parse "  gl: " i "  "
					      (*fx 2 store-len) #\Newline)
				       (if (=fx i (*fx 2 store-len))
					   '()
					   (begin
					      (vector-set! f-store i '())
					      (loop (+fx i 1)))))
				    (set! store-len (*fx 2 store-len))))
			     (begin
				(set! store-indice (+fx 1 store-indice))
				store-indice))
;*---------------------------------------------------------------------*/
;*     get-new-pos                                                     */
;*---------------------------------------------------------------------*/
	       (get-new-pos ()
			    (if (=fx env-indice env-len)
				(double-position))
			    (begin
			       (set! env-indice (+fx 1 env-indice))
			       env-indice))
;*---------------------------------------------------------------------*/
;*     L'evaluateur d'arbre.                                           */
;*     ----------------------------------------------------------      */
;*     Cet evaluateur evalue les arguments de gauche a droite.         */
;*---------------------------------------------------------------------*/
	       (meaning-tree (exp)
			     (trace parse "exp       : " exp #\Newline)
			     (trace parse "   f-env  : " f-env #\Newline
				           "   f-store: " f-store #\Newline)
			     (case (car exp)
				((or)
				 (let* ((a1 (meaning-tree (cadr exp)))
					(a2 (meaning-tree (caddr exp))))
				    (reg-or a1 a2)))
				((concat)
				 (let ((a1 'dummy)
				       (a2 'dummy)
				       (waux walk))
				    (set! walk #f)
				    (set! a1 (meaning-tree (cadr exp)))
				    (set! walk waux)
				    (set! a2 (meaning-tree (caddr exp)))
				    (concat a1 a2)))
				((concat-char)
			  	 (let ((a1 'dummy)
				       (a2 'dummy)
				       (waux walk))
				    (set! walk #f)
				    (set! a1 (meaning-tree (cadr exp)))
				    (set! walk waux)
				    (set! a2 (meaning-tree (caddr exp)))
				    (concat-char a1 a2)))		
				((in)
				 (reg-in (cadr exp)))
				((char)
				 (reg-char (cadr exp)))
				((*)
				 (set! walk #f)
				 (reg-* (meaning-tree (cadr exp))))
				((+)
				 (set! walk #f)
				 (reg-+ (meaning-tree (cadr exp))))
				((epsilon)
				 (reg-epsilon))
				((end)
				 (reg-end (cadr exp)))
				((trap)
				 (reg-trap (cadr exp)
					   (meaning-tree (caddr exp))))
				(else
				 (error "regular-grammar"
					"Unknown function" (car exp)))))
;*---------------------------------------------------------------------*/
;*     reg-or                                                          */
;*---------------------------------------------------------------------*/
	       (reg-or (n1 n2)
		       (let ((node (make-node)))
			  (node-set! node
				     (append (node-firstpos n1)
					     (node-firstpos n2))
				     (append (node-lastpos n1)
					     (node-lastpos n2))
				     (or (node-nullable? n1)
					 (node-nullable? n2))
				     (append (node-f-for-f n1)
					     (node-f-for-f n2))
				     (append (node-l-for-f n1)
					     (node-l-for-f n2)) )
			  node))
;*---------------------------------------------------------------------*/
;*     concat                                                          */
;*---------------------------------------------------------------------*/
	       (concat (n1 n2)
		       (let ((node (make-node)))
;*---- on calcule follow ----------------------------------------------*/
			  (for-each 
			   (lambda (i)
			      (let ( (location (vector-ref f-env i)) )
				 (vector-set! f-store
					      location
					      (append (vector-ref f-store
								  location)
						      (node-firstpos n2)))))
			   (node-l-for-f n1))
;*---- on calcule la racine resultante --------------------------------*/
			  (node-set! node
				     (if (node-nullable? n1)
					 (append (node-firstpos n1)
						 (node-firstpos n2))
					 (node-firstpos n1))
				     (if (node-nullable? n2)
					 (append (node-lastpos n2)
						 (node-lastpos n1))
					 (node-lastpos n2))
				     (and (node-nullable? n1)
					  (node-nullable? n2))
				     (if (node-nullable? n1)
					 (append (node-f-for-f n1)
						 (node-f-for-f n2))
					 (node-f-for-f n1))
				     (if (node-nullable? n2)
					 (append (node-l-for-f n2)
						 (node-l-for-f n1))
					 (node-l-for-f n2)) )
			  node))
;*---------------------------------------------------------------------*/
;*     concat-char                                                     */
;*---------------------------------------------------------------------*/
	       (concat-char (n1 n2)
			    (let ( (node (make-node)) )
;*---- on calcule follow ----------------------------------------------*/
			       (let ( (i (car (node-l-for-f n1))) )
				  (let ( (location (vector-ref f-env i)) )
				     (vector-set! f-store
						  location
						  (append (vector-ref f-store
								      location)
							  (node-firstpos
							   n2)))))
;*---- on calcule la racine resultante --------------------------------*/
			       (node-set! node (node-firstpos n1) 
					  (node-lastpos n2) 
					  #f
					  (node-f-for-f n1)
					  (node-l-for-f n2) )
			       node))
;*---------------------------------------------------------------------*/
;*     reg-in                                                          */
;*---------------------------------------------------------------------*/
	       (reg-in (char*)
		       (trace parse "reg-in: " char* #\Newline)
		       (if (null? (cdr char*))
			   (reg-char (car char*))
			   (let* ((node (reg-char (car char*)))
				  (pos* (let l ((c   (cdr char*))
						(acc '()))
					   (if (null? c)
					       (reverse! acc)
					       (l (cdr c) (cons (get-new-pos)
								acc))))))
			      (node-firstpos-set! node
						  (append (node-firstpos node)
							  pos*))
			      (node-lastpos-set!  node
						  (append (node-lastpos node)
							  pos*))
			      (trace parse "  walk: " walk #\Newline)
			      (let loop ((c*   (cdr char*))
					 (pos* pos*))
				 (if (null? c*)
				     node
				     (begin
					(let ((pos (car pos*)))
					   (vector-set! position pos (car c*))
					   (vector-set! f-env pos walk) )
					(loop (cdr c*) (cdr pos*)) ) ) ) ) ) )
;*---------------------------------------------------------------------*/
;*     reg-char                                                        */
;*---------------------------------------------------------------------*/
	       (reg-char (char)
			 (trace parse "Dans reg-char: " char)
			 (let ((node (make-node))
			       (pos  (get-new-pos)))
			    (vector-set! position pos char)
			    (if walk
				(begin
				   (trace parse " walk: " walk #\Newline)
				   (vector-set! f-env  pos walk)
				   (node-set! node (list pos)
					      (list pos)
					      #f '() '()) )
				(let ((location (get-location)))
				   (trace parse " location: " location
					  #\Newline)
				   (vector-set! f-env pos location)
				   (vector-set! f-store location '())
				   (set! walk location)
				   (node-set! node
					      (list pos)
					      (list pos)
					      #f
					      (list pos)
					      (list pos))))
			    node))
;*---------------------------------------------------------------------*/
;*     compute-follow-*+01                                             */
;*---------------------------------------------------------------------*/
	       (compute-follow-*+01 (node)
		   (let ((firstpos (node-firstpos node)))
		      (for-each 
		       (lambda (i)
			  (let ((location (vector-ref f-env i)))
			     (vector-set!
			      f-store
			      location
			      (fast-union (vector-ref f-store location)
					  firstpos))))
		       (node-l-for-f node))))
;*---------------------------------------------------------------------*/
;*     reg-*                                                           */
;*---------------------------------------------------------------------*/
	       (reg-* (n) 
		      (let ((node (make-node)))
			 (compute-follow-*+01 n)
			 (set! walk #f)
			 (node-set! node (node-firstpos n) 
				    (node-lastpos n) 
				    #t 
				    (node-f-for-f n)
				    (node-l-for-f n))
			 node))
;*---------------------------------------------------------------------*/
;*     reg-+                                                           */
;*---------------------------------------------------------------------*/
	       (reg-+ (n)
		      (trace parse "reg-+..." #\Newline)
		      (trace parse "   f-env  : " f-env #\Newline
			     "   f-store: " f-store #\Newline)
		      (let ((node (make-node)))
			 (trace parse "avant compute-follow-*+01" #\Newline)
			 (compute-follow-*+01 n)
			 (trace parse "apres compute-follow-*+01" #\Newline)
			 (set! walk #f)
			 (node-set! node (node-firstpos n) 
				    (node-lastpos n) 
				    (node-nullable? n)
				    (node-f-for-f n)
				    (node-l-for-f n) )
			 (trace parse "Je retourne le node" #\Newline)
			 node))
;*---------------------------------------------------------------------*/
;*     reg-epsilon                                                     */
;*---------------------------------------------------------------------*/
	       (reg-epsilon ()
			    (let ( (node (make-node))
				   (pos  (get-new-pos)) )
			       (vector-set! position pos 'epsilon)
			       (if walk
				   (begin
				      (vector-set! f-env  pos walk)
				      (node-set! node (list pos)
						 (list pos)
						 #t '() '()) )
				   (let ( (location (get-location)) )
				      (vector-set! f-env pos location)
				      (vector-set! f-store location '())
				      (set! walk location)
				      (node-set! node
						 (list pos)
						 (list pos)
						 #t
						 (list pos)
						 (list pos)) ) )
			       node))
;*---------------------------------------------------------------------*/
;*     reg-end                                                         */
;*---------------------------------------------------------------------*/
	       (reg-end (num)
			(set! *rule-num* (-fx *rule-num* 1))
			(reg-char num))
;*---------------------------------------------------------------------*/
;*     reg-trap                                                        */
;*     -------------------------------------------------------------   */
;*     C'est tres crade mais le numero de la regle qu'on examine est   */
;*     ++ le numero de la regle precedante. Donc des qu'on tombe sur   */
;*     red-end on sauve le nb dans une var globale.                    */
;*     Deplus, comme l'eval se fait de gauche a droite et qu'une regle */
;*     est de la forme (concat exp (marker num)). Il ajouter un pour   */
;*     avoir la vraie valeur de *rule-num*.                            */
;*---------------------------------------------------------------------*/
	       (reg-trap (trap e)
			 (vector-set! t-trap 
				      *rule-num*
				      trap)
			 e))
;*---------------------------------------------------------------------*/
;*     regular-grammar-2                                               */
;*---------------------------------------------------------------------*/
	 ;; Attention le let est indispensable car tree
	 ;; fait des effets de bords
	 ;; sur position f-store...
	 (let ((tree! (meaning-tree tree)))
	    (verbose "         " (+fx 1 store-indice)
		     " positions" #\Newline)
	    (verbose "         " (+fx 1 env-indice)
		     " locations " #\Newline)
	    (vector (node-firstpos tree!)
		    position 
		    f-store 
		    f-env 
		    fast-union-v
		    t-trap)))))

;*---------------------------------------------------------------------*/
;*    node-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (node-set! node first last nullable? f-for-f l-for-f)
   (begin
      (node-firstpos-set!  node first)
      (node-lastpos-set!   node last)
      (node-nullable?-set! node nullable?) 
      (node-f-for-f-set!   node f-for-f)
      (node-l-for-f-set!   node l-for-f)))

;*---------------------------------------------------------------------*/
;*    vector-grow ...                                                  */
;*---------------------------------------------------------------------*/
(define (vector-grow vector len)
   (let ((res     (make-vector len '()))
	 (old-len (vector-length vector)))
      (let loop ((i 0))
	 (if (=fx i old-len)
	     res
	     (begin
		(vector-set! res i (vector-ref vector i))
		(loop (+fx i 1)))))))
