;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../transition.scm ...                                           */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Thu Jun 20 12:42:54 1991                          */
;*    Last change :  Wed Mar 31 09:47:02 1993  (serrano)               */
;*                                                                     */
;*    Les declarations de toutes les transitions                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     le module                                                       */
;*---------------------------------------------------------------------*/
(module rgc_automata_transition
   (include "Tools/trace.sch")
   (import  engine_param
	    rgc_automata_automata
	    rgc_automata_trap
	    rgc_automata_optimize)
   (export  (code-> sn c a)))

;*---------------------------------------------------------------------*/
;*     code-> ... (codage des transitions)                             */
;*     code->: state x (test x new-state) x (state -> accept) -> code  */
;*---------------------------------------------------------------------*/
(define (code-> state-num cell accept?)
   (trace parse "code->: " state-num " cell: " cell #\Newline)
   (let ((new-state (cadr cell)))
      (trace parse "accept?: " (accept? new-state) #\Newline)
      (let ((a* (accept? new-state)))
	 (if (not (null? a*))
	     (if (accept? 'leave-out?)
		 (accept-and-go state-num a* new-state accept?)
		 (accept state-num a*))
	     (if (accept? 'leave-out?)
		 (go state-num new-state)
		 (error "regular-grammar" "Badly formed state" state-num))))))

;*---------------------------------------------------------------------*/
;*     accept-and-go ...                                               */
;*     -----------------------------------------------------------     */
;*     Ce type de transition est un peu complique car c'est ici qu'on  */
;*     fait l'optimisation sur les loopings...                         */
;*---------------------------------------------------------------------*/
(define (accept-and-go state-num a* new-state accept?)
   (trace parse "accept-and-go: trapped?: " (trapped? (car a*)) #\Newline
	         "               looping?: " (looping? new-state accept?)
		 #\Newline)
   (if (not (trapped? (car a*)))
       ;; Ouf, la 1ere regle n'est pas trappee. Il n'y a rien a faire
       (if (looping? new-state accept?)
	   `(,(state->symbol new-state))
	   `(begin
	       (input-port-remember-ref input-port)
	       (,(state->symbol new-state) ,(car a*))) )
       ;; m.. elle l'est.   
       `(cond
	   ,@(let loop ((a* a*))
		(cond
		   ((null? a*)
		    `((else (,(state->symbol new-state) mr))))
		   ((not (trapped? (car a*)))
		    `((else
		       (input-port-remember-ref input-port)
		       (,(state->symbol new-state) ,(car a*)))))
		   (else
		    (let ((trap (trapped? (car a*))))
		       (cons `(,(test-trap (car a*))
			       (input-port-remember-ref input-port)
			       ,(if (eq? trap 'eof)
				    (car a*)
				    `(,(state->symbol new-state)
				      ,(car a*))))
			     (loop (cdr a*))))))) ) ) )

;*---------------------------------------------------------------------*/
;*     accept ...                                                      */
;*---------------------------------------------------------------------*/
(define (accept state-num a*)
   (if (not (trapped? (car a*)))
       ;; Ouf, la 1ere regle n'est pas trappee. Il n'y a rien a faire
       `(begin
	   (input-port-remember-ref input-port)
	   ,(car a*))
       ;; m.. elle l'est.
       `(cond
	   ,@(let loop ( (a* a*) )
		(cond
		   ((null? a*)
		    `((else mr)))
		   ((not (trapped? (car a*)))
		    `((else
		       (input-port-remember-ref input-port)
		       ,(car a*))))
		   (else (cons `(,(test-trap (car a*))
				 (input-port-remember-ref input-port)
				 ,(car a*))
			       (loop (cdr a*))))) ) ) ) )

;*---------------------------------------------------------------------*/
;*     go ...                                                          */
;*---------------------------------------------------------------------*/
(define (go state-num new-state)
   `(,(state->symbol new-state) mr) )
