;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Rgc/cstate.scm ...       */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Thu Jun 20 11:10:10 1991                          */
;*    Last change :  Tue Apr 13 14:20:32 1993  (serrano)               */
;*                                                                     */
;*    La generation des etats compactes                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module rgc_automata_cstate
   (include "Tools/trace.sch")
   (import rgc_automata_transition
	   rgc_automata_automata
	   rgc_automata_optimize
	   engine_param)
   (export (decl-cstate      n a s l e)))

;*---------------------------------------------------------------------*/
;*     decl-cstate ...                                                 */
;*---------------------------------------------------------------------*/
(define (decl-cstate state-name accept? state-num l else-c&t)
   ((if (looping? state-num accept?) code-clooping code-cstate)
       state-name accept? state-num l else-c&t) )

;*---------------------------------------------------------------------*/
;*     code-clooping ...                                               */
;*---------------------------------------------------------------------*/
(define (code-clooping state-name accept? state-num l else-c&t)
   `(,state-name ()
		 (let ((c (input-port-read-char input-port)))
		    (cond
		       (,(car (cdr (car l)))
			(,state-name) )
		       (,(if (c-gt.i *first-char* 1)
			     `(rgc-<? c ,*first-char*)
			     `(rgc-=? c 0))
			(input-port-remember-back-ref input-port)
			(if (input-port-fill-buffer input-port)
			    (,state-name)
			    ,@(accept? state-num)))
		       (else
			(input-port-remember-back-ref input-port)
			,@(accept? state-num))))))
       
;*---------------------------------------------------------------------*/
;*     code-cstate ...                                                 */
;*---------------------------------------------------------------------*/
(define (code-cstate state-name accept? state-num l else-c&t)
   `(,state-name (mr)
		 (let ((c (input-port-read-char input-port)))
		    (cond
		       ,@(cost&test*->body state-num l else-c&t accept?)))))
       
;*---------------------------------------------------------------------*/
;*     cost&test*->body ...                                            */
;*---------------------------------------------------------------------*/
(define (cost&test*->body state-num l else-c&t accept?)
   (trace parse "cost&test*->body: " state-num "   l: " l #\Newline
	  "   else-c&t: " else-c&t #\Newline)
   (let loop ((l l))
      (trace parse "cost&test*->body(loop): " l #\Newline)
      (if (null? l)
	  '()
	  (let ((pr (cdr (car l))))
	     (trace parse "  pr: " pr "  caar: " (car (car l))
		    "   car else: " (car else-c&t) #\Newline)
	     (if (null? (cdr l))
		 ;; Il ne reste plus qu'un test a faire.
		 ;; On test maintenant 'end of buffer' et on regarde
		 ;; s'il est ruse d'inverser le 'else'
		 ;; avec le dernier test.
		 ;; Eventuellement le else peut etre no-else
		 ;; dans ce cas le dernier test est juste transformer en else
		 (if (>fx (car (car l)) (car else-c&t))
		     ;; oui, c'est ruse...
		     (if (not (eq? (cadr else-c&t) 'no-test))
			 ;; il y a effectivement un 'else'
			 (list (code-abort (cadr else-c&t))
			       (code-eofb state-num)
			       (list 'else
				     (code-> state-num pr accept?) ) )
			 ;; il n'y avait pas de 'else'
			 (list (code-eofb state-num)
			       (list 'else
				     (code-> state-num pr accept?) ) ) )
		     ;; non, c'a ne l'est pas...
		     (list (list (car pr)
				 (code-> state-num pr accept?))
			   (code-eofb state-num)
			   (code-abort 'else)) )
		 ;; il reste plusieurs tests a faire
		 (begin
		    (trace parse "code->: " (code-> state-num pr accept?)
			   #\Newline)
		 (cons (list (car pr)
			     (code-> state-num pr accept?))
		       (loop (cdr l)))))))))

;*---------------------------------------------------------------------*/
;*     code-eofb ... (le codage des eof et eob)                        */
;*     code-eofb: --> code                                             */
;*---------------------------------------------------------------------*/
(define (code-eofb state-num)
   `(,(if (c-gt.i *first-char* 1)
	  `(rgc-<? c ,*first-char*)
	  `(rgc-=? c 0))
     (if (input-port-fill-buffer input-port)
	 (,(state->symbol state-num) mr)
	 mr)))

;*---------------------------------------------------------------------*/
;*     code-abort ... (codage des unmatch)                             */
;*     code-abort: test -> code                                        */
;*---------------------------------------------------------------------*/
(define (code-abort test)
   `(,test mr) )


